# ReiACe{NX
# Author:: fukuyama
# Date:: 2008/01/31
# Copyright:: Copyright (c) 2005-2008 rgss-lib

class Item_Container_Base
  def initialize
    @items = []
    @stack_counter = {}
    @stack_types = []
    @stack_items = []
  end

  def add_stack_type(type)
    @stack_types.push type
  end

  def stack_container?
    return (not @stack_types.empty?)
  end

  # ACe擾
  def [](index)
    return @items[index]
  end

  def add_item(item)
    @items.push item
    if not @stack_counter.include?(item.type)
      @stack_counter[item.type] = Hash.new(0)
    end
    @stack_counter[item.type][item.id] += 1
    if stack_container?
      if (not @stack_types.include?(item.type)) or @stack_counter[item.type][item.id] == 1
        @stack_items.push item
      end
    end
  end

  def addit?(parent_item, item)
    return true
  end

  def remove_item(item)
    return false unless @items.include?(item)
    @items.delete(item)
    if not @stack_counter.include?(item.type)
      @stack_counter[item.type] = Hash.new(0)
    end
    @stack_counter[item.type][item.id] -= 1
    if @stack_counter[item.type][item.id] < 0
      @stack_counter[item.type][item.id] = 0
    end
    if stack_container?
      if @stack_types.include?(item.type)
        # X^bNACecĂꍇ
        if @stack_counter[item.type][item.id] > 0
          i = @stack_items.index(item)
          # ƂĂACeX^bNACeɑ݂ꍇ́Aւ
          if not i.nil?
            @items.each do |item1|
              if item.type == item1.type and item.id == item1.id
                @stack_items[i] = item1
                break
              end
            end
          end
        end
      else
        # X^bNACeł͖́A폜
        @stack_items.delete(item)
      end
      if @stack_counter[item.type][item.id] == 0
        @stack_counter[item.type].delete(item.id)
        @stack_items.delete(item)
      end
    end
    return true
  end

  def removeit?(parent_item, item)
    return @items.include?(item)
  end

  # ACe̊mF
  def include?(item)
    return @items.include?(item)
  end

  # ACeꗗ
  def each_item
    @items.each(&proc)
  end

  def each_stack_item
    @stack_items.each(&proc)
  end

  # ACẽ\[g
  def sort!
    @items.sort!(&proc)
    @stack_items.sort!(&proc)
  end

  # ACe̐
  def item_count
    return @items.size
  end

  # ACe̐
  def item_count_id(id,type)
    if not @stack_counter.include?(type)
      @stack_counter[type] = Hash.new(0)
    end
    return @stack_counter[type][id]
  end

  # ReiTCY(-1 )
  def size
    return -1
  end
end

module Container_Item_Module

  attr_reader :container
  # Rei
  def container=(container)
    @container = container
  end

  # ReiH
  def container?
    return (not @container.nil?)
  end

  # ACeǉ
  def addit?(item)
    return @container.addit?(self, item)
  end

  # ACeǉ
  def add_item(item)
    if addit?(item)
      @container.add_item(item)
      return true
    end
    return false
  end

  # ACe폜
  def removeit?(item)
    return @container.removeit?(self, item)
  end

  # ACe폜
  def remove_item(item)
    if removeit?(item)
      @container.remove_item(item)
      return true
    end
    return false
  end

  # ACe̊mF
  def include?(item)
    return @container.include?(item)
  end

  # ACeꗗ
  def each_item
    @container.each_item(&proc)
  end

  def each_stack_item
    @container.each_stack_item(&proc)
  end

  # ACẽ\[g
  def sort!
    @container.sort!(&proc)
  end

  # ACe̐
  def item_count
    return @container.item_count
  end

  # ACe̐
  def item_count_id(id,type)
    return @container.item_count_id(id,type)
  end

end
