# Train_Actor::Game_Party_Module
# Game_PartypsW[
# Author:: fukuyama
# Date:: 2007/12/31
# Copyright:: Copyright (C) 2005-2007 rgss-lib

module Train_Actor

  module Game_Party_Module
    attr_reader :characters
    def dead_actor_include?
      for actor in actors
        if actor.dead?
          return true
        end
      end
      return false
    end
    def get_active_party_order
      if not dead_actor_include?
        return actors
      end
      alive_actors = []
      dead_actors = []
      for actor in actors
        if actor.dead?
          dead_actors.push actor
        else
          alive_actors.push actor
        end
      end
      return alive_actors + dead_actors
    end
    def setup_actor_character_sprites
      if @characters.nil?
        @characters = []
        for i in 1 ... TRAIN_ACTOR_SIZE_MAX
          @characters.push(Game_Party_Actor.new(i - 1))
        end
      end
      setup_actors = get_active_party_order
      for i in 1 .. @characters.size
        @characters[i - 1].setup(setup_actors[i])
      end
      if $scene.class.method_defined?('setup_actor_character_sprites')
        $scene.setup_actor_character_sprites(@characters)
      end
    end
    def transparent_switch
      if TRANSPARENT_SWITCH
        unless $game_player.transparent
          return $game_switches[TRANSPARENT_SWITCHES_INDEX]
        end
      end
      return $game_player.transparent
    end
    def update_party_actors
      setup_actor_character_sprites
      transparent = transparent_switch
      for character in @characters
        character.transparent = transparent
        character.update
      end
    end
    def moveto_party_actors( x, y )
      setup_actor_character_sprites
      for character in @characters
        character.moveto( x, y )
      end
      @move_list = []
      move_list_setup
    end
    def move_party_actors
      if @move_list == nil
        @move_list = []
        move_list_setup
      end
      @move_list.each_index do |i|
        if not @characters[i].nil?
          @characters[i].add_move_list_element(@move_list[i])
        end
      end
    end
    class Move_List_Element
      def initialize(type,args)
        @type = type
        @args = args
      end
      def type() return @type end
      def args() return @args end
    end
    def move_list_setup
      for i in 0 .. TRAIN_ACTOR_SIZE_MAX
        @move_list[i] = nil
      end
    end
    def add_move_list(type,*args)
      @move_list.unshift(Move_List_Element.new(type,args)).pop
    end
    def move_down_party_actors(turn_enabled = true)
      move_party_actors
      add_move_list(Input::DOWN,turn_enabled)
    end
    def move_left_party_actors(turn_enabled = true)
      move_party_actors
      add_move_list(Input::LEFT,turn_enabled)
    end
    def move_right_party_actors(turn_enabled = true)
      move_party_actors
      add_move_list(Input::RIGHT,turn_enabled)
    end
    def move_up_party_actors(turn_enabled = true)
      move_party_actors
      add_move_list(Input::UP,turn_enabled)
    end
    def move_lower_left_party_actors
      move_party_actors
      add_move_list(DOWN_LEFT)
    end
    def move_lower_right_party_actors
      move_party_actors
      add_move_list(DOWN_RIGHT)
    end
    def move_upper_left_party_actors
      move_party_actors
      add_move_list(UP_LEFT)
    end
    def move_upper_right_party_actors
      move_party_actors
      add_move_list(UP_RIGHT)
    end
    def jump_party_actors(x_plus, y_plus)
      move_party_actors
      add_move_list(JUMP,x_plus, y_plus)
      move_stop_party_actors
    end
    def move_stop_party_actors
      actors.each do |a|
        move_party_actors
        add_move_list(STOP)
      end
    end
  end

end

class Game_Party
  include Train_Actor::Game_Party_Module

  # AN^[
  # actor_id:: AN^[ ID
  def add_actor(actor_id)
    # AN^[擾
    actor = $game_actors[actor_id]
    # p[eBl 4 lŁÃAN^[p[eBɂȂꍇ
    if @actors.size < Train_Actor::TRAIN_ACTOR_SIZE_MAX and not @actors.include?(actor)
      # AN^[ǉ
      @actors.push(actor)
      # vC[tbV
      $game_player.refresh
    end
  end
end
