# Train_Actor::Game_Party_Actor
# }bṽp[eBpLN^[
# Author:: fukuyama
# Date:: 2007/12/31
# Copyright:: Copyright (C) 2005-2007 rgss-lib

module Train_Actor

  class Game_Party_Actor < Game_Character
    def initialize(character_index)
      super()
      @character_index = character_index
      @character_wait = 0
      @through = true
      # sxƍ@
      @opacity = 255
      @blend_type = 0
      @move_list = []
    end
    def setup(actor)
      # LN^[̃t@CƐFݒ
      if actor.nil?
        @character_name = ""
        @character_hue = 0
      elsif not actor.dead? # łꍇƂ肠AƂc
        @character_name = actor.character_name
        @character_hue = actor.character_hue
      else
        @character_name = DEAD_CHARACTER_NAME
        @character_hue = 0
      end
    end
    def update
      @move_speed = $game_player.move_speed
      @step_anime = $game_player.step_anime
      @opacity = $game_player.opacity
      @blend_type = $game_player.blend_type
      @direction_fix = $game_player.direction_fix
      if @direction_fix
        @direction = $game_player.direction
      end
      update_move_list()
      super
    end
    def screen_z(height = 0)
      if $game_player.screen_z(height) == 999
        return 998
      end
      if $game_player.x == @x and $game_player.y == @y
        super(height) - 1
      else
        super(height)
      end
    end
    def add_move_list_element(element)
      @move_list.push(element)
      if @move_list.size == 1
        update_move_list()
      end
    end
    def move_list_size
      return @move_list.size
    end
    def update_move_list()
      return if moving?
      return if @move_list.empty?
      if @move_list[0].type == STOP
        if @character_index != 0
          character = $game_party.characters[@character_index - 1]
          if character.x == @x and character.y == @y and character.direction == @direction
            @character_wait = 128 / (2 ** @move_speed) + 1
            while character.move_list_size < @move_list.size and @move_list[0].type == STOP
              @move_list.shift
            end
          end
        end
      else
        @character_wait = 0
      end
      if @character_wait > 0
        @character_wait -= 1
        return
      end
      element = @move_list.shift
      while element.type == STOP
        element = @move_list.shift
      end
      case element.type
      when Input::DOWN
        move_down(element.args[0])
      when Input::LEFT
        move_left(element.args[0])
      when Input::RIGHT
        move_right(element.args[0])
      when Input::UP
        move_up(element.args[0])
      when DOWN_LEFT
        move_lower_left
      when DOWN_RIGHT
        move_lower_right
      when UP_LEFT
        move_upper_left
      when UP_RIGHT
        move_upper_right
      when JUMP
        jump(element.args[0],element.args[1])
      end
    end
    def moveto( x, y )
      @move_list.clear
      super(x, y)
    end
    #--------------------------------------------------------------------------
    #  Ɉړ
    #     turn_enabled : ̏ł̌ύXtO
    #--------------------------------------------------------------------------
    def move_down(turn_enabled = true)
      # 
      if turn_enabled
        turn_down
      end
      # ʍs\ȏꍇ
      if passable?(@x, @y, Input::DOWN)
        # 
        turn_down
        # WXV
        @y = (@y + 1 + $game_map.height) % ($game_map.height)
        @real_y = (@y - 1) * 128
      end
    end
    #--------------------------------------------------------------------------
    #  Ɉړ
    #     turn_enabled : ̏ł̌ύXtO
    #--------------------------------------------------------------------------
    def move_left(turn_enabled = true)
      # 
      if turn_enabled
        turn_left
      end
      # ʍs\ȏꍇ
      if passable?(@x, @y, Input::LEFT)
        # 
        turn_left
        # WXV
        @x = (@x - 1 + $game_map.width) % ($game_map.width)
        @real_x = (@x + 1) * 128
      end
    end
    #--------------------------------------------------------------------------
    #  EɈړ
    #     turn_enabled : ̏ł̌ύXtO
    #--------------------------------------------------------------------------
    def move_right(turn_enabled = true)
      # E
      if turn_enabled
        turn_right
      end
      # ʍs\ȏꍇ
      if passable?(@x, @y, Input::RIGHT)
        # E
        turn_right
        # WXV
        @x = (@x + 1 + $game_map.width) % ($game_map.width)
        @real_x = (@x - 1) * 128
      end
    end
    #--------------------------------------------------------------------------
    #  Ɉړ
    #     turn_enabled : ̏ł̌ύXtO
    #--------------------------------------------------------------------------
    def move_up(turn_enabled = true)
      # 
      if turn_enabled
        turn_up
      end
      # ʍs\ȏꍇ
      if passable?(@x, @y, Input::UP)
        # 
        turn_up
        # WXV
        @y = (@y - 1 + $game_map.height) % ($game_map.height)
        @real_y = (@y + 1) * 128
      end
    end
  end

end
