# og[XLǗNX
# Author:: fukuyama
# Date:: 2007/10/08
# Copyright:: Copyright (C) 2007 rgss-lib

class Game_Battler_Skill
  
  attr_reader :all_skills           # S
  
  attr_reader :attack_skills        # UXL
  attr_reader :magic_skills         # @XL
  attr_reader :recover_skills       # 񕜃XL
  attr_reader :state_cancel_skills  # ԉ񕜃XL
  
  attr_reader :attack_up_skills     # U̓Abv
  attr_reader :attack_down_skills   # U̓_E
  attr_reader :magic_up_skills      # @U̓Abv
  attr_reader :magic_down_skills    # @U̓_E
  attr_reader :pdef_up_skills       # h̓Abv
  attr_reader :pdef_down_skills     # h̓_E
  attr_reader :mdef_up_skills       # @h̓Abv
  attr_reader :mdef_down_skills     # @h̓_E
  attr_reader :hit_up_skills        # ̓Abv
  attr_reader :hit_down_skills      # ̓_E
  attr_reader :eva_up_skills        # 𗦃Abv
  attr_reader :eva_down_skills      # 𗦃_E
  
  attr_reader :magic_blockade_skills  # @
  attr_reader :action_blockade_skills # s
  
  # TODO
  # E
  # ŁEXbv_[W
  # 
  # ω
  
  # 
  def initialize(battler=nil)
    @all_skills = []
    
    @attack_skills = []
    @magic_skills = []
    @recover_skills = []
    @state_cancel_skills = []
    
    @attack_up_skills = []
    @attack_down_skills = []
    @magic_up_skills = []
    @magic_down_skills = []
    @pdef_up_skills = []
    @pdef_down_skills = []
    @mdef_up_skills = []
    @mdef_down_skills = []
    @hit_up_skills = []
    @hit_down_skills = []
    @eva_up_skills = []
    @eva_down_skills = []
    
    @magic_blockade_skills = []
    @action_blockade_skills = []
    
    if not battler.nil?
      skill_initialize(battler)
    end
  end
  
  # 폜
  def clear
    @all_skills.clear
    
    @attack_skills.clear
    @magic_skills.clear
    @recover_skills.clear
    @state_cancel_skills.clear
    
    @attack_up_skills.clear
    @attack_down_skills.clear
    @magic_up_skills.clear
    @magic_down_skills.clear
    @pdef_up_skills.clear
    @pdef_down_skills.clear
    @mdef_up_skills.clear
    @mdef_down_skills.clear
    @hit_up_skills.clear
    @hit_down_skills.clear
    @eva_up_skills.clear
    @eva_down_skills.clear
    
    @magic_blockade_skills.clear
    @action_blockade_skills.clear
  end
  
  # 
  def skill_initialize(battler)
    # 퓬ɎgpłXL
    skill_list = Skill_Facade.actor_battle_skills(battler)
    skill_list.each do |skill|
      @all_skills.push skill
      
      # gpłȂ̂͌₩폜
      # FIXME gǁA͕ނɓOׂ
      next if not battler.skill_can_use?(skill.id)
      
      # _[WGɗ^
      if skill.scope_enemy? and skill.damage_skill?
        # UXL
        if skill.attack_skill?
          @attack_skills.push skill
        end
        # @XL
        if skill.magic_skill?
          @magic_skills.push skill
        end
      end
      # 񕜃XL
      if skill.scope_friend? and skill.recover_skill? and (not skill.scope_hp0?)
        @recover_skills.push skill
      end
      # ԉ񕜃XL
      if skill.scope_friend? and skill.state_cancel_skill?
        @state_cancel_skills.push skill
      end
      # ԕωXL
      if skill.state_add_skill?
        hit_rate   = 100.0
        maxhp_rate = 100.0
        maxsp_rate = 100.0
        str_rate   = 100.0
        dex_rate   = 100.0
        agi_rate   = 100.0
        int_rate   = 100.0
        atk_rate   = 100.0
        pdef_rate  = 100.0
        mdef_rate  = 100.0
        eva        = 0
        magic_blockade = false
        action_blockade = false
        skill.plus_state_set.each do |state_id|
          state = $data_states[state_id]
          hit_rate   *= state.hit_rate   / 100.0
          maxhp_rate *= state.maxhp_rate / 100.0
          maxsp_rate *= state.maxsp_rate / 100.0
          str_rate   *= state.str_rate   / 100.0
          dex_rate   *= state.dex_rate   / 100.0
          agi_rate   *= state.agi_rate   / 100.0
          int_rate   *= state.int_rate   / 100.0
          atk_rate   *= state.atk_rate   / 100.0
          pdef_rate  *= state.pdef_rate  / 100.0
          mdef_rate  *= state.mdef_rate  / 100.0
          eva        += state.eva
          #  (0:ȂA1:@gpłȂA2:GʏUA3:ʏUA4:słȂ) 
          magic_blockade = true if state.restriction == 1
          action_blockade = true if state.restriction == 4
        end
        
        # FIXME ͂ȒlƓȁc
        if str_rate > 100.0 or atk_rate > 100.0
          @attack_up_skills.push skill
        end
        if str_rate < 100.0 or atk_rate < 100.0
          @attack_down_skills.push skill
        end
        if int_rate > 100.0
          @magic_up_skills.push skill
        end
        if int_rate < 100.0
          @magic_down_skills.push skill
        end
        if pdef_rate > 100.0
          @pdef_up_skills.push skill
        end
        if pdef_rate < 100.0
          @pdef_down_skills.push skill
        end
        if mdef_rate > 100.0
          @mdef_up_skills.push skill
        end
        if mdef_rate < 100.0
          @mdef_down_skills.push skill
        end
        if hit_rate > 100.0
          @hit_up_skills.push skill
        end
        if hit_rate < 100.0
          @hit_down_skills.push skill
        end
        if eva > 100.0
          @eva_up_skills.push skill
        end
        if eva < 100.0
          @eva_down_skills.push skill
        end
        
        if magic_blockade
          @magic_blockade_skills.push skill
        end
        if action_blockade
          @action_blockade_skills.push skill
        end
      end
      
    end
  end
  
end
