# ACe𔃂EBhE(Window_Shop)
# Author:: fukuyama
# Date:: 2010/07/31
# Copyright (C) 2005-2010 rgss-lib

module DQ
  class Window_Shop < ::DQ::Window_Page_Menu
    include Window_Tree_Module
    def initialize(shop_goods)
      @price_rate = 100
      for item in shop_goods
        if not item.nil?
          add_menu(item,:select_item)
        end
      end
      @column_max = 1
      @row_max = WINDOW_SHOP_BUY_ROW_MAX
      @index = 0
      super(nil)
      self.top = 16
      self.left = 16

      @window_gold = Window_Gold.new
      @window_gold.x = 640 - @window_gold.width - 16
      @window_gold.y = 16
      @window_gold.back_opacity = self.back_opacity
      add_child @window_gold

      @window_shop_status = Window_Shop_Actor_Status.new(self)
      @window_shop_status.back_opacity = self.back_opacity
      @window_shop_status.set_item self.item
      add_child @window_shop_status

      # ACewvEBhE쐬
      w = 640 - self.right - 16
      h = 240
      @window_help = Window_Markup_Text.new(0,0,w,h)
      @window_help.top = @window_gold.bottom
      @window_help.left = self.right
      @window_help.back_opacity = self.back_opacity
      add_child @window_help

      add_input_handler(Input::UP,:select_chenge)
      add_input_handler(Input::DOWN,:select_chenge)
      add_input_handler(Input::LEFT,:select_chenge)
      add_input_handler(Input::RIGHT,:select_chenge)
      refresh_help
    end

    def price_rate=(rate)
      @price_rate = rate
      refresh
    end

    def item
      return get_menu
    end

    def select_item
      price = (item.price * (@price_rate.to_f / 100.0)).to_i
      if price > $game_party.gold
        buzzer_se
        return
      end
      decision_se
      dispose
    end

    def refresh_help
      if (not @window_help.nil?) and (not @window_help.disposed?)
        if not self.item.nil?
          text = self.item.description.dup
          @window_help.set_text text
        else
          @window_help.set_text ""
        end
      end
    end

    def select_chenge
      @window_shop_status.set_item self.item
      refresh_help
    end

    def input_b
      if event_handling_trigger?
        @index = -1
      end
      super
    end

    #--------------------------------------------------------------------------
    # ڂ̕`
    #--------------------------------------------------------------------------
    def draw_menu_item(index,color,rect,item)
      # ivZ
      price = (item.price * (@price_rate.to_f / 100.0)).to_i
      # ȂꍇAFύX
      if price <= $game_party.gold
        self.contents.font.color = color
      else
        self.contents.font.color = disabled_color
      end

      self.contents.fill_rect(rect, Color.new(0, 0, 0, 0))
      # ACR\
      if (not item.icon_name.nil?) and (not item.icon_name.empty?)
        bitmap = RPG::Cache.icon(item.icon_name)
        opacity = self.contents.font.color == normal_color ? 255 : 128
        self.contents.blt(rect.x, rect.y, bitmap, Rect.new(0, 0, 24, 24), opacity)
        rect.x += 24
        rect.width -= 24
      end
      self.contents.draw_text(rect, item.name, 0)
      self.contents.draw_text(rect, price.to_s, 2)
    end

    #---------------------------------------------------------------------------
    # Rec̍쐬
    def _contents_width
      return _menu_width * @column_max
    end

    #---------------------------------------------------------------------------
    # j[̍쐬
    def _menu_width
      return WINDOW_SHOP_BUY_WIDTH
    end
  end

end
