# Markup_Shops_Word
# Xp}[NAbv
#
# \buy_item ACeւ̒u
# \buy_price ACeւ̒li
#
# Author:: fukuyama
# Date:: 2010/08/08
# Copyright:: Copyright (c) 2010 rgss-lib

module Markup_Buy_Item
  module_function
  def query
    return /\\buy[\._]item/
  end

  def transfer(obj, text, match)
    shop = Event_Script::Shop
    if shop.item?
      item = shop.item
      text[query] = "\\item.img\[#{item.id}\]#{item.name}"
    elsif shop.weapon?
      item = shop.weapon
      text[query] = "\\weapon.img\[#{item.id}\]#{item.name}"
    elsif shop.armor?
      item = shop.armor
      text[query] = "\\armor.img\[#{item.id}\]#{item.name}"
    end
  end
end

module Markup_Buy_Price
  module_function
  def query
    return /\\buy[\._]price/
  end

  def transfer(obj, text, match)
    shop = Event_Script::Shop
    text[query] = shop.buy_price.to_s
  end
end

String_Replace_Module.add_markup(Markup_Buy_Item)
String_Replace_Module.add_markup(Markup_Buy_Price)
