# Sprite_Message
#
# bZ[WcpɃXN[邽߂̃XvCgłB
# cN[Őݒ肵s͑SĖꎩIɉs܂B
#
# Ƃ肠
# 'v''B'ŉsB
# 'u'܂łs̃CfgƂB('auto'̏ꍇ)
#
# Author:: fukuyama
# Date:: 2008/04/20
# Copyright:: Copyright (c) 2006 fukuyama

# Sprite_Message
class Sprite_Message < Sprite
  include String_Replace_Module
  include String_Operation_Module
  include Shake_Module

  # tHg
  unless defined? FIXED_FONT_NAME
    if Font.exist?('Ume Gothic')
      FIXED_FONT_NAME = 'Ume Gothic'
    else
      FIXED_FONT_NAME = 'lr SVbN'
    end
  end

  # Cfg
  #INDENT = 'auto'
  #INDENT = 30
  INDENT = [2,'em']

  # bZ[Wuԕ\L[
  MESSAGE_NO_WAIT_KEY = [Input::C] unless defined? MESSAGE_NO_WAIT_KEY

  # bZ[WXLbvL[
  MESSAGE_SKIP_KEY = [Input::A] unless defined? MESSAGE_SKIP_KEY

  # ֑
  LINE_TAIL_NG_WORD = '$([\{\egqsuwykimo'
  LINE_HEAD_NG_WORD = '!%),.:;?]}IjCDABFGHnprtvxzl@BDFHbE[TURSX'

  # Cfg
  AUTO_INDENT_WORD = 'u'
  AUTO_INDENT_CLEAR_WORD = 'v'
  AUTO_NEW_LINE_WORD = 'Bv'

  attr_accessor :no_wait
  attr_accessor :auto_skip
  attr_accessor :ay
  attr_accessor :message_wait
  attr_accessor :message_speed
  attr_accessor :scroll_speed

  # IuWFNg
  def initialize(x, y, width, height, line_max)
    super()
    self.bitmap = Bitmap.new(width, height * 2)
    self.bitmap.font.name = FIXED_FONT_NAME
    self.visible = false
    self.x = x
    self.y = y
    self.z = 9999
    self.src_rect.height = height

    @line_height = height / line_max # s̍

    # bZ[WXs[hi낢댟j
    @message_speed     = $game_system.user_default_map_message_speed

    @no_wait           = false # bZ[WEFCg}
    @auto_skip         = false # I[gXLbv
    @scroll_speed      = 6     # XN[Xs[h
    @skip_scroll_speed = 1     # XLbṽXN[Xs[h

    # ֑
    @line_head_ng_words = LINE_HEAD_NG_WORD.split(//)
    @line_tail_ng_words = LINE_TAIL_NG_WORD.split(//)

    # sCfg
    @auto_indent_words = AUTO_INDENT_WORD.split(//)
    @auto_indent_clear_words = AUTO_INDENT_CLEAR_WORD.split(//)
    @auto_new_line_words = AUTO_NEW_LINE_WORD.split(//)

    clear
  end

  # bZ[W\ǂ
  def showing?
    update_shake
    return (@scroll_up != 0 or @message.size != 0)
  end

  # XLbv邩ǂ
  def skip?
    return ((MESSAGE_SKIP_KEY.any? {|k| Input.press?(k)}) or @auto_skip)
  end

  def no_wait?
    result = @no_wait
    if MESSAGE_NO_WAIT_KEY.any? {|k| Input.trigger?(k)}
      Input.update
      result = true
    end
    return result
  end

  # XvCgNA
  def clear
    self.bitmap.clear
    self.src_rect.y = 0
    @message = '' # \bZ[W
    @cx = 0 # Jg`ʒux
    @cy = 0 # Jg`ʒuy
    @ay = 0 # \Jn`ʒuy
    @scroll_up = 0 # XN[pJE^
    @indent = 0 # Cfg
    @message_wait = 0
  end

  # tF[hC
  def fade_in(n)
    if not self.visible
      self.visible = true
    end
    if (self.opacity + 48) > 255
      self.opacity = 255
    else
      self.opacity += 48
    end
    return self.opacity == 255
  end

  # tF[hAEg
  def fade_out(n)
    if (self.opacity - 48) <= 0
      self.opacity = 0
    else
      self.opacity -= 48
    end
    if self.opacity == 0
      self.visible = false
      clear
    end
    return self.opacity == 0
  end

  # 
  def dispose
    if self.bitmap != nil
      self.bitmap.dispose
    end
    super
  end

  # bZ[WI
  def terminate_message
  end

  # bZ[Wݒ
  def message=(text)
    @message = markup_replace(text)
    @message.gsub!(/\n/) {} # s폜
    @ay = @cy # \sۑ
    @py = @cy
  end

  # XN[Xs[h̎擾
  def scroll_speed
    if skip?
      return @skip_scroll_speed
    end
    return @scroll_speed
  end

  # rbg}bv
  def bitmap_initialize
    # XN[IbZ[WSĕ\Ăꍇ
    if @scroll_up <= 0 and @message.size == 0
      # XN[rbg}bv̈ԏɂăXN[ʒu
      @scroll_up = 0
      r = self.bitmap.rect
      r.y = @ay
      bmp = self.bitmap.dup
      self.bitmap.clear
      self.bitmap.blt(0, 0, bmp, r)
      self.bitmap.fill_rect(0, 0, bmp.width, 1, Color.new(0,0,0,0))
      self.src_rect.y = 0
      bmp.dispose
      @cy = @cy - @ay
      @ay = 0
    end
  end

  # XN[
  def update_scroll
    # XN[
    if @scroll_up > 0 and (@ay != self.src_rect.y)
      n = 0
      if self.scroll_speed != 0
        n = @line_height / self.scroll_speed
        n = @scroll_up if @scroll_up < n
      else
        n = @line_height
      end
      n = 1 if n <= 0
      self.src_rect.y += n
      @scroll_up -= n
      bitmap_initialize
      return true
    end

    return false
  end

  # t[XV
  def update
    # EFCg
    if @message_wait > 0
      @message_wait -= 1
      return
    end

    super

    # XN[
    if update_scroll
      return
    end
    if @ay != self.src_rect.y
      # \͈͂𒴂ĂꍇA܂ŃXN[
      if (self.src_rect.y + self.src_rect.height) <= @cy
        @scroll_up = @line_height
        return
      end

      # cy ĂXN[
      if @cy != @py
        @scroll_up = @line_height
        @py = @cy
        return
      end
    end

    if no_wait?
      # bZ[Wuԕ\
      draw_message(@message.size)
    elsif skip?
      # bZ[WXLbv
      draw_message_all()
    elsif @message_speed <= 0
      # bZ[W`
      @message_wait = @message_speed.abs
      draw_message()
    else
      draw_message(@message_speed.abs)
    end

    # \bZ[WȂ
    if @message.size == 0
      # \bZ[Wԏɗ悤ɃXN[
      @scroll_up = @ay - self.src_rect.y
      bitmap_initialize
      return
    end
  end

  # bZ[W`
  def draw_message(n=0)
    for i in 0 .. n
      # c  1 擾
      c = get_char()
      return if c.nil?
      return if not draw_char(c)
    end
  end

  # bZ[WSĕ`悷
  def draw_message_all
    while(not @message.empty?)
      # c  1 擾
      c = get_char()
      if not c.nil?
        draw_char(c)
      end
    end
  end

  # s
  def new_line
    # @cyɕ̍Z
    @cy += @line_height
    # @cx͐擪
    @cx = @indent
  end

  # ꕶ擾
  def get_char
    px,py = @cx,@cy
    @cx, @cy, @message = markup_operation(@cx, @cy, @message)
    if py != @cy
      return nil
    end
    return @message.slice!(/./m)
  end

  # Cfgݒ
  def indent=(n)
    @indent = n
    # Ƃ肠
    Markup_New_Line.indent = n
  end

  # P`
  def draw_char(c)
    # P̕
    rect = self.bitmap.text_size(c)
    w = rect.width
    h = rect.height
    # s֑Ȃꍇ
    if not @line_head_ng_words.include?(c)
      # s̃`FbN
      if self.src_rect.width < (@cx + w)
        new_line
        @message = c + @message
        return false
      end
    end
    # s֑̏ꍇ
    if @line_tail_ng_words.include?(c)
      # s̃`FbN
      if self.src_rect.width < (@cx + w * 2)
        new_line
        @message = c + @message
        return false
      end
    end
    # `
    self.bitmap.draw_text(@cx, @cy, w, @line_height, c)
    # @cxɕ`悵Z
    @cx += w
    if @auto_new_line_words.include?(c)
      if @auto_indent_clear_words.include?(c)
        self.indent = 0
      end
      new_line
      return false
    elsif  @auto_indent_words.include?(c)
      case INDENT
      when 'auto'
        self.indent = @cx
      when Numeric
        self.indent = INDENT
      when Array
        if INDENT[1] == 'em'
          self.indent = INDENT[0] * w
        end
      end
    end
    return true
  end
end
