#==============================================================================
#  Window_Operation_Menu
#------------------------------------------------------------------------------
# 񃁃j[
# Copyright (C) 2005 fukuyama
#==============================================================================

module DQ
  class Window_Operation_Menu < ::DQ::Window_Page_Menu
    include Menu_Log_Skill_Module
    include Window_Tree_Module

    # 񃁃j[wv
    HELP_TEXT = {
      '܂񂽂'=>'Ƃ悭\nŜgo\nꔭ܂񂽂I',
      '񂪂'=>'Ɛ키Ƃ\nύX',
      'Ȃт'=>'Ɛ키Ƃ\nяBق\nGɑ_ɂ',
      ''=>'ׂĂ̑\n؂ɕύX',
      'Ă'=>'Q[̐ݒ\nύX'
    }

    # RCxg
    DEBUG_COMMON_EVENT_NAMES = ['fobOCxg','fobO','fobNCxg','fobN','DEBUG'] unless defined? DEBUG_COMMON_EVENT_NAMES
    DEBUG_COMMON_EVENT_ID = Script_Config.common_event_id(DEBUG_COMMON_EVENT_NAMES,nil) unless defined? DEBUG_COMMON_EVENT_ID

    #--------------------------------------------------------------------------
    # 
    #--------------------------------------------------------------------------
    def initialize(parent,title)
      @title = title

      if not $game_party.actors.empty?
        # o[Ȍꍇ́A\Ȃ
        add_menu('܂񂽂',:menu_auto_recover)
        if $game_party.actors.any? {|actor| not actor.ai_fix? }
          # p[eBAIŒ肳ĂlȂꍇ
          add_menu('񂪂',:menu_operation)
        end
        add_menu('',:menu_equip)
        add_menu('Ȃт',:menu_party_order)
      end

      add_menu('Ă',:menu_config)
      if $DEBUG
        if not DEBUG_COMMON_EVENT_ID.nil?
          add_menu('fobO',:menu_debug)
        end
      end
      @index = 0
      super(parent)
      # ʒu̐ݒ
      rect = parent.menu_rect(parent.index)
      self.top = parent.top + rect.y
      self.left = parent.left + rect.x

      # 񃁃j[wvEBhE쐬
      x = self.right
      y = self.top
      w = 32 * 6 + 32
      h = Markup_New_Line.line_height * 3 + 32
      @window_help = Window_Markup_Text.new(x,y,w,h)
      @window_help.back_opacity = self.back_opacity
      @help_text = HELP_TEXT

      # qEBhEɒǉ
      add_child @window_help
      @window_help.visible = true

      add_input_handler(Input::UP,:refresh_help)
      add_input_handler(Input::DOWN,:refresh_help)

      @auto_recover_count = 0
      @auto_recover_mode = false
      @auto_recover_states_mode = false
    end

    # wvĕ`
    def refresh_help
      if (not @window_help.nil?) and (not @window_help.disposed?)
        if not @help_text[self.get_menu].nil?
          @window_help.set_text @help_text[self.get_menu]
          @window_help.visible = true
        else
          @window_help.set_text ""
          @window_help.visible = false
        end
      end
    end

    # ANeBuCxg
    def active_event
      refresh_help
    end

    # XV
    def update
      if @auto_recover_mode # 񕜃[h̏ꍇ́A񕜂𑱂
        exec_auto_recover()
        return
      elsif $scene.message_window.fade_out_off
        $scene.message_window.auto_message_interval = nil
        $scene.message_window.fade_out_off = false
        $scene.message_window.sprite_message.no_wait = false
      end
      super
    end

    # XL񕜗ʌvZ
    def skill_recover(target,actor,skill)
      recover = Game_Battler_Module.calculate_skill_damage(target,actor,skill).abs
      damage = target.maxhp - target.hp
      if (damage - recover) < 0
        return damage
      end
      return recover
    end

    # Xe[g
    def skill_states_cancel(target,actor,skill)
      score = 0.0
      # [v (Xe[g)
      skill.minus_state_set.each do |state_id|
        if target.state?(state_id)
          score += $data_states[state_id].menace_score
        end
      end
      return score
    end

    # 񕜏sbZ[W
    def menu_log_auto_recover_cancel
      $scene.message_window.auto_message_interval = nil
      $scene.message_window.fade_out_off = false
      $scene.message_window.sprite_message.no_wait = false
      e = Script_Event.new
      e.message("@@ȂB")
      e.brank
      $scene.interpreter.setup e.event_commands, 0
    end

    # 񕜂KvH
    def need_recover?
      return (need_recover_states? or need_recover_damage?)
    end

    def need_recover_states?
      $game_party.actors.each do |actor|
        if not actor.states.empty?
          return true
        end
      end
      return false
    end

    def need_recover_damage?
      $game_party.actors.each do |actor|
        next if actor.dead?
        if actor.maxhp > actor.hp
          return true
        end
      end
      return false
    end

    # 񕜏
    def exec_auto_recover
      if @auto_recover_states_mode
        # Xe[g
        exec_auto_recover_states
      else
        # _[W
        exec_auto_recover_damage
      end
    end

    # Xe[g
    def exec_auto_recover_states
      if not need_recover_states?
        @auto_recover_states_mode = false
        return
      end

      # ΏۃAN^[擾
      states_actors = $game_party.actors.dup
      states_actors.reject! {|a| a.states.empty? }
      if states_actors.empty?
        @auto_recover_states_mode = false
        return
      end

      # XLgAN^[擾p
      recover_actors = $game_party.actors.dup
      recover_actors.reject! {|a| a.dead?}

      # SPɃ\[g
      recover_actors.sort! {|a,b| b.sp <=> a.sp}
      if recover_actors.empty?
        @auto_recover_states_mode = false
        return
      end

      recover_actor = nil
      recover_score = 0
      recover_skill = nil

      # 񕜃XLƎgp҂
      recover_actors.each do |actor|
        # ĝ͒ʏXL̂
        Skill_Facade.actor_normal_skills(actor).each do |skill|
          next unless skill.state_cancel_skill? # Xe[gXLȊO͖
          next unless skill.scope_friend? # Ώۂ̃XLȊO͖
          next unless actor.skill_can_use?(skill.id) # gpłȂXL͖

          # XRAvZ
          score = 0
          if skill.scope_single? # P̃XL
            score = skill_states_cancel(states_actors[0],actor,skill)
          elsif skill.scope_all? # S̃XL
            states_actors.each {|t| score += skill_states_cancel(t,actor,skill) }
          end

          if recover_score < score
            recover_actor = actor
            recover_score = score
            recover_skill = skill
          end
        end
      end

      # gXL
      if recover_skill.nil?
        @auto_recover_states_mode = false
        return
      end

      # XLg
      target_actors = nil
      if recover_skill.scope_single? # P̃XL
        target_actors = [states_actors[0]]
      elsif recover_skill.scope_all? # S̃XL
        target_actors = states_actors
      end
      used = Skill_Facade.use_skill(recover_skill,recover_actor,target_actors)

      # XLgꍇ
      if used
        menu_log_use_skill(recover_skill,recover_actor,target_actors)
        @auto_recover_states_mode = need_recover_states?
        @auto_recover_count += 1
      else
        @auto_recover_states_mode = false
      end
    end

    # _[W
    def exec_auto_recover_damage
      # ΏۃAN^[擾
      damage_actors = $game_party.actors.dup
      damage_actors.reject! {|a| a.dead?}
      if damage_actors.empty?
        menu_log_auto_recover_cancel() if @auto_recover_count == 0
        @auto_recover_mode = false
        return
      end

      # _[WɃ\[g
      damage_actors.sort! {|a,b| (b.maxhp - b.hp) <=> (a.maxhp - a.hp)}
      if damage_actors[0].maxhp == damage_actors[0].hp
        menu_log_auto_recover_cancel() if @auto_recover_count == 0
        @auto_recover_mode = false
        return
      end

      # XLgAN^[擾p
      recover_actors = $game_party.actors.dup
      recover_actors.reject! {|a| a.dead?}

      # SPɃ\[g
      recover_actors.sort! {|a,b| b.sp <=> a.sp}
      if recover_actors.empty?
        menu_log_auto_recover_cancel() if @auto_recover_count == 0
        @auto_recover_mode = false
        return
      end

      recover_actor = nil
      recover_score = 0
      recover_skill = nil

      # 񕜃XLƎgp҂
      recover_actors.each do |actor|
        # ĝ͒ʏXL̂
        Skill_Facade.actor_normal_skills(actor).each do |skill|
          next unless skill.recover_skill? # 񕜃XLȊO͖
          next unless skill.scope_friend? # Ώۂ̃XLȊO͖
          next unless actor.skill_can_use?(skill.id) # gpłȂXL͖
          # 񕜗ʂvZ
          recover = 0
          if skill.scope_single? # P̃XL
            recover = skill_recover(damage_actors[0],actor,skill)
          elsif skill.scope_all? # S̃XL
            damage_actors.each {|t| recover += skill_recover(t,actor,skill) }
          end
          next if recover == 0
          # 񕜃XRAvZ
          score = recover.to_f / (skill.sp_cost.to_f / actor.sp.to_f * 100.0)
          if recover_score < score
            recover_actor = actor
            recover_score = score
            recover_skill = skill
          end
        end
      end

      # gXL
      if recover_skill.nil?
        menu_log_auto_recover_cancel() if @auto_recover_count == 0
        @auto_recover_mode = false
        return
      end

      # XLg
      target_actors = nil
      if recover_skill.scope_single? # P̃XL
        target_actors = [damage_actors[0]]
      elsif recover_skill.scope_all? # S̃XL
        target_actors = damage_actors
      end
      used = Skill_Facade.use_skill(recover_skill,recover_actor,target_actors)

      # XLgꍇ
      if used
        menu_log_use_skill(recover_skill,recover_actor,target_actors)
        @auto_recover_mode = need_recover_damage?
        @auto_recover_count += 1
      else
        menu_log_auto_recover_cancel() if @auto_recover_count == 0
        @auto_recover_mode = false
      end
    end

    # ܂񂽂
    def menu_auto_recover
      if not need_recover?
        menu_log_auto_recover_cancel()
        return
      end
      @auto_recover_count = 0
      @auto_recover_mode = true
      @auto_recover_states_mode = true
      # bZ[W\Ԋu퓬pɂ
      $scene.message_window.auto_message_interval = $game_system.user_default_battle_auto_message_interval
      # bZ[WEBhEȂ悤ɂ
      $scene.message_window.fade_out_off = true
      # bZ[WEFCgȂ
      $scene.message_window.sprite_message.no_wait = true
      exec_auto_recover()
    end

    # 
    def menu_operation
      window = Window_Actor_Menu_Operation.new(self)
      set_active_window(window.class)
    end

    # 
    def menu_equip
      window = Window_Actor_Menu_Equip.new(self)
      set_active_window(window.class)
    end

    # 
    def menu_party_order
      window = Window_Party_Order.new(self)
      set_active_window(window.class)
    end

    # Ă
    def menu_config
      window = Window_Config.new(self)
      set_active_window(window.class)
    end

    # fobO
    def menu_debug
      if not DEBUG_COMMON_EVENT_ID.nil?
        # RCxgĂяo\
        $game_temp.common_event_id = DEBUG_COMMON_EVENT_ID
        # j[
        top_window.dispose
      end
    end
  end

end
