#==============================================================================
#  Menu_Log_Item_Module
#------------------------------------------------------------------------------
# ACej[pOW[
# Copyright (C) 2005 fukuyama
#==============================================================================

module DQ

  # j[pgvpeB쐬
  unless ::RPG::Item.include? Properties_Interface_Module
    module ::RPG
      class Item
        include Properties_Interface_Module
      end
    end
  end
  Properties_Interface_Module.compile_properties 'MenuLogItems.csv','Data/MenuLogItems.rxdata'

  module Menu_Log_Item_Module
    #--------------------------------------------------------------------------
    # g[hACeŒ肳Ăꍇ̃O
    #--------------------------------------------------------------------------
    def menu_log_trade_item_fix(item,actor)
      e = Script_Event.new
      e.message("#{actor.name}͕̑ύXł܂B")
      e.brank
      $scene.interpreter.setup e.event_commands, 0
    end

    #--------------------------------------------------------------------------
    # ͂ACeŒ肳Ăꍇ̃O
    #--------------------------------------------------------------------------
    def menu_log_remove_equip_item_fix(item,actor)
      e = Script_Event.new
      e.message("#{actor.name}͕̑ύXł܂B")
      e.brank
      $scene.interpreter.setup e.event_commands, 0
    end

    #--------------------------------------------------------------------------
    # уACeŒ肳Ăꍇ̃O
    #--------------------------------------------------------------------------
    def menu_log_equip_item_fix(item,actor)
      e = Script_Event.new
      e.message("#{actor.name}͕̑ύXł܂B")
      e.brank
      $scene.interpreter.setup e.event_commands, 0
    end

    #--------------------------------------------------------------------------
    # ĂACeŒ肳Ăꍇ̃O
    #--------------------------------------------------------------------------
    def menu_log_throw_item_fix(item,actor)
      e = Script_Event.new
      e.message("#{actor.name}͕̑ύXł܂B")
      e.brank
      $scene.interpreter.setup e.event_commands, 0
    end

    #--------------------------------------------------------------------------
    # ȂO
    #--------------------------------------------------------------------------
    def menu_log_use_item_miss(use_item,owner_actor,target=nil)
      item = Item_Facade.get_use_item(use_item)
      item = use_item if item.nil?
      index = 0
      if owner_actor.is_a? Game_Actor
        index = $game_party.actors.index owner_actor
      end
      name = $game_party.smooth_target_actor(index).name
      e = Script_Event.new
      if target.nil?
        e.message("#{name}́A#{item.name}B")
      else
        e.message("#{name}́@#{target.name}Ɂ@#{item.name}B")
      end
      e.message("AȂɂȂB")
      e.brank
      $scene.interpreter.setup e.event_commands, 0
    end

    #--------------------------------------------------------------------------
    # O
    #--------------------------------------------------------------------------
    def menu_log_use_item(use_item,owner_actor,targets)
      item = Item_Facade.get_use_item(use_item)
      # Sł̏ꍇ
      if $game_party.all_dead?
        # Q[I[o[ʂɐ؂ւ
        $scene = Scene_Gameover.new
        return
      end
      # RCxg ID L̏ꍇ
      if item.common_event_id > 0
        # RCxgĂяo\
        $game_temp.common_event_id = item.common_event_id
        # }bvʂɐ؂ւ
        $scene = Scene_Map.new
        return
      end
      msgs = []
      index = 0
      if owner_actor.is_a? Game_Actor
        index = $game_party.actors.index owner_actor
      end
      name = $game_party.smooth_target_actor(index).name
      if targets.size > 1 or name == targets[0].name
        msgs.push "#{name}́@#{item.name}B"
      else
        msgs.push "#{name}́@#{targets[0].name}Ɂ@#{item.name}B"
      end

      if not item.properties['menu_log_use_item'].nil?
        for target in targets
          # }[NAbvł̂́AƌEȂĉŁAƂ肠Oϊ
          log = item.properties['menu_log_use_item'].dup

          # \item.name
          log[/\\item\.name/] = item.name if log =~ /\\item\.name/

          # \target.name
          log[/\\target\.name/] = target.name if log =~ /\\target\.name/

          msgs.push log
        end
      end

      e = Script_Event.new
      for msg in msgs
        e.message(msg)
      end
      e.brank
      $scene.interpreter.setup e.event_commands, 0
    end

    #--------------------------------------------------------------------------
    # AN^[ACe󂯎ꍇɑΘbCxg
    #--------------------------------------------------------------------------
    def menu_log_receive_item_actor_equip_event(e,item,actor)
      # Œ肳Ă
      if Item_Facade.equip_fix?(item,actor)
        return
      end
      # łȂ
      if not Item_Facade.equippable?(item,actor)
        return
      end
      # AN^[SĂ
      if actor.dead?
        return
      end

      e.message("#{item.name}@܂H\\n")
      e.branch_start(['͂',''],2)
      e.branch_item(0)
      e.message create_menu_log_equip_item(item,actor)
      e.method_call(method(:equip_se))
      e.method_call(actor.method(:equip_item),item)
      e.branch_end
    end

    #--------------------------------------------------------------------------
    # AN^[AN^[ɃACenꍇ̃O
    #--------------------------------------------------------------------------
    def menu_log_hand_item_actor(from_actor,from_item,to_actor)
      msg = ''
      if from_actor.dead? and to_actor.dead?
        alive_actor = $game_party.smooth_target_actor(0)
        msg << "#{alive_actor.name}́@#{from_actor.name}\\n"
        msg << "#{from_item.name}@Ƃ肾\\n"
        msg << "#{to_actor.name}Ɂ@B"
      elsif from_actor.dead?
        msg << "#{to_actor.name}́@#{from_actor.name}\\n"
        msg << "#{from_item.name}@Ƃ肾B"
      elsif to_actor.dead?
        msg << "#{from_actor.name}́@#{from_item.name}\\n"
        msg << "#{to_actor.name}Ɂ@B"
      else
        msg << "#{from_actor.name}́@#{from_item.name}\\n"
        msg << "#{to_actor.name}Ɂ@킽B"
      end
      e = Script_Event.new
      e.message(msg)
      menu_log_receive_item_actor_equip_event(e,from_item,to_actor)
      e.brank
      $scene.interpreter.setup e.event_commands, 0
    end

    #--------------------------------------------------------------------------
    # AN^[ƃAN^[ACeꍇ̃O
    #--------------------------------------------------------------------------
    def menu_log_trade_item_actor(from_actor,from_item,to_actor,to_item)
      msg = ''
      if from_actor.dead? and to_actor.dead?
        alive_actor = $game_party.smooth_target_actor(0)
        msg << "#{alive_actor.name}\\n"
        msg << "#{from_actor.name}́@#{from_item.name}\\n"
        msg << "#{to_actor.name}́@#{to_item.name}B"
      elsif from_actor.dead?
        msg << "#{to_actor.name}́@#{to_item.name}\\n"
        msg << "#{from_actor.name}́@#{from_item.name}ƌB"
      elsif to_actor.dead?
        msg << "#{from_actor.name}́@#{from_item.name}\\n"
        msg << "#{to_actor.name}́@#{to_item.name}ƌB"
      else
        msg  = "#{from_actor.name}́@#{from_item.name}\\n"
        msg << "#{to_actor.name}́@#{to_item.name}ƌB"
      end
      e = Script_Event.new
      e.message(msg)
      menu_log_receive_item_actor_equip_event(e,from_item,to_actor)
      e.brank
      $scene.interpreter.setup e.event_commands, 0
    end

    #--------------------------------------------------------------------------
    # ӂ납AN^[ACeoꍇ̃O
    #--------------------------------------------------------------------------
    def menu_log_hand_item_party(from_item,to_actor)
      msg = ''
      if to_actor.dead?
        alive_actor = $game_party.smooth_target_actor(0)
        msg  = "#{alive_actor.name}́@ӂ납\\n"
        msg << "#{from_item.name}@Ƃ肾\\n"
        msg << "#{to_actor.name}Ɂ@B"
      else
        msg  = "#{to_actor.name}́@ӂ납\\n"
        msg << "#{from_item.name}@Ƃ肾B"
      end
      e = Script_Event.new
      e.message(msg)
      menu_log_receive_item_actor_equip_event(e,from_item,to_actor)
      e.brank
      $scene.interpreter.setup e.event_commands, 0
    end

    #--------------------------------------------------------------------------
    # ӂ̃ACeƃAN^[̃ACeꍇ̃O
    #--------------------------------------------------------------------------
    def menu_log_trade_item_party(from_item,to_actor,to_item)
      msg = ''
      if to_actor.dead?
        alive_actor = $game_party.smooth_target_actor(0)
        msg  = "#{alive_actor.name}́@ӂ́@#{from_item.name}\\n"
        msg << "#{to_actor.name}́@#{to_item.name}B"
      else
        msg  = "ӂ́@#{from_item.name}\\n"
        msg << "#{to_actor.name}́@#{to_item.name}B"
      end
      e = Script_Event.new
      e.message(msg)
      menu_log_receive_item_actor_equip_event(e,from_item,to_actor)
      e.brank
      $scene.interpreter.setup e.event_commands, 0
    end

    #--------------------------------------------------------------------------
    # ӂ뒆̃ACeꍇ̃O
    #--------------------------------------------------------------------------
    def menu_log_trade_item_backpack(from_item)
      msg  = "#{$game_party.actors[0].name}́@ӂ\\n"
      msg << "#{from_item.name}ꂩB"
      e = Script_Event.new
      e.message(msg)
      e.brank
      $scene.interpreter.setup e.event_commands, 0
    end

    #--------------------------------------------------------------------------
    # AN^[̃ACeӂɓꍇ̃O
    #--------------------------------------------------------------------------
    def menu_log_hand_item_backpack(from_actor,from_item)
      msg = ''
      if from_actor.dead?
        alive_actor = $game_party.smooth_target_actor(0)
        msg  = "#{alive_actor.name}\\n"
        msg << "#{from_actor.name}́@#{from_item.name}\\n"
        msg << "ӂɁ@ꂽB"
      else
        msg  = "#{from_actor.name}́@#{from_item.name}\\n"
        msg << "ӂɁ@ꂽB"
      end
      e = Script_Event.new
      e.message(msg)
      e.brank
      $scene.interpreter.setup e.event_commands, 0
    end

    #--------------------------------------------------------------------------
    # AN^[ACeĂꍇ̃O
    #--------------------------------------------------------------------------
    def menu_log_throw_item_actor(item,actor)
      e = Script_Event.new
      e.message("#{item.name}\\n̂ĂĂłH\\n")
      e.branch_start(['͂',''],2)
      e.branch_item(0)
      e.method_call(Item_Facade.method(:throw_item),item,actor)
      if actor.dead?
        alive_actor = $game_party.smooth_target_actor(0)
        e.message("#{alive_actor.name}́@#{actor.name}\\n#{item.name}@ȂĂB")
      else
        e.message("#{actor.name}́@#{item.name}@ȂĂB")
      end
      e.branch_end
      e.brank
      $scene.interpreter.setup e.event_commands, 0
    end

    #--------------------------------------------------------------------------
    # ӂ납ACeĂꍇ̃O
    #--------------------------------------------------------------------------
    def menu_log_throw_item_party(item,party)
      e = Script_Event.new
      e.message("#{item.name}\\n̂ĂĂłH\\n")
      e.branch_start(['͂',''],2)
      e.branch_item(0)
      e.method_call(Item_Facade.method(:throw_item),item,party)
      e.message("#{item.name}ȂĂB")
      e.branch_end
      e.brank
      $scene.interpreter.setup e.event_commands, 0
    end

    #--------------------------------------------------------------------------
    # ĂȂACeĂꍇ̃O
    #--------------------------------------------------------------------------
    def menu_log_throw_item_error(item,actor)
      e = Script_Event.new
      e.message("@̂ĂȂā@ƂłȂI")
      e.brank
      $scene.interpreter.setup e.event_commands, 0
    end

    #--------------------------------------------------------------------------
    # ǂ̏ꍇ̃O
    #--------------------------------------------------------------------------
    def menu_log_arrange_item(actors)
      e = Script_Event.new
      e.message("iȊO@ӂɁ@܂BłH\\n")
      e.branch_start(['͂',''],2)
      e.branch_item(0)
      e.method_call(Item_Facade.method(:arrange_item),actors)
      e.message("iȊO@ӂɁ@܂B")
      e.branch_end
      e.brank
      $scene.interpreter.setup e.event_commands, 0
    end

    #--------------------------------------------------------------------------
    # ӂ됮̏ꍇ̃O
    #--------------------------------------------------------------------------
    def menu_log_arrange_backpack(name,method_instance)
      e = Script_Event.new
      e.message("ӂ̂ǂ@#{name}\\nȂт܂BłH\\n")
      e.branch_start(['͂',''],2)
      e.branch_item(0)
      e.method_call(method_instance)
      e.message("ӂ̂ǂ@Ȃт܂B")
      e.branch_end
      e.brank
      $scene.interpreter.setup e.event_commands, 0
    end

    #--------------------------------------------------------------------------
    # т͂ꍇ̃O
    #--------------------------------------------------------------------------
    def menu_log_remove_equip_item(item,actor)
      e = Script_Event.new
      e.message("#{actor.name}́A#{item.name}\\n͂B")
      e.brank
      $scene.interpreter.setup e.event_commands, 0
    end

    #--------------------------------------------------------------------------
    # тłȂACȅꍇ̃O
    #--------------------------------------------------------------------------
    def menu_log_equip_item_error(item)
      e = Script_Event.new
      e.message("#{item.name}\\n邱Ƃ́@ł܂B")
      e.brank
      $scene.interpreter.setup e.event_commands, 0
    end

    #--------------------------------------------------------------------------
    # тłȂAN^[̏ꍇ̃O
    #--------------------------------------------------------------------------
    def menu_log_equip_item_actor_error(item,actor)
      e = Script_Event.new
      e.message("#{actor.name}́@#{item.name}\\n邱ƂłȂB")
      e.brank
      $scene.interpreter.setup e.event_commands, 0
    end

    #--------------------------------------------------------------------------
    # тꍇ̃O
    #--------------------------------------------------------------------------
    def create_menu_log_equip_item(item,actor)
      return "#{actor.name}́A#{item.name}\\nB"
    end

    def menu_log_equip_item(item,actor)
      e = Script_Event.new
      e.message create_menu_log_equip_item(item,actor)
      e.brank
      $scene.interpreter.setup e.event_commands, 0
    end
  end

end
