#==============================================================================
#  Game_Actor#setup
#------------------------------------------------------------------------------
# AN^[ɃACeǗ
# [IɃobNpbNAN^[ɂPiItem_Max̃Reij
#==============================================================================

class Game_Actor
  attr_reader :backpack

  attr_reader :weapon
  attr_reader :armor1
  attr_reader :armor2
  attr_reader :armor3
  attr_reader :armor4

  #--------------------------------------------------------------------------
  #  ZbgAbv
  #     actor_id : AN^[ ID
  #--------------------------------------------------------------------------
  alias dq_original_setup setup
  def setup(actor_id)
    dq_original_setup actor_id

    # obNpbN̍쐬
    @backpack = Game_Item.new
    @backpack.container = Item_Max_Container.new

    if @weapon_id != 0
      @weapon = Game_Weapon.new(@weapon_id)
      @backpack.add_item @weapon
    end
    if @armor1_id != 0
      @armor1 = Game_Armor.new(@armor1_id)
      @backpack.add_item @armor1
    end
    if @armor2_id != 0
      @armor2 = Game_Armor.new(@armor2_id)
      @backpack.add_item @armor2
    end
    if @armor3_id != 0
      @armor3 = Game_Armor.new(@armor3_id)
      @backpack.add_item @armor3
    end
    if @armor4_id != 0
      @armor4 = Game_Armor.new(@armor4_id)
      @backpack.add_item @armor4
    end
  end

  #--------------------------------------------------------------------------
  # ĂACe擾
  #--------------------------------------------------------------------------
  def equip_items
    # Ƃ肠
    return [
      self.weapon,
      self.armor1,
      self.armor2,
      self.armor3,
      self.armor4
    ].compact
  end

  #--------------------------------------------------------------------------
  # Ăh擾
  #--------------------------------------------------------------------------
  def equip_armors
    # Ƃ肠
    return [
      self.armor1,
      self.armor2,
      self.armor3,
      self.armor4
    ]
  end

  #--------------------------------------------------------------------------
  #  ̕ύX
  #     equip_type : ^Cv
  #     id    :  or h ID  (0 Ȃ瑕)
  #--------------------------------------------------------------------------
  def equip(equip_type, id)
    case equip_type
    when 0  # 
      self.weapon = Item_Facade.find_item(Game_Weapon,id,self)
    when 1  # 
      armor = Item_Facade.find_item(Game_Armor,id,self)
      self.armor1 = armor
    when 2  # 
      armor = Item_Facade.find_item(Game_Armor,id,self)
      self.armor2 = armor
    when 3  # g
      armor = Item_Facade.find_item(Game_Armor,id,self)
      self.armor3 = armor
    when 4  # i
      armor = Item_Facade.find_item(Game_Armor,id,self)
      self.armor4 = armor
    end
  end

  #--------------------------------------------------------------------------
  # ̕ύX
  #--------------------------------------------------------------------------
  def equip_item(item)
    if item.is_a?(Game_Weapon)
      self.weapon = item
    elsif item.is_a?(Game_Armor)
      if item.kind == 0
        self.armor1 = item
      elsif item.kind == 1
        self.armor2 = item
      elsif item.kind == 2
        self.armor3 = item
      elsif item.kind == 3
        self.armor4 = item
      end
    end
  end

  def remove_equip_item(item)
    if @weapon == item
      self.weapon = nil
    elsif @armor1 == item
      self.armor1 = nil
    elsif @armor2 == item
      self.armor2 = nil
    elsif @armor3 == item
      self.armor3 = nil
    elsif @armor4 == item
      self.armor4 = nil
    end
  end

  def weapon=(item)
    if item.nil?
      @weapon = nil
      @weapon_id = 0
      return
    end
    if item.is_a?(Game_Weapon)
      @weapon = item
      @weapon_id = item.id
      # XXX: 蕐Ή@푕蕐vpeB^̏ꍇAOB
      if not @weapon.nil?
        if @weapon.properties["twohand"]
          self.armor1 = nil
        end
      end
    end
  end

  def armor1=(item)
    update_auto_state(@armor1,item)
    if item.nil?
      @armor1 = nil
      @armor1_id = 0
      return
    end
    if item.is_a?(Game_Armor)
      @armor1 = item
      @armor1_id = item.id
      # XXX: 蕐Ή@̗̕蕐vpeB^̏ꍇAOB
      if (not @armor1.nil?) and (not @weapon.nil?)
        if @weapon.properties["twohand"]
          self.weapon = nil
        end
      end
    end
  end

  def armor2=(item)
    update_auto_state(@armor2,item)
    if item.nil?
      @armor2 = nil
      @armor2_id = 0
      return
    end
    if item.is_a?(Game_Armor)
      @armor2 = item
      @armor2_id = item.id
    end
  end

  def armor3=(item)
    update_auto_state(@armor3,item)
    if item.nil?
      @armor3 = nil
      @armor3_id = 0
      return
    end
    if item.is_a?(Game_Armor)
      @armor3 = item
      @armor3_id = item.id
    end
  end

  def armor4=(item)
    update_auto_state(@armor4,item)
    if item.nil?
      @armor4 = nil
      @armor4_id = 0
      return
    end
    if item.is_a?(Game_Armor)
      @armor4 = item
      @armor4_id = item.id
    end
  end

  #--------------------------------------------------------------------------
  #  AN^[̃t@N^O
  #--------------------------------------------------------------------------

  #--------------------------------------------------------------------------
  #  ␳l̎擾
  #     element_id :  ID
  #--------------------------------------------------------------------------
  def element_rate(element_id)
    # LxɑΉ鐔l擾
    table = [0,200,150,100,50,0,-100]
    result = table[$data_classes[@class_id].element_ranks[element_id]]
    # hh
    result = element_rate_armors(element_id,result)
    # Xe[gł̑h䂳Ăꍇ͔
    for i in @states
      if $data_states[i].guard_element_set.include?(element_id)
        result /= 2
      end
    end
    # \bhI
    return result
  end

  #--------------------------------------------------------------------------
  #  ␳l̎擾ih̑hvZj
  #     element_id :  ID
  #     result     : {l
  #--------------------------------------------------------------------------
  def element_rate_armors(element_id,result)
    # hł̑h䂳Ăꍇ͔
    self.equip_armors.each do |armor|
      if armor != nil and armor.guard_element_set.include?(element_id)
        result /= 2
      end
    end
    return result
  end

  #--------------------------------------------------------------------------
  #  Xe[gh䔻
  #     state_id : Xe[g ID
  #--------------------------------------------------------------------------
  def state_guard?(state_id)
    self.equip_armors.each do |armor|
      if armor != nil and armor.guard_state_set.include?(state_id)
        return true
      end
    end
    return false
  end

  #--------------------------------------------------------------------------
  #  ʏȖ擾
  #--------------------------------------------------------------------------
  def element_set
    return weapon != nil ? weapon.element_set : []
  end

  #--------------------------------------------------------------------------
  #  ʏŨXe[gω (+) 擾
  #--------------------------------------------------------------------------
  def plus_state_set
    return weapon != nil ? weapon.plus_state_set : []
  end

  #--------------------------------------------------------------------------
  #  ʏŨXe[gω (-) 擾
  #--------------------------------------------------------------------------
  def minus_state_set
    return weapon != nil ? weapon.minus_state_set : []
  end

  #--------------------------------------------------------------------------
  #  {r͂̎擾
  #--------------------------------------------------------------------------
  def base_str
    n = $data_actors[@actor_id].parameters[2, @level]
    n += weapon != nil ? weapon.str_plus : 0
    n += armor1 != nil ? armor1.str_plus : 0
    n += armor2 != nil ? armor2.str_plus : 0
    n += armor3 != nil ? armor3.str_plus : 0
    n += armor4 != nil ? armor4.str_plus : 0
    return [[n, 1].max, 999].min
  end

  #--------------------------------------------------------------------------
  #  {p̎擾
  #--------------------------------------------------------------------------
  def base_dex
    n = $data_actors[@actor_id].parameters[3, @level]
    n += weapon != nil ? weapon.dex_plus : 0
    n += armor1 != nil ? armor1.dex_plus : 0
    n += armor2 != nil ? armor2.dex_plus : 0
    n += armor3 != nil ? armor3.dex_plus : 0
    n += armor4 != nil ? armor4.dex_plus : 0
    return [[n, 1].max, 999].min
  end

  #--------------------------------------------------------------------------
  #  {f̎擾
  #--------------------------------------------------------------------------
  def base_agi
    n = $data_actors[@actor_id].parameters[4, @level]
    n += weapon != nil ? weapon.agi_plus : 0
    n += armor1 != nil ? armor1.agi_plus : 0
    n += armor2 != nil ? armor2.agi_plus : 0
    n += armor3 != nil ? armor3.agi_plus : 0
    n += armor4 != nil ? armor4.agi_plus : 0
    return [[n, 1].max, 999].min
  end

  #--------------------------------------------------------------------------
  #  {͂̎擾
  #--------------------------------------------------------------------------
  def base_int
    n = $data_actors[@actor_id].parameters[5, @level]
    n += weapon != nil ? weapon.int_plus : 0
    n += armor1 != nil ? armor1.int_plus : 0
    n += armor2 != nil ? armor2.int_plus : 0
    n += armor3 != nil ? armor3.int_plus : 0
    n += armor4 != nil ? armor4.int_plus : 0
    return [[n, 1].max, 999].min
  end

  #--------------------------------------------------------------------------
  #  {U͂̎擾
  #--------------------------------------------------------------------------
  def base_atk
    return weapon != nil ? weapon.atk : 0
  end

  #--------------------------------------------------------------------------
  #  {h̎擾
  #--------------------------------------------------------------------------
  def base_pdef
    pdef1 = weapon != nil ? weapon.pdef : 0
    pdef2 = armor1 != nil ? armor1.pdef : 0
    pdef3 = armor2 != nil ? armor2.pdef : 0
    pdef4 = armor3 != nil ? armor3.pdef : 0
    pdef5 = armor4 != nil ? armor4.pdef : 0
    return pdef1 + pdef2 + pdef3 + pdef4 + pdef5
  end

  #--------------------------------------------------------------------------
  #  {@h̎擾
  #--------------------------------------------------------------------------
  def base_mdef
    mdef1 = weapon != nil ? weapon.mdef : 0
    mdef2 = armor1 != nil ? armor1.mdef : 0
    mdef3 = armor2 != nil ? armor2.mdef : 0
    mdef4 = armor3 != nil ? armor3.mdef : 0
    mdef5 = armor4 != nil ? armor4.mdef : 0
    return mdef1 + mdef2 + mdef3 + mdef4 + mdef5
  end

  #--------------------------------------------------------------------------
  #  {C̎擾
  #--------------------------------------------------------------------------
  def base_eva
    eva1 = armor1 != nil ? armor1.eva : 0
    eva2 = armor2 != nil ? armor2.eva : 0
    eva3 = armor3 != nil ? armor3.eva : 0
    eva4 = armor4 != nil ? armor4.eva : 0
    return eva1 + eva2 + eva3 + eva4
  end

  #--------------------------------------------------------------------------
  #  ʏU UAj[V ID ̎擾
  #--------------------------------------------------------------------------
  def animation1_id
    return weapon != nil ? weapon.animation1_id : 0
  end

  #--------------------------------------------------------------------------
  #  ʏU ΏۑAj[V ID ̎擾
  #--------------------------------------------------------------------------
  def animation2_id
    return weapon != nil ? weapon.animation2_id : 0
  end

  #--------------------------------------------------------------------------
  #  NX ID ̕ύX
  #     class_id : VNX ID
  #--------------------------------------------------------------------------
  def class_id=(class_id)
    if $data_classes[class_id] != nil
      @class_id = class_id
      # łȂȂACeO
      unless Item_Facade.equippable?(weapon,self)
        equip(0, 0)
      end
      unless Item_Facade.equippable?(armor1,self)
        equip(1, 0)
      end
      unless Item_Facade.equippable?(armor2,self)
        equip(2, 0)
      end
      unless Item_Facade.equippable?(armor3,self)
        equip(3, 0)
      end
      unless Item_Facade.equippable?(armor4,self)
        equip(4, 0)
      end
    end
  end

end
