#  Phase_Party_Command
# p[eBR}htF[Y
# Author:: fukuyama
# Date:: 2011/04/24
# Copyright:: Copyright (c) 2005 rgss-lib(sourceforge.jp)

module DQ
  module Battle
    class Phase_Party_Command

      include Battle_Phase_Base_Module
      def self.start
        # CtF[YtONA
        $game_temp.battle_main_phase = false
        # p[eBS̃ANVNA
        $game_party.clear_actions
        # bZ[W\Ԋu퓬pǂ(ScenełĂ邩KvȂ)
        $scene.message_window.auto_message_interval = nil
        # Xe[^XEBhEɖ߂
        $scene.status_window.state_on
        # bZ[WEBhE悤ɂ
        $scene.message_window.fade_out_off = false

        if $game_party.inputable?
          $scene.phase = Phase_Party_Command.new
        else
          # R}h͕s\ȏꍇ
          # CtF[YJn
          Phase_Main.start
        end
      end

      def initialize
        @window_party_command = Window_Party_Command.new
      end

      def dispose
        if (not @window_party_command.nil?) and (not @window_party_command.disposed?)
          @window_party_command.dispose
          @window_party_command = nil
        end
      end

      def update
        # p[eBR}hEBhEXV
        @window_party_command.update

        # ꍇ
        if @window_party_command.disposed?
          # 
          if @window_party_command.battle?
            # AN^[R}hJn
            Phase_Actor_Command.start
            return
          end
          # ɂ
          if @window_party_command.escape?
            update_phase2_escape
            setup_escape_action
            return
          end
        end
      end

      # ANVݒ
      def setup_escape_action
        # AN^[̃ANV쐬
        $game_party.actors.each do |actor|
          # ANVݒ
          actor.current_action.kind = 3 # 
          actor.current_action.basic = 0
        end
      end

      #--------------------------------------------------------------------------
      #  t[XV (p[eBR}htF[Y : )
      #--------------------------------------------------------------------------
      def update_phase2_escape
        # Gl~[̑fϒlvZ
        enemies_agi = 0
        enemies_number = 0
        for enemy in $game_troop.enemies
          if enemy.exist?
            enemies_agi += enemy.agi
            enemies_number += 1
          end
        end
        if enemies_number > 0
          enemies_agi /= enemies_number
        end
        # AN^[̑fϒlvZ
        actors_agi = 0
        actors_number = 0
        for actor in $game_party.actors
          if actor.exist?
            actors_agi += actor.agi
            actors_number += 1
          end
        end
        if actors_number > 0
          actors_agi /= actors_number
        end
        # 
        success = rand(100) < 50 * actors_agi / enemies_agi
        # ̏ꍇ
        if success
          #  SE t
          $game_system.se_play($data_system.escape_se)
          # ogJnO BGM ɖ߂
          $game_system.bgm_play($game_temp.map_bgm)
          # ANVO
          action_log_escape(success)
          # ogI
          #      battle_end(1)
          # s̏ꍇ
        else
          #  SE t
          $game_system.se_play($data_system.escape_se)
          # p[eBS̃ANVNA
          $game_party.clear_actions
          # CtF[YJn
          Phase_Main.start
          # ANVO
          action_log_escape(success)
        end
      end

      def action_log_escape(success)
        # ANVʕ\Cxg
        action_event = Script_Event.new
        if $game_party.actors.size == 1
          action_event.message("\\clear\\PN[0]́@ɂI\\n")
        else
          action_event.message("\\clear\\PN[0]B́@ɂI\\n")
        end
        if success
          # ogI
          action_event.method_call(method(:battle_end),1)
          battle_event_start(action_event)
        else
          action_event.message("\\scroll_lock@܂肱܂Ă܂I\\n")
          action_event_start(action_event)
        end
      end

    end
  end
end
