#==============================================================================
#  Battle_AI_Base
#------------------------------------------------------------------------------
# 퓬`hۃNX
# Copyright (C) 2005 fukuyama
#==============================================================================

module DQ
  module Battle_AI
    module Base_Module
      def setup_target(object,target=nil)
        partner = target
        if target.nil?
          target = targets[rand(targets.size)]
          partner = partners[rand(partners.size)]
        end
        if object.scope == 1                   # GP̂̏ꍇ
          battler.current_action.targets = [target]
        elsif object.scope == 2                # GŜ̏ꍇ
          battler.current_action.targets = targets
        elsif [3,5].include? object.scope      # P̂̏ꍇ
          battler.current_action.targets = [partner]
        elsif [4,6].include? object.scope      # Ŝ̏ꍇ
          battler.current_action.targets = partners
        elsif 7 == object.scope                # gp҂̏ꍇ
          battler.current_action.targets = [battler]
        end
      end
      def setup_normal_attack(target)
        super(target)
        battler.current_action.targets = [target]
      end
      def setup_skill(skill,target = nil)
        super(skill,target)
        setup_target(skill,target)
      end
      def setup_item(item,target = nil)
        super(item,target)
        battler.current_action.item = item
        setup_target(item,target)
      end
      #-------------------------------------
      # FuzzySet쐬[eBeB
      #-------------------------------------
      def createMaxFuzzySet(data)
        fs = FuzzySet.new
        fs.create_fuzzy_set([data * 0.2,
                            data * 0.4,
                            data * 0.6,
                            data * 0.8,
                            data * 1.0])
        return fs
      end
      def createAverageFuzzySet(data)
        fs = FuzzySet.new
        fs.create_fuzzy_set([data * 0.0,
                            data * 0.5,
                            data * 1.0,
                            data * 1.5,
                            data * 2.0])
        return fs
      end
      #-------------------------------------
      # FuzzyScore쐬[eBeB
      #-------------------------------------
      def create_score_hp_pdef(target_battlers)
        # goƖh͂̃t@W[}gNX
        pdef_total = 0
        maxhp_list = []
        target_battlers.each do |b|
          pdef_total += b.pdef
          maxhp_list.push b.maxhp
        end
        pdef_average = pdef_total / target_battlers.size
        maxhp = maxhp_list.max
        
        fs_list = []
        fs_list.push createMaxFuzzySet(maxhp)
        fs_list.push createAverageFuzzySet(pdef_average)
        fm = FuzzyMatrix.new(fs_list)
        return target_battlers.collect { |b| fm.score(b.hp,b.pdef) }
      end
      def create_score_hpdamage(target_battlers)
        # go_[W̃t@W[}gNX
        score_list = []
        target_battlers.each do |b|
          fs_list = []
          fs_list.push createMaxFuzzySet(b.maxhp)
          fm = FuzzyMatrix.new(fs_list)
          score_list.push fm.score(b.hp)
        end
        return score_list
      end
      #-------------------------------------
      # XRAXgϊ
      #-------------------------------------
      def get_single_target_min(target_list,score_list)
        index = score_list.index(score_list.min)
        return target_list[index]
      end
      
      def skill_damage(target,user,skill)
        return Game_Battler_Module.calculate_skill_damage(target,user,skill)
      end
    end
  end
end

class Battle_AI_Base
  include DQ::Battle_AI::Base_Module
end
