#==============================================================================
#  Window_Item_Base
#------------------------------------------------------------------------------
# cppACeEBhEx[X
# Copyright (C) 2005 fukuyama
#==============================================================================

module DQ
  module Window_Item_Help_Module
    # ACewvEBhE쐬
    def setup_window_help
      @window_help = create_window_help()
      @window_help.back_opacity = self.back_opacity
      # qEBhEɒǉ
      add_child @window_help
      @window_help.visible = false
      add_input_handler(Input::UP,:refresh_help)
      add_input_handler(Input::DOWN,:refresh_help)
    end

    # ACewvEBhE쐬
    def create_window_help()
      x = self.x + self.width
      y = 64 + 16
      w = WINDOW_ITEM_HELP_WIDTH
      h = Markup_New_Line.line_height * 8 + 32
      return Window_Markup_Text.new(x,y,w,h)
    end

    # wvXV
    def refresh_help
      if @index < 0
        return
      end
      if (not @window_help.nil?) and (not @window_help.disposed?)
        if (not self.item.nil?) and (self.item.is_a? Game_Item_Base)
          text = self.item.description.dup
          text << make_item_status_description
          @window_help.set_text text
        else
          @window_help.set_text ""
        end
      end
    end

    def make_item_status_description
      return ""
    end

    def active_event_help
      if (not @window_help.nil?) and (not @window_help.disposed?)
        if self.active
          @window_help.visible = true
          refresh_help
        end
      end
    end

    def window_help_on
      @window_help.visible = true
    end

    def window_help_off
      @window_help.visible = false
    end
  end

  class Window_Item_Base < ::DQ::Window_Page_Menu
    include Window_Tree_Module
    def refresh_menus
      # j[̕`
      page = 0
      if @index >= 0
        page,index = @index.divmod page_item_max
      end
      for index in (page * page_item_max) ... ((page + 1) * page_item_max)
        draw_menu(index, normal_color)
      end
      @_refresh_menus = Hash.new(false)
      @_prev_page = page
      @_refresh_menus[page] = true
    end

    def update
      super
      if @index >= 0
        page,index = @index.divmod page_item_max
        if @_prev_page != page and (not @_refresh_menus[page])
          # ACe̕̕`
          for index in (page * page_item_max) ... ((page + 1) * page_item_max)
            draw_menu(index, normal_color)
          end
          @_prev_page = page
          @_refresh_menus[page] = true
        end
      end
    end

    #--------------------------------------------------------------------------
    # ACe̎擾
    #--------------------------------------------------------------------------
    def item
      return get_menu
    end

    #--------------------------------------------------------------------------
    # ڂ̕`
    #--------------------------------------------------------------------------
    def draw_menu_item(index,color,rect,item)
      self.contents.font.color = color
      name = ''
      case item
      when String
        name = item
      when Game_Item_Base
        name = item.name
      end

      self.contents.fill_rect(rect, Color.new(0, 0, 0, 0))

      case @actor
      when Game_Actor
        # ĂACeH
        if Item_Facade.actor_equip?(item,@actor)
          name = 'E ' + name
        end
      when Game_Party
        if item.is_a?(Game_Item)
          count = @actor.backpack.item_count_id(item.id,Game_Item)
          count_rect = self.contents.text_size(count.to_s)
          count_rect.x = rect.x + rect.width - count_rect.width
          count_rect.y = rect.y
          self.contents.draw_text(count_rect,count.to_s,2)
        end
      end

      self.contents.draw_text(rect, name)
    end

    #--------------------------------------------------------------------------
    # AN^[ACe̍XV
    #--------------------------------------------------------------------------
    def refresh_actor_items
      @actor = self.parent.actor
      @actor = self.parent.backpack if @actor.nil?
      return if @actor.nil?

      case @actor
      when Game_Actor
        # AN^[
        equip_items = Item_Facade.equip_items(@actor)
        equip_items.each do |item|
          add_menu(item, :select_item)
        end
        @actor.backpack.each_item do |item|
          add_menu(item, :select_item) if not equip_items.include?(item)
        end
      when Game_Party
        # ӂ̏ꍇGame_ItemX^bN\
        @actor.backpack.each_stack_item do |item|
          add_menu(item, :select_item)
        end
      end

      n = menu_size()
      if n == 0
        self.index = -1
        set_active_window(parent.class)
      elsif n <= @index
        @index = n - 1
      end
    end

    #---------------------------------------------------------------------------
    # Rec̍쐬
    def _contents_width
      return _menu_width * @column_max
    end

    #---------------------------------------------------------------------------
    # j[̍쐬
    def _menu_width
      return WINDOW_ITEM_WIDTH
    end
  end

end
