
if $DEBUG
  module Debug
    
    MOVE_AREA_CHECK_KEY = [Input::A] unless defined? MOVE_AREA_CHECK_KEY
    
    class Area_Check_Node
      attr_reader :x
      attr_reader :y
      attr_accessor :score
      
      # 
      def initialize(x=0,y=0,s=0,nodes={})
        super()
        @x = x
        @y = y
        @score = s
        @nodes = nodes
        set_node(@x,@y,@score,self)
      end
      
      # m[h̐ݒ
      def set_node(x,y,score,node)
        unless @nodes.include? x
          @nodes[x] = {}
        end
        unless @nodes[x].include? y
          if node.nil?
            @nodes[x][y] = Area_Check_Node.new(x,y,score,@nodes)
          else
            @nodes[x][y] = node
          end
        end
      end
      
      # m[h̎擾
      def get_node(x,y)
        set_node(x,y,0,nil) # ꍇ͍쐬
        return @nodes[x][y]
      end
      
      # ߂
      def direction(node)
        return 0 unless adjacent?(node) # אڂĖ
        return 2 if @y < node.y
        return 4 if @x > node.x
        return 6 if @x < node.x
        return 8 if @y > node.y
        return 0
      end
      
      # אڂĂ邩H
      def adjacent?(node)
        # ʒȕꍇƁA΂߈ʒȕꍇאڂĂȂƂ݂Ȃ
        if (node.x == @x and node.y == @y) or (node.x != @x and node.y != @y)
          return false
        end
        return ((@x - 1 .. @x + 1).include?(node.x) or (@y - 1 .. @y + 1).include?(node.y))
      end
      
      # selfnode܂ł̋ij
      def distance(node)
        return (@x - node.x).abs + (@y - node.y).abs
      end
      
      # ړ\H
      def passable?(node)
        unless adjacent?(node)
          # אڂĂȂ
          return false
        end
        # ߂
        d = self.direction(node)
        if d == 0
          return false
        end
        # ړ\
        return $game_player.passable?(@x,@y,d)
      end
      
      # אڃm[h̎擾
      def adjacency_nodes
        return [
        get_node(@x+1,@y),
        get_node(@x-1,@y),
        get_node(@x,@y+1),
        get_node(@x,@y-1),
        ]
      end
      
    end
    
    
    module Spriteset_Map
      
      # ړ͈͂ătbVf[^ݒ
      def debug_find_move_area(x,y,flash_data)
        # Xg
        open_nodes = []
        close_nodes = []
        
        init_score = 0
        max_score = 6
        
        # X^[gm[h̃XRAZo
        open_nodes.push Area_Check_Node.new(x,y,init_score)
        
        while (not open_nodes.empty?)
          # ɌvZm[hԒႢXRÃm[hT
          open_nodes.sort! {|a,b| a.score <=> b.score}
          # I[vXgO
          cnode = open_nodes.shift
          # N[YXgɒǉ
          close_nodes.push cnode
          flash_data[cnode.x,cnode.y] = 0x00f # tbVf[^ɂ
          if cnode.score >= max_score
            next
          end
          # אڃm[h擾
          cnode.adjacency_nodes.each do |anode| # אڃm[h
            next if open_nodes.include?(anode)  # oH
            next if close_nodes.include?(anode) # vZς
            next unless cnode.passable?(anode)  # ړs\
            # XRAÕm[h{P
            anode.score = cnode.score + 1
            # oHɒǉ
            open_nodes.push anode
          end
        end
      end
      
      # tbVf[^p̃^C}bv擾
      def debug_tilemap
        # ^C}bv쐬
        if @debug_tilemap.nil?
          @debug_tilemap = Tilemap.new(@viewport4)
          @debug_tilemap.map_data = Table.new($game_map.width,$game_map.height,3)
          debug_flash_data_clear()
        end
        return @debug_tilemap
      end
      
      # tbVf[^폜
      def debug_flash_data_clear()
        x = $game_player.x
        y = $game_player.y
        
        # tbVf[^폜Ă珈Ȃ
        if (not @debug_tilemap.flash_data.nil?) and (@debug_tilemap.flash_data[x,y] == 0x000)
          return
        end
        @debug_tilemap.flash_data = Table.new($game_map.width,$game_map.height)
        @chash_area = Table.new($game_map.width,$game_map.height)
      end
      
      # tbVf[^j
      def debug_flash_data_dispose()
        if not @debug_tilemap.nil?
          @debug_tilemap.dispose
          @debug_tilemap = nil
          @chash_area = nil
        end
      end
      
      # tbVf[^XV
      def debug_flash_data_update
        debug_tilemap.ox = @tilemap.ox
        debug_tilemap.oy = @tilemap.oy
        debug_tilemap.update
        
        # ړ͍XVȂB
        if $game_player.moving?
          return
        end
        
        # L[ĂȂꍇ
        unless MOVE_AREA_CHECK_KEY.any? {|k|Input.press?(k)}
          # tbVf[^폜
          debug_flash_data_clear()
          return
        end
        
        x = $game_player.x
        y = $game_player.y
        
        # L[Vɉꂽ̂ł͖ꍇ
        unless MOVE_AREA_CHECK_KEY.any? {|k|Input.trigger?(k)}
          # OƓʒuXVȂ
          new_location = [x,y]
          if @debug_flash_data_location == new_location
            return
          end
          @debug_flash_data_location = new_location
        end
        # tbVf[^폜
        debug_flash_data_clear()
        # tbVf[^쐬
        debug_find_move_area(x,y,debug_tilemap.flash_data)
      end
    end
    
  end
  
  class Spriteset_Map
    # fobN@\̃CN[h
    include Debug::Spriteset_Map
    
    # XṼGCAX
    alias debug_update update
    def update
      debug_update
      # fobN\bhĂяoitbVf[^̍XVj
      debug_flash_data_update()
    end
    
    # j̃GCAX
    alias debug_dispose dispose
    def dispose
      debug_dispose
      # fobN\bhĂяoitbVf[^̔jj
      debug_flash_data_dispose()
    end
  end
  
end
