# RGSSpR[hϊ
# Author:: fukuyama
# Date:: 2008/01/04
# Copyright:: Copyright (c) 2008 fukuyama

module Win32
  class String_Converter
    module Constants
      # R[hy[W
      CP_ACP        = 0     # ANSI
      CP_OEMCP      = 1     # OEM
      CP_MACCP      = 2     # Macintosh
      CP_THREAD_ACP = 3     # ĂяoXbh ANSI
      CP_SYMBOL     = 42    # V{
      CP_UTF7       = 65000 # UTF-7 gpĕϊ
      CP_UTF8       = 65001 # UTF-8 gpĕϊ
      
      # WideCharToMultiByte dwFlags
      WC_DISCARDNS         = 0x00000010
      WC_SEPCHARS          = 0x00000020
      WC_DEFAULTCHAR       = 0x00000040
      WC_COMPOSITECHECK    = 0x00000200
      WC_NO_BEST_FIT_CHARS = 0x00000400
      
      # MultiByteToWideChar dwFlags
      MB_PRECOMPOSED       = 0x00000001
      MB_COMPOSITE         = 0x00000002
      MB_USEGLYPHCHARS     = 0x00000004
      MB_ERR_INVALID_CHARS = 0x00000008
    end
    include Constants
    
    # Win32 APIs
    module API
      [
        %w/WideCharToMultiByte ILPIPIPP I/,
        %w/MultiByteToWideChar ILPIPI   I/,
      ].each do |args|
        const_set(args[0], Win32API.new('kernel32', *args))
      end
      
      module_function
      
      def WideChar_Convert(code_page, flags, src)
        len = WideCharToMultiByte.call(code_page, flags, src, -1, 0, 0, 0, 0) - 1;
        buf = "\0" * len
        WideCharToMultiByte.call(code_page, flags, src, -1, buf, len, 0, 0);
        return buf
      end
      
      def MultiByte_Convert(code_page, flags, src)
        len = MultiByteToWideChar.call(code_page, flags, src, -1, 0, 0);
        buf = "\0" * (len * 2)
        MultiByteToWideChar.call(code_page, flags, src, -1, buf, len);
        return buf
      end
    end
    
    # SJIS to UTF8
    def self.sjis_to_utf8(str)
      buf = API.MultiByte_Convert(CP_ACP, 0, str)
      return API.WideChar_Convert(CP_UTF8, 0, buf)
    end
    
    # UTF8 to SJIS
    def self.utf8_to_sjis(str)
      buf = API.MultiByte_Convert(CP_UTF8, 0, str)
      return API.WideChar_Convert(CP_ACP, 0, buf)
    end
    
  end
end
