#==============================================================================
#  RPG::Skillg
#------------------------------------------------------------------------------
# XLpǉ\bh
#==============================================================================

module RPG
  module Skill_Common_Function_Module
    #(0:ȂA1:GṔA2:GŚA3:ṔA4:ŚA5:P (HP 0) A6:S (HP 0) A7:gp) 
    
    # P̃XLH
    def scope_single?
      return ((@scope % 2) == 1)
    end
    # S̃XLH
    def scope_all?
      return (@scope != 0 and (@scope % 2) == 0)
    end
    # gp҃XLH
    def scope_self?
      return (@scope == 7)
    end
    # HP0XLH
    def scope_hp0?
      return (@scope == 5 and @scope == 6)
    end
    # Gւ̃XLH
    def scope_enemy?
      return (@scope != 0 and @scope <= 2)
    end
    # ւ̃XLH
    def scope_friend?
      return (@scope >= 3)
    end
    # _[WXLH
    def damage_skill?
      return @power > 0
    end
    # 񕜃XLH
    def recover_skill?
      return @power < 0
    end
    # UXL
    def attack_skill?
      return @atk_f > 0
    end
    # @UXL
    def magic_skill?
      return @atk_f == 0
    end
    # Xe[gωXLH
    def state_change_skill?
      return (state_add_skill? or state_cancel_skill?)
    end
    # Xe[gtXLH
    def state_add_skill?
      return (not @plus_state_set.empty?)
    end
    # Xe[gXLH
    def state_cancel_skill?
      return (not @minus_state_set.empty?)
    end
    # P̉񕜃XLH
    def friend_recover_single_skill?
      return (scope_friend? and scope_single? and recover_skill?)
    end
    # S̉񕜃XLH
    def friend_recover_all_skill?
      return (scope_friend? and scope_all? and recover_skill?)
    end
    
    # tXe[gɔ\͕ωXe[g܂܂邩H
    def change_ability_skill?
      @plus_state_set.each do |state_id|
        if $data_states[state_id].change_ability?
          return true
        end
      end
      return false
    end
    
    # XLH
    def ability_up_skill?
      # Xe[gtXLł͂Ȃꍇ
      if not state_add_skill?
        return false
      end
      # Ɋ|XLł͂Ȃꍇ
      if not scope_friend?
        return false
      end
      # \͕ω邩H
      return change_ability_skill?
    end
    
    # ̃XLH
    def ability_down_skill?
      # Xe[gtXLł͂Ȃꍇ
      if not state_add_skill?
        return false
      end
      # GɊ|XLł͂Ȃꍇ
      if not scope_enemy?
        return false
      end
      # \͕ω邩H
      return change_ability_skill?
    end
    
  end
  class Skill
    include Skill_Common_Function_Module
  end
end
