#==============================================================================
#  Markup_Items
#------------------------------------------------------------------------------
# }[NAbvACe
# Copyright (C) 2005 fukuyama
#==============================================================================
#
# \item[id]  whc̃ACe\
# \weapon[id]  whc̕\
# \armor[id]  whc̖h\
# ӁFʒ[ŕ\Ɛhc
#
#==============================================================================

module Markup_Item_Image
  module_function
  def query
    return /^\\item[\._]img\[([0-9]+)\]/
  end

  def transfer(bmp, x, y, text, match)
    id = match[1].to_i
    item = $data_items[id]
    icon = RPG::Cache.icon(item.icon_name)
    size = bmp.font.size
    bmp.stretch_blt(Rect.new(x, y, size, size), icon, icon.rect)
    text[query] = ''
    return x + size,y,text
  end
end

module Markup_Weapon_Image
  module_function
  def query
    return /^\\weapon[\._]img\[([0-9]+)\]/
  end

  def transfer(bmp, x, y, text, match)
    id = match[1].to_i
    item = $data_weapons[id]
    icon = RPG::Cache.icon(item.icon_name)
    size = bmp.font.size
    bmp.stretch_blt(Rect.new(x, y, size, size), icon, icon.rect)
    text[query] = ''
    return x + size,y,text
  end
end

module Markup_Armor_Image
  module_function
  def query
    return /^\\armor[\._]img\[([0-9]+)\]/
  end

  def transfer(bmp, x, y, text, match)
    id = match[1].to_i
    item = $data_armors[id]
    icon = RPG::Cache.icon(item.icon_name)
    size = bmp.font.size
    bmp.stretch_blt(Rect.new(x, y, size, size), icon, icon.rect)
    text[query] = ''
    return x + size,y,text
  end
end

String_Operation_Module.add_markup(Markup_Item_Image)
String_Operation_Module.add_markup(Markup_Weapon_Image)
String_Operation_Module.add_markup(Markup_Armor_Image)
