# Game_Map }bv[vp
# Author:: fukuyama
# Date:: 2009/02/11
# Copyright:: Copyright (c) 2009 rgss-lib

class Game_Map
  #--------------------------------------------------------------------------
  #  ZbgAbv
  #     map_id : }bv ID
  #--------------------------------------------------------------------------
  def setup(map_id)
    # }bv ID  @map_id ɋL
    @map_id = map_id
    # }bvt@C烍[hA@map ɐݒ
    @map = load_data(sprintf("Data/Map%03d.rxdata", @map_id))
    # JCX^XϐɃ^CZbg̏ݒ
    tileset = $data_tilesets[@map.tileset_id]
    @tileset_name = tileset.tileset_name
    @autotile_names = tileset.autotile_names
    @panorama_name = tileset.panorama_name
    @panorama_hue = tileset.panorama_hue
    @fog_name = tileset.fog_name
    @fog_hue = tileset.fog_hue
    @fog_opacity = tileset.fog_opacity
    @fog_blend_type = tileset.fog_blend_type
    @fog_zoom = tileset.fog_zoom
    @fog_sx = tileset.fog_sx
    @fog_sy = tileset.fog_sy
    @battleback_name = tileset.battleback_name
    @passages = tileset.passages
    @priorities = tileset.priorities
    @terrain_tags = tileset.terrain_tags
    # \W
    @display_x = 0
    @display_y = 0
    # tbVvtONA
    @need_refresh = false
    # }bvCxg̃f[^ݒ
    @events = {}
    for i in @map.events.keys
      @events[i] = Game_Event.new(@map_id, @map.events[i])
    end
    # RCxg̃f[^ݒ
    @common_events = {}
    for i in 1...$data_common_events.size
      @common_events[i] = Game_CommonEvent.new(i)
    end
    # tHO̊e
    @fog_ox = 0
    @fog_oy = 0
    @fog_tone = Tone.new(0, 0, 0, 0)
    @fog_tone_target = Tone.new(0, 0, 0, 0)
    @fog_tone_duration = 0
    @fog_opacity_duration = 0
    @fog_opacity_target = 0
    @fog_x = 0
    @fog_y = 0
    @fog_width = 0
    @fog_height = 0
    # XN[
    setup_scroll
    setup_parallax
    setup_fog
  end


  attr_reader :fog_x
  attr_reader :fog_y

  def setup_fog
    if @fog_name != ""
      tmp = RPG::Cache.fog(@fog_name,0)
      @fog_x = @display_x
      @fog_y = @display_y
      @fog_width = tmp.width
      @fog_height = tmp.height
    else
      @fog_x = 0
      @fog_y = 0
      @fog_width = 0
      @fog_height = 0
    end
  end

  def fog_name=(name)
    @fog_name = name
    setup_fog
  end

  #--------------------------------------------------------------------------
  #  ɃXN[
  #     distance : XN[鋗
  #--------------------------------------------------------------------------
  def scroll_down(distance)
    if loop_vertical?
      @display_y += distance
      @display_y %= @map.height * 128
      @parallax_y += distance
    else
      last_y = @display_y
      @display_y = [@display_y + distance, (height - 15) * 128].min
      @parallax_y += @display_y - last_y
    end
    if @fog_height != 0
      @fog_y += distance
      @fog_y %= (@fog_height * @map.height * 128)
    end
  end
  #--------------------------------------------------------------------------
  #  ɃXN[
  #     distance : XN[鋗
  #--------------------------------------------------------------------------
  def scroll_left(distance)
    if loop_horizontal?
      @display_x += @map.width * 128 - distance
      @display_x %= @map.width * 128
      @parallax_x -= distance
    else
      last_x = @display_x
      @display_x = [@display_x - distance, 0].max
      @parallax_x += @display_x - last_x
    end
    if @fog_width != 0
      @fog_x += (@fog_width * @map.width * 128) - distance
      @fog_x %= (@fog_width * @map.width * 128)
    end
  end
  #--------------------------------------------------------------------------
  #  EɃXN[
  #     distance : XN[鋗
  #--------------------------------------------------------------------------
  def scroll_right(distance)
    if loop_horizontal?
      @display_x += distance
      @display_x %= @map.width * 128
      @parallax_x += distance
    else
      last_x = @display_x
      @display_x = [@display_x + distance, (width - 20) * 128].min
      @parallax_x += @display_x - last_x
    end
    if @fog_width != 0
      @fog_x += distance
      @fog_x %= (@fog_width * @map.width * 128)
    end
  end
  #--------------------------------------------------------------------------
  #  ɃXN[
  #     distance : XN[鋗
  #--------------------------------------------------------------------------
  def scroll_up(distance)
    if loop_vertical?
      @display_y += @map.height * 128 - distance
      @display_y %= @map.height * 128
      @parallax_y -= distance
    else
      last_y = @display_y
      @display_y = [@display_y - distance, 0].max
      @parallax_y += @display_y - last_y
    end
    if @fog_height != 0
      @fog_y += (@fog_height * @map.height * 128) - distance
      @fog_y %= (@fog_height * @map.height * 128)
    end
  end

end
