#==============================================================================
#  Battle_AI_Base
#------------------------------------------------------------------------------
# 퓬`hۃNX
# Copyright (C) 2005 fukuyama
#==============================================================================

module Battle_AI_Base_Module
  
  attr_reader :name # O
  
  attr_accessor :battler  # 
  attr_accessor :targets  # 
  attr_accessor :partners # ԁi܂ށj
  
  # 
  def initialize(name='')
    @name = name
    clear
  end
  
  # NA
  def clear
    @battler = nil
    @targets = []
    @partners = []
  end
  
  # ʏU
  def setup_normal_attack(target)
    battler.current_action.clear
    battler.current_action.kind = 0
    battler.current_action.basic = 0
    battler.current_action.target_index = target.index
  end
  
  # h
  def setup_normal_guard()
    battler.current_action.clear
    battler.current_action.kind = 0
    battler.current_action.basic = 1
  end
  
  # 
  def setup_normal_escape()
    battler.current_action.clear
    battler.current_action.kind = 0
    battler.current_action.basic = 2
  end
  
  # XL
  def setup_skill(skill,target = nil)
    battler.current_action.clear
    battler.current_action.kind = 1
    battler.current_action.skill_id = skill.id
    if not target.nil?
      battler.current_action.target_index = target.index
    end
  end
  
  # ACe
  def setup_item(item,target = nil)
    battler.current_action.clear
    battler.current_action.kind = 2
    battler.current_action.item_id = item.id
    if not target.nil?
      battler.current_action.target_index = target.index
    end
  end
  
  # ANV̍쐬iftHgj
  def make_action
    setup_normal_attack(targets[0])
  end
end

# 퓬`hNX
class Battle_AI_Base
  include Battle_AI_Base_Module
end

# Battle_AI_Base p\bhڏW[
module Battle_AI_Adapter
  # AICX^X(Battle_AI_Base)
  attr_writer :ai
  
  # ̈Ϗ
  
  # g
  def battler
    @ai.battler
  end
  
  # 
  def targets
    @ai.targets
  end
  
  # 
  def partners
    @ai.partners
  end
  
  # NA
  def clear
    @ai.clear
  end
  
  # ʏU
  def setup_normal_attack(target)
    @ai.setup_normal_attack(target)
  end
  
  # h
  def setup_normal_guard()
    @ai.setup_normal_guard()
  end
  
  # 
  def setup_normal_escape()
    @ai.setup_normal_escape()
  end
  
  # XL
  def setup_skill(skill,target = nil)
    @ai.setup_skill(skill,target)
  end
  
  # ACe
  def setup_item(item,target = nil)
    @ai.setup_item(item,target)
  end
  
end
