#==============================================================================
#  Window_Status_Summary
#------------------------------------------------------------------------------
# AN^[ȈՃXe[^X
# Copyright (C) 2005 fukuyama
#==============================================================================

module DQ

class Window_Status_Summary < Window_Base
  #--------------------------------------------------------------------------
  #  IuWFNg
  #--------------------------------------------------------------------------
  def initialize(actor)
    @item_height = ITEM_HEIGHT
    super(0,0, 32 * 6 + 32, @item_height * 4 + 32)
    self.contents = Bitmap.new(self.width - 32, self.height - 32)
    @actor = actor
    refresh
  end
  #--------------------------------------------------------------------------
  #  AN^[̐ݒ
  #--------------------------------------------------------------------------
  def actor=(actor)
    if @actor != actor
      @actor = actor
      refresh
    end
  end
  #--------------------------------------------------------------------------
  #  tbV
  #--------------------------------------------------------------------------
  def refresh
    self.contents.clear
    return if @actor.nil?
    actor = @actor

    (x,y) = 0,0
    width = self.contents.width

    contents.draw_text(x,y,width,@item_height,actor.name,1)
    y += @item_height
    job_name = actor.properties[Game_Actor::PROPERTY_JOB]
    contents.draw_text(x,y,width,@item_height,job_name,1)
    y += @item_height

    contents.font.color = system_color
    rect = contents.text_size('ׂF')
    contents.draw_text(x,y,width,@item_height,'ׂF',0)
    contents.font.color = normal_color
    sex_str = actor.properties[Game_Actor::PROPERTY_SEX]
    contents.draw_text(x + rect.width,y,width - rect.width,@item_height,sex_str,0)
    y += @item_height
    contents.font.color = system_color
    contents.draw_text(x,y,rect.width,@item_height,'xF',2)
    contents.font.color = normal_color
    contents.draw_text(x + rect.width,y,width - rect.width,@item_height,actor.level.to_s,0)
  end
end

end
