#==============================================================================
#  Window_Main_Menu_Status
#------------------------------------------------------------------------------
# Cj[Xe[^X
# Copyright (C) 2005 fukuyama
#==============================================================================

module DQ

class Window_Main_Menu_Status < Window_Base

  FONT_SIZE = 22
  LINE_SIZE = 22
  ACTOR_WIDTH = 80
  ACTOR_WIDTH_SPACE = 16

  #--------------------------------------------------------------------------
  #  IuWFNg
  #--------------------------------------------------------------------------
  def initialize
    height = LINE_SIZE * 4 + 32
    width  = ACTOR_WIDTH * $game_party.actors.size
    width += ACTOR_WIDTH_SPACE * ($game_party.actors.size - 1) + 32
    x = 640 - width - 16
    y = 480 - height - 16
    super(x, y, width, height)
    create_contents
    refresh
    self.back_opacity = WINDOW_BACK_OPACITY
  end
  def create_contents
    if not self.contents.nil?
      self.contents.dispose
      self.contents = nil
    end
    self.contents = Bitmap.new(self.width - 32, self.height - 32)
  end
  #--------------------------------------------------------------------------
  #  XV
  #--------------------------------------------------------------------------
  def update
    super
    refresh
  end
  def refresh_code_actor(actor)
    return actor.hp + actor.sp + actor.level + actor.states.size
  end
  def refresh_code
    result = 0
    $game_party.actors.each do |actor|
      result += refresh_code_actor actor
    end
    return result
  end
  #--------------------------------------------------------------------------
  #  tbV
  #--------------------------------------------------------------------------
  def refresh
    update_status = refresh_code
    return if @refresh_status == update_status

    width  = ACTOR_WIDTH * $game_party.actors.size
    width += ACTOR_WIDTH_SPACE * ($game_party.actors.size - 1) + 32
    if self.width != width
      self.width = width
      create_contents
    end

    self.contents.clear
    self.contents.font.size = FONT_SIZE
    @refresh_status = 0
    for i in 0 ... $game_party.actors.size
      x = ACTOR_WIDTH * i + ACTOR_WIDTH_SPACE * i
      y = 0
      actor = $game_party.actors[i]
      status_system_color = self.system_color
      if normal_color == self.crisis_color
        status_system_color = self.crisis_color
      elsif normal_color == self.knockout_color
        status_system_color = self.knockout_color
      end
      status_normal_color = self.normal_color
      self.contents.font.size -= 2
      self.contents.font.color = status_normal_color
      self.contents.draw_text(x, y, ACTOR_WIDTH, LINE_SIZE, actor.name, 0)
      self.contents.font.size += 2
      y += LINE_SIZE
      self.contents.font.color = status_system_color
      self.contents.draw_text(x, y, ACTOR_WIDTH, LINE_SIZE, "HP", 0)
      self.contents.font.color = status_normal_color
      self.contents.font.color = crisis_color   if actor.hp <= actor.maxhp / 4
      self.contents.font.color = knockout_color if actor.hp == 0
      self.contents.draw_text(x, y, ACTOR_WIDTH, LINE_SIZE, actor.hp.to_s, 2)
      y += LINE_SIZE
      self.contents.font.color = status_system_color
      self.contents.draw_text(x, y, ACTOR_WIDTH, LINE_SIZE, $data_system.words.sp, 0)
      self.contents.font.color = status_normal_color
      self.contents.font.color = crisis_color   if actor.sp <= actor.maxsp / 4
      self.contents.draw_text(x, y, ACTOR_WIDTH, LINE_SIZE, actor.sp.to_s, 2)
      if @mode != 'no_state'
        y += LINE_SIZE
        draw_state_line(x,y,ACTOR_WIDTH,LINE_SIZE,status_system_color,status_normal_color,actor)
      end

      @refresh_status += refresh_code_actor actor
    end
  end
  def draw_state_line(x,y,width,height,status_system_color,status_normal_color,actor)
    text = make_battler_state_text(actor, width, true)
    if text == '[]'
      self.contents.font.color = status_system_color
      self.contents.draw_text(x, y, width, height, "Lv:", 0)
      self.contents.font.color = status_normal_color
      self.contents.draw_text(x, y, width, height, actor.level.to_s, 2)
    else
      self.contents.font.color = status_normal_color
      self.contents.draw_text(x, y, width, height, text, 1)
    end
  end
  def state_off
    @mode = 'no_state'
    self.height = LINE_SIZE * 3 + 32
    create_contents
    @refresh_status = 0
    refresh
  end
  def state_on
    @mode = nil
    self.height = LINE_SIZE * 4 + 32
    create_contents
    @refresh_status = 0
    refresh
  end
end

end
