#==============================================================================
#  Game_Actor#setup
#------------------------------------------------------------------------------
# AN^[ɃACeǗ
# [IɃobNpbNAN^[ɂPiItem_Max̃Reij
#==============================================================================

class Game_Actor
  attr_reader :backpack

  attr_reader :weapon
  attr_reader :armor1
  attr_reader :armor2
  attr_reader :armor3
  attr_reader :armor4

  #--------------------------------------------------------------------------
  #  ZbgAbv
  #     actor_id : AN^[ ID
  #--------------------------------------------------------------------------
  alias dq_original_setup setup
  def setup(actor_id)
    dq_original_setup actor_id

    # obNpbN̍쐬
    @backpack = Game_Item.new
    @backpack.container = Item_Max_Container.new

    if @weapon_id != 0
      @weapon = Game_Weapon.new(@weapon_id)
      @backpack.add_item @weapon
    end
    if @armor1_id != 0
      @armor1 = Game_Armor.new(@armor1_id)
      @backpack.add_item @armor1
    end
    if @armor2_id != 0
      @armor2 = Game_Armor.new(@armor2_id)
      @backpack.add_item @armor2
    end
    if @armor3_id != 0
      @armor3 = Game_Armor.new(@armor3_id)
      @backpack.add_item @armor3
    end
    if @armor4_id != 0
      @armor4 = Game_Armor.new(@armor4_id)
      @backpack.add_item @armor4
    end
  end
  #--------------------------------------------------------------------------
  # ĂACe擾
  #--------------------------------------------------------------------------
  def equip_items
    # Ƃ肠
    return [
      self.weapon,
      self.armor1,
      self.armor2,
      self.armor3,
      self.armor4
    ].compact
  end
  #--------------------------------------------------------------------------
  # ̕ύX
  #--------------------------------------------------------------------------
  def equip_item(item)
    if item.is_a?(Game_Weapon)
      self.weapon = item
    end
    if item.is_a?(Game_Armor)
      if item.kind == 0
        self.armor1 = item
      end
      if item.kind == 1
        self.armor2 = item
      end
      if item.kind == 2
        self.armor3 = item
      end
      if item.kind == 3
        self.armor4 = item
      end
    end
  end
  def remove_equip_item(item)
    if @weapon == item
      self.weapon = nil
    end
    if @armor1 == item
      self.armor1 = nil
    end
    if @armor2 == item
      self.armor2 = nil
    end
    if @armor3 == item
      self.armor3 = nil
    end
    if @armor4 == item
      self.armor4 = nil
    end
  end
  def weapon=(item)
    if item.nil?
      @weapon = nil
      @weapon_id = 0
      return
    end
    if item.is_a?(Game_Weapon)
      @weapon = item
      @weapon_id = item.id
    end
  end
  def armor1=(item)
    if item.nil?
      @armor1 = nil
      @armor1_id = 0
      return
    end
    if item.is_a?(Game_Armor)
      @armor1 = item
      @armor1_id = item.id
    end
  end
  def armor2=(item)
    if item.nil?
      @armor2 = nil
      @armor2_id = 0
      return
    end
    if item.is_a?(Game_Armor)
      @armor2 = item
      @armor2_id = item.id
    end
  end
  def armor3=(item)
    if item.nil?
      @armor3 = nil
      @armor3_id = 0
      return
    end
    if item.is_a?(Game_Armor)
      @armor3 = item
      @armor3_id = item.id
    end
  end
  def armor4=(item)
    if item.nil?
      @armor4 = nil
      @armor4_id = 0
      return
    end
    if item.is_a?(Game_Armor)
      @armor4 = item
      @armor4_id = item.id
    end
  end
end
