#==============================================================================
#  Window_Item_Base
#------------------------------------------------------------------------------
# cppACeEBhEx[X
# Copyright (C) 2005 fukuyama
#==============================================================================

module DQ

class Window_Item_Base < Window_Menu
  include Window_Tree_Module

  #--------------------------------------------------------------------------
  # ACe̎擾
  #--------------------------------------------------------------------------
  def item
    return get_menu
  end
  #--------------------------------------------------------------------------
  # ڂ̕`
  #--------------------------------------------------------------------------
  def draw_menu_item(index,color,rect,item)
    self.contents.font.color = color
    name = ''
    name = item.name if not item.nil?

    self.contents.fill_rect(rect, Color.new(0, 0, 0, 0))

    case @actor
    when Game_Actor
      # ĂACeH
      if Item_Facade.actor_equip?(item,@actor)
        name = 'E ' + name
      end
    when Game_Party
      if item.is_a?(Game_Item)
        count = @actor.backpack.item_count_id(item.id,Game_Item)
        count_rect = self.contents.text_size(count.to_s)
        rect.width -= count_rect.width
        count_rect.x = rect.width
        count_rect.y = rect.y
        self.contents.draw_text(count_rect,count.to_s,2)
      end
    end

    self.contents.draw_text(rect, name)
  end
  #--------------------------------------------------------------------------
  # AN^[ACe̍XV
  #--------------------------------------------------------------------------
  def refresh_actor_items
    @actor = self.parent.actor
    @actor = self.parent.backpack if @actor.nil?
    return if @actor.nil?

    case @actor
    when Game_Actor
      # AN^[
      equip_items = Item_Facade.equip_items(@actor)
      equip_items.each do |item|
        add_menu(item, :select_item)
      end
      @actor.backpack.each_item do |item|
        add_menu(item, :select_item) if not equip_items.include?(item)
      end
    when Game_Party
      # ӂ̏ꍇGame_ItemX^bN\
      stack = []
      @actor.backpack.each_item do |item|
        if stack.include?([item.id,item.type]) and item.is_a?(Game_Item)
          next
        end
        add_menu(item, :select_item)
        stack.push [item.id,item.type]
      end
    end

    if @actor.backpack.item_count == 0
      self.index = -1
      set_active_window(parent.class)
    end
    if @actor.backpack.item_count <= @index
      @index = @actor.backpack.item_count - 1
    end
  end
  #---------------------------------------------------------------------------
  # Rec̍쐬
  def _contents_width
    return _menu_width * @column_max
  end
  #---------------------------------------------------------------------------
  # j[̍쐬
  def _menu_width
    return WINDOW_ITEM_WIDTH
  end
end

end
