#==============================================================================
#  Markup_Text_Position
#------------------------------------------------------------------------------
# eLXg`ʒuw}[NAbv
# Copyright (C) 2005 fukuyama
#==============================================================================
#
# \bottom
# \center[dummy]
# \right[dummy]
# \current_line[s]
#
#==============================================================================

module Markup_Text_Position
	module Markup_Current_Line
	  module_function
	  def query
	    return /^\\current_line\[([0-9]+)\]/
	  end
	  def transfer(bmp, x, y, text, match)
	    index = match[1].to_i
	    y = Markup_New_Line.line_height * index
	    text[query] = ''
	    return x,y,text
	  end
	end
	String_Operation_Module.add_markup(Markup_Current_Line)

	module Markup_Bottom
	  module_function
	  def query
	    return /^\\bottom/
	  end
	  def transfer(bmp, x, y, text, match)
	    text[query] = ''
	    y = bmp.height - Markup_New_Line.line_height
	    return x,y,text
	  end
	end
	module Markup_Right
	  module_function
	  def query
	    return /^\\right\[([^\]]*)\]/
	  end
	  def transfer(bmp, x, y, text, match)
	    dummy = match[1]
	    text[query] = ''
	    rect = bmp.text_size(dummy)
	    x = bmp.width - rect.width
	    return x,y,text
	  end
	end
	module Markup_Center
	  module_function
	  def query
	    return /^\\center\[([^\]]*)\]/
	  end
	  def transfer(bmp, x, y, text, match)
	    dummy = match[1]
	    text[query] = ''
	    rect = bmp.text_size(dummy)
	    x = bmp.width / 2 - rect.width / 2
	    return x,y,text
	  end
	end
	module Markup_Center_Left
	  module_function
	  def query
	    return /^\\center_left\[([^\]]*)\]/
	  end
	  def transfer(bmp, x, y, text, match)
	    dummy = match[1]
	    text[query] = ''
	    rect = bmp.text_size(dummy)
	    x = bmp.width / 2 - rect.width
	    return x,y,text
	  end
	end
	String_Operation_Module.add_markup(Markup_Bottom)
	String_Operation_Module.add_markup(Markup_Right)
	String_Operation_Module.add_markup(Markup_Center)
	String_Operation_Module.add_markup(Markup_Center_Left)
end
