#==============================================================================
#  Window_InputString
#------------------------------------------------------------------------------
# ͗pEBhE
# Copyright (C) 2005 fukuyama
#==============================================================================

class Window_InputString < Window_Base
  attr_reader :window_input_area

  #--------------------------------------------------------------------------
  # 
  #--------------------------------------------------------------------------
  def initialize(title,count)
    @title = title
    @stringmap = [[
    '͂Ђӂւق'.split(//),
    '܂݂ނ߂'.split(//),
    '낾Âł'.split(//),
    'ĂƂ΂тԂׂ'.split(//),
    'Ȃɂʂ˂̂ς҂Ղ؂'.split(//),
    '[DcHI@@@@@'.split(//)],[
    'ACEGInqtwzKMOQS'.split(//),
    'JLNPR}~UWY[]'.split(//),
    'TVXZ\_adfh'.split(//),
    '^`cegorux{'.split(//),
    'ijklmbpsvy|'.split(//),
    '@BDFH[DcHI@@@@'.split(//)]]
    @modelist = ['','Ji']
    @mode = 0
    @cursor_x = 0
    @cursor_y = 0
    @window_input_area = Window_InputArea.new(count)
    super(16,128,640-32,32*7+32)
    self.contents = Bitmap.new(self.width - 32, self.height - 32)
    refresh
  end
  #--------------------------------------------------------------------------
  # ̓f[^̎擾
  #--------------------------------------------------------------------------
  def text
    return @window_input_area.text
  end
  #--------------------------------------------------------------------------
  # ĕ`
  #--------------------------------------------------------------------------
  def refresh
    if @mode < 0
      @mode = @modelist.size - 1
    end
    if @mode >= @modelist.size
      @mode = 0
    end

    self.contents.clear

    # ^Cg
    rect = self.contents.rect
    rect.height = 32
    self.contents.draw_text(rect,@title,1)

    # j[
    rect.x = 532
    rect.width = 44
    rect.y += 32
    self.contents.draw_text(rect,@modelist[@mode],1)
    rect.y += 32
    self.contents.draw_text(rect,'߂',1)
    rect.y += 32
    self.contents.draw_text(rect,'I',1)

    # L[{[h
    rect = Rect.new(4,32,32,32)
    @stringmap[@mode].each do |strings|
      i = 0
      strings.each do |string|
        i += 1
        self.contents.draw_text(rect,string,1)
        rect.x += 32
        if (i % 5) == 0
          rect.x += 16
        end
      end
      rect.y += 32
      rect.x = 4
    end
  end
  def cursor_index_check
    if @cursor_x < 0 or @cursor_y < 0
      return false
    end
    if @cursor_x == 15 and [0,1,2].include?(@cursor_y)
      return true
    end
    if @cursor_x >= 15 or @cursor_y >= 6
      return false
    end
    return true
  end
  #--------------------------------------------------------------------------
  # J[\̋`XV
  #--------------------------------------------------------------------------
  def update_cursor_rect
    if @cursor_x == 15 and [0,1,2].include?(@cursor_y)
      x = 532
      y = @cursor_y * 32 + 32
      self.cursor_rect.set(x - 4, y, 44 + 8, 32)
    else
      x = @cursor_x * 32 + 4
      x += 16 if @cursor_x >= 5
      x += 16 if @cursor_x >= 10
      y = @cursor_y * 32 + 32
      self.cursor_rect.set(x, y, 32, 32)
    end
  end
  #--------------------------------------------------------------------------
  # xg
  #--------------------------------------------------------------------------
  def event_decision
    if @cursor_x == 15
      case @cursor_y
      when 0 # [hύX
        decision_se
        @mode += 1
        refresh
      when 1 # ߂
        decision_se
        if @window_input_area.empty?
          # 󂾂
          dispose
        else
          # ꕶ폜
          @window_input_area.del_char
        end
      when 2 # I
        decision_se
        dispose
      end
    else
      decision_se
      @window_input_area.add_char @stringmap[@mode][@cursor_y][@cursor_x]
      if @window_input_area.max?
        # tɂȂuIv
        @cursor_x = 15
        @cursor_y = 2
      end
    end
  end
  #--------------------------------------------------------------------------
  # LZCxg
  #--------------------------------------------------------------------------
  def event_cancel
    cancel_se
    if @window_input_area.empty?
      # 󂾂
      dispose
    else
      # ꕶ폜
      @window_input_area.del_char
    end
  end
  #--------------------------------------------------------------------------
  # XV
  #--------------------------------------------------------------------------
  def update
    if Input.trigger? Input::B
      event_cancel
      return
    end
    if Input.trigger? Input::C
      event_decision
      return
    end
    if Input.trigger? Input::UP or Input.repeat? Input::UP
      @cursor_y -= 1
      if not cursor_index_check
        if @cursor_x == 15
          @cursor_y = 2
        else
          @cursor_y = 5
        end
      end
      cursor_se
    end
    if Input.trigger? Input::DOWN or Input.repeat? Input::DOWN
      @cursor_y += 1
      if not cursor_index_check
        @cursor_y = 0
      end
      cursor_se
    end
    if Input.trigger? Input::LEFT or Input.repeat? Input::LEFT
      @cursor_x -= 1
      if not cursor_index_check
        if [0,1,2].include?(@cursor_y)
          @cursor_x = 15
        else
          @cursor_x = 14
        end
      end
      cursor_se
    end
    if Input.trigger? Input::RIGHT or Input.repeat? Input::RIGHT
      @cursor_x += 1
      if not cursor_index_check
        @cursor_x = 0
      end
      cursor_se
    end
    update_cursor_rect
    super
    @window_input_area.update
  end
  #--------------------------------------------------------------------------
  # EBhEj
  #--------------------------------------------------------------------------
  def dispose
    Input.update
    super
    @window_input_area.dispose
  end
end

#==============================================================================
#  Event_Script
#------------------------------------------------------------------------------
# CxgXNvgp
#==============================================================================

module Event_Script
  @@window = nil
  @@result = ''

  module_function

  def input_string(title,count=4)
    if @@window.nil?
      @@window = Window_InputString.new(title,count)
    end
    @@window.update
    if @@window.disposed?
      @@result = @@window.text
      @@window = nil
    end
    return @@window.nil?
  end
  def result
    return @@result
  end
end
