#==============================================================================
#  Battle_AI_Base
#------------------------------------------------------------------------------
# 퓬`hۃNX
# Copyright (C) 2005 fukuyama
#==============================================================================

module Battle_AI_Base_Module
	attr_accessor :battler  # 
	attr_accessor :targets  # 
	attr_accessor :partners # ԁi܂ށj

	attr :name

	def initialize(name='')
		@name = name
		clear
	end

	def clear
		@battler = nil
		@targets = []
		@partners = []
	end

	def setup_normal_attack(target)
		battler.current_action.clear
		battler.current_action.kind = 0
		battler.current_action.basic = 0
		battler.current_action.target_index = target.index
	end
	def setup_normal_guard()
		battler.current_action.clear
		battler.current_action.kind = 0
		battler.current_action.basic = 1
	end
	def setup_normal_escape()
		battler.current_action.clear
		battler.current_action.kind = 0
		battler.current_action.basic = 2
	end
	def setup_skill(skill,target = nil)
		battler.current_action.clear
		battler.current_action.kind = 1
		battler.current_action.skill_id = skill.id
		if not target.nil?
			battler.current_action.target_index = target.index
		end
	end
	def setup_item(item,target = nil)
		battler.current_action.clear
		battler.current_action.kind = 2
		battler.current_action.item_id = item.id
		if not target.nil?
			battler.current_action.target_index = target.index
		end
	end

	def make_action
		setup_normal_attack(targets[0])
	end
end

class Battle_AI_Base
	include Battle_AI_Base_Module
end
