<?php
// $Id: rdbomanager.php,v 1.3 2003/06/15 13:12:33 haruki Exp $
//
// RdbObject and its Manager
//
// Copyright (C) Haruki Setoyama <pwaf.haruki@planewave.org>
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
/**
* RdbObject and Manager
* class to manupulate data stored in relational database server
*
* @auther Haruki Setoyama <pwaf.haruki@planewave.org>
* @lisence LGPL
* @since 2003.06
*/
/**
* define config.
*/
if(! defined('RDBOBJECT_DEBUG')) define('RDBOBJECT_DEBUG', true);
/**
* rdbObjectManagerFactory
*
* @access  abstract
*/
class rdbObjectManagerFactory
{
    /**
    * object instanciation. Use singleton class.
    * @access  publc
    */
    function &getInstance()
    {
        $rdbm = $this->_rdbm();
        $class = 'rdbObjectManager_'.$rdbm;
        $manager = new $class;
        $manager->handler = get_class($this);
        $classname = $this->_rdbObject();
        $manager->rdbObject = new $classname;

        $manager->initReference();
        $manager->initElement($this->_config());
        $manager->initColumns($this->_column($rdbm));
        $manager->table = $this->_table($rdbm);
        $manager->linkid =& $this->_linkid($rdbm);
        $manager->logger =& $this->_logger();
        
        return $manager;
    }

    ///// implement these private function in child class. /////

    /**
    * returns name of database srver
    * @return string
    * @access  private
    */
    function _rdbm() { return 'mysql'; }

    /**
    * returns name of rdbObject class
    * @return string
    * @access  private
    */
    function _rdbObject() { return 'rdbObjectDebug'; }

    /**
    * returns configuratons for each rdbObject element
    * @return array
    * @access  private
    */
    function _config() { return array(); }

    /**
    * returns correspondence of variable name to column name
    * @return array
    * @access private
    */
    function _column($rdbm) { return false; }

    /**
    * returns table name this object use
    * @return string
    * @access  private
    */
    function _table($rdbm) {}

    /**
    * returns link id
    * @access private
    */
    function &_linkid($rdbm) {}

    /**
    * returns logger object. LoggerSimpler class is default.
    * @access private
    */
    function &_logger()
    {
        return new nullLogger;
    }
}

/**
* rdbObjectManager
*
* Chiled classes will be implemented for respective database server
* with the name like 'rdbObjectElement_mysql'
* @access  abstract
*/
class rdbObjectManager
{
    /**
    * blank rdbObject instance.
    * @access  public
    */
    var $rdbObject;

    /**
    * name of handler class of myself
    * @access  public
    */
    var $handler = '';

    /**
    * (variable name => rdbObjectElement) Hash
    * @access  public
    */
    var $element = array();

    /**
    * (variable name => column name) Hash
    * @access  public
    */
    var $column = array();

    /**
    * table name & linkid to database server
    * @access  public
    */
    var $table;
    var $linkid;

    /**
    * variable names which have or have not column in database
    * @access  public
    */
    var $actuals = array();
    var $virtuals = array();

    /**
    * variable name and column name of primary key
    * @access  public
    */
    var $pkey;
    var $pkey_column;

    /**
    * If the element is numeric or not. bool
    * @access  public
    */
    var $numeric = array();

    /**
    * logger object
    * @access  public
    */
    var $logger;

    /**
    * constructor
    * @access  public
    */
    function rdbObjectManager()
    {
    }

    function initReference()
    {
        $this->rdbObject->handler =& $this->handler;
        $this->rdbObject->element =& $this->element;
        $this->rdbObject->pkey =& $this->pkey;
    }

    /**
    * initialize variables of the rdbObject this manager handles.
    * @access  public
    */
    function initElement($configs)
    {
        foreach($configs as $name => $config)
        {
            $classname = 'rdbObjectElement_'.$config['type'];
            if(!class_exists($classname))
            {
                $this->_trigger_error('initElement()::Invalid element type. '.$config['type']
                                ,E_USER_WARNING);
                continue;
            }
            $this->element[$name] = new $classname;
            $this->element[$name]->varname = $name;
            if(isset($config['option']))
                $this->element[$name]->option = array_merge($this->element[$name]->option, $config['option']);
        }
    }

    function initColumns($columns)
    {
        $names = array_keys($this->element);
        foreach($names as $name)
        {
            if(is_a($this->element[$name], 'rdbObjectVirtualElement'))
            {
                $this->virtuals[] = $name;
            }
            else
            {
                $this->column[$name] = (isset($columns[$name])) ? $columns[$name] : $name;
                $this->element[$name]->column =& $this->column[$name];
                $this->numeric[$name] = is_a($this->element[$name], 'rdbObjectNumericElement');
                if(is_a($this->element[$name], 'rdbObjectElement_pkey'))
                {
                    $this->pkey = $name;
                    $this->pkey_column =& $this->column[$this->pkey];
                }
                else
                {
                    $this->actuals[] = $name;
                }
                if(isset($this->element[$name]->option['default']))
                    $this->rdbObject->dbRawData[$this->column[$name]] = $this->element[$name]->option['default'];
            }
        }
    }

    /**
    * create new rdbObject instance
    * @access  public
    */
    function create()
    {
        return $this->rdbObject;
    }

    ///// implement these functions in child class

    function &openAll() {}
    function &openOne($pkey) {}
    function &openMany($pkeys) {}
    function &openWith($varname, $value, $opetator ='=') {}
    function &openWhere($where) {}
    function &openConditional($condition) {}

    function &openJoin($join_varname, $varname, $value, $opetator ='=') {}
    function &openJoins($joins) {}

    function getPkey($condition) {}

    function count($condition) {}

    function clearCache() {}

    /////

    function save(&$object) {}
    function saveAsNew(&$object) {}
    function delete(&$object) {}


    /////

    function quote($val) {}

    ///// mainly for sqlCondition and sqlComparisons

    /**
    * render comparison statement
    * @access  public
    */
    function renderComparison($variable, $value, $operator = '=')
    {
        if(!isset($this->column[$variable]))
        {
            $this->_trigger_error('renderComparison()::Non registerd variable'
                            , E_USER_NOTICE);
            $column = (string)$variable;
        }
        else
        {
            $column = $this->column[$variable];
        }

        if($value === null)
        {
            switch($operator){
            case '=':
            case '<=':
            case '>=':
            case 'LIKE':
                return $column.' IS NULL';

            default:
                return $column.' IS NOT NULL';
            }
        }
        else
        {
            return $column.' '.$operator.' '.$this->quote($value, $variable).'';
        }
    }

    /**
    * render order-by statement
    * @access  public
    */
    function renderOrder($orders)
    {
        $element = array();
        foreach($orders as $order)
        {
            $element[] = $this->colmun[$order[0]].$order[1];
        }
        return implode(',', $element);
    }

    /**
    * render group-by statement
    * @access  public
    */
    function renderGruop($gruops)
    {
        $element = array();
        foreach($gruops as $gruop)
        {
            $element[] = $this->colmun[$gruop[0]];
        }
        return implode(',', $element);
    }

    ///// private functions

    function _trigger_error($msg, $type)
    {
        if(RDBOBJECT_DEBUG != false)
            trigger_error(get_class($this).'::'.$msg, $type);
    }

    function _log($msg)
    {
        if(RDBOBJECT_DEBUG != false) $this->logger->log($msg, $this->handler);
    }

    function _valid_rdbobject(&$object)
    {
        if(!is_a($object, 'rdbObject') || ($object->handler != $this->handler))
            return false;
        else
            return true;
    }
}

class nullLogger
{
    function log($msg, $type) { }
}
?>