/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.pal.nvwidget.util;

import java.util.ArrayList;
import java.util.List;
import jp.sf.pal.nvwidget.entity.NvWidget;
import jp.sf.pal.nvwidget.pager.NvWidgetPager;
import jp.sf.pal.nvwidget.util.NvWidgetList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NvWidgetHandler
extends DefaultHandler {
    private NvWidgetList<NvWidget> nvWidgetList;
    private NvWidget nvWidget;
    private List<String> stack;
    private NvWidgetPager nvWidgetPager;

    public NvWidgetHandler(NvWidgetPager nvWidgetPager) {
        this.nvWidgetPager = nvWidgetPager;
    }

    @Override
    public void startDocument() throws SAXException {
        this.stack = new ArrayList();
    }

    @Override
    public void endDocument() throws SAXException {
        this.stack = null;
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        this.stack.add(name);
        if ("items".equals(name)) {
            this.nvWidgetList = new NvWidgetList();
            if (this.nvWidgetPager.getPage() > 1) {
                this.nvWidgetList.setExistPrevPage(true);
            } else {
                this.nvWidgetList.setExistPrevPage(false);
            }
            for (int i = 0; i < attributes.getLength(); ++i) {
                String attrName = attributes.getQName(i);
                String attrValue = attributes.getValue(i);
                if ("total".equals(attrName)) {
                    try {
                        this.nvWidgetList.setAllRecordCount(Integer.parseInt(attrValue));
                    }
                    catch (NumberFormatException e) {
                        this.nvWidgetList.setAllRecordCount(0);
                    }
                    continue;
                }
                if ("page".equals(attrName)) {
                    try {
                        this.nvWidgetList.setCurrentPageNumber(Integer.parseInt(attrValue));
                    }
                    catch (NumberFormatException e) {
                        this.nvWidgetList.setCurrentPageNumber(this.nvWidgetPager.getPage());
                    }
                    continue;
                }
                if (!"totalPages".equals(attrName)) continue;
                try {
                    this.nvWidgetList.setAllPageCount(Integer.parseInt(attrValue));
                }
                catch (NumberFormatException e) {
                    this.nvWidgetList.setAllPageCount(1);
                }
                if (this.nvWidgetPager.getPage() < this.nvWidgetList.getAllPageCount()) {
                    this.nvWidgetList.setExistNextPage(true);
                    continue;
                }
                this.nvWidgetList.setExistNextPage(false);
            }
        } else if ("item".equals(name)) {
            this.nvWidget = new NvWidget();
        }
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        if ("item".equals(name)) {
            this.nvWidgetList.add((Object)this.nvWidget);
            this.nvWidget = null;
        }
        this.stack.remove(this.stack.size() - 1);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.stack != null) {
            String tagName = (String)this.stack.get(this.stack.size() - 1);
            if (this.nvWidget != null) {
                if ("id".equals(tagName)) {
                    this.nvWidget.setId(new String(ch, start, length));
                } else if ("title".equals(tagName)) {
                    this.nvWidget.setName(this.nvWidget.getName() + new String(ch, start, length));
                } else if ("link".equals(tagName)) {
                    this.nvWidget.setUrl(new String(ch, start, length));
                } else if ("description".equals(tagName)) {
                    this.nvWidget.setDescription(this.nvWidget.getDescription() + new String(ch, start, length));
                } else if ("thumbnail".equals(tagName)) {
                    this.nvWidget.setThumbnail(new String(ch, start, length));
                }
            }
        }
    }

    public NvWidgetList<NvWidget> getNvWidgetList() {
        return this.nvWidgetList;
    }
}

