/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.pal.nvwidget.pager;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class NvWidgetPager
implements Serializable {
    private static final long serialVersionUID = 237701365907034437L;
    private int page = 1;
    private int limit = 20;
    private String category;
    private String query;
    private String region = "us";

    public void reset() {
        this.page = 1;
        this.limit = 20;
        this.category = null;
        this.query = null;
        this.region = "us";
    }

    public String buildUrl() {
        StringBuilder url = new StringBuilder("http://api.eco.netvibes.com/search/?type=uwa");
        url.append("&page=").append(this.page);
        url.append("&limit=").append(this.limit);
        if (this.category != null) {
            url.append("&category=").append(this.category);
        }
        if (this.query != null && !"".equals(this.query)) {
            try {
                url.append("&query=").append(URLEncoder.encode(this.query, "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        if (this.region != null) {
            url.append("&region=").append(this.region);
        }
        return url.toString();
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int start) {
        this.page = start;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int num) {
        this.limit = num;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String language) {
        this.region = language;
    }
}

