/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.pal.nvwidget.action;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import jp.sf.pal.nvwidget.NvWidgetException;
import jp.sf.pal.nvwidget.entity.NvWidget;
import jp.sf.pal.nvwidget.form.EditForm;
import jp.sf.pal.nvwidget.pager.NvWidgetPager;
import jp.sf.pal.nvwidget.service.NvWidgetService;
import jp.sf.pal.nvwidget.util.NvWidgetList;
import jp.sf.pal.nvwidget.util.NvWidgetUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.framework.container.hotdeploy.HotdeployUtil;
import org.seasar.struts.annotation.ActionForm;
import org.seasar.struts.annotation.Execute;
import org.seasar.struts.exception.ActionMessagesException;

public class EditAction {
    private static final Log log = LogFactory.getLog(EditAction.class);
    public List<NvWidget> widgetItems;
    public List<Integer> pageItems;
    public String currentName;
    public boolean existPrevPage;
    public boolean existNextPage;
    public int allRecordCount;
    public int allPageCount;
    public int currentPageNumber;
    @ActionForm
    private EditForm editForm;
    private NvWidgetPager nvWidgetPager;
    private NvWidgetService nvWidgetService;
    private transient HttpServletRequest request;

    @Execute(validator=false, input="error.jsp")
    public String index() {
        try {
            int endIdx;
            this.currentName = NvWidgetUtil.getPreferenceValue((HttpServletRequest)this.request, (String)"name", (String)"");
            this.editForm.height = NvWidgetUtil.getPreferenceValue((HttpServletRequest)this.request, (String)"height", (String)"250");
            this.editForm.category = this.nvWidgetPager.getCategory();
            this.editForm.query = this.nvWidgetPager.getQuery();
            this.editForm.region = this.nvWidgetPager.getRegion();
            NvWidgetList widgets = this.nvWidgetService.getNvWidgetList(this.nvWidgetPager);
            this.allRecordCount = widgets.getAllRecordCount();
            this.allPageCount = widgets.getAllPageCount();
            this.currentPageNumber = widgets.getCurrentPageNumber();
            this.existPrevPage = widgets.isExistPrevPage();
            this.existNextPage = widgets.isExistNextPage();
            this.widgetItems = widgets;
            this.request.getSession().setAttribute("widgetItems", (Object)this.widgetItems);
            int startIdx = this.currentPageNumber - 5;
            if (startIdx < 1) {
                startIdx = 1;
            }
            if ((endIdx = this.currentPageNumber + 5) > this.allPageCount) {
                endIdx = this.allPageCount;
            }
            this.pageItems = new ArrayList();
            for (int i = startIdx; i <= endIdx; ++i) {
                this.pageItems.add(i);
            }
            return "index.jsp";
        }
        catch (NvWidgetException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new ActionMessagesException("errors.could_not_load_widget_info", new Object[0]);
        }
    }

    @Execute(validator=false, input="error.jsp", urlPattern="setcategory/{category}")
    public String find() {
        this.nvWidgetPager.reset();
        this.nvWidgetPager.setCategory(this.editForm.category);
        this.nvWidgetPager.setQuery(this.editForm.query);
        this.nvWidgetPager.setRegion(this.editForm.region);
        return this.index();
    }

    @Execute(validator=false, input="error.jsp", urlPattern="list/{pageNumber}")
    public String list() {
        try {
            this.nvWidgetPager.setPage(Integer.parseInt(this.editForm.pageNumber));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return this.index();
    }

    @Execute(validator=false, input="error.jsp")
    public String change() {
        try {
            NvWidgetUtil.changeHeight((HttpServletRequest)this.request, (String)this.editForm.height);
            NvWidgetUtil.addMessage((HttpServletRequest)this.request, (String)"success.update_height");
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new ActionMessagesException("errors.failed_to_update_because_of_system_error", new Object[0]);
        }
        return this.index();
    }

    @Execute(validator=false, input="error.jsp", urlPattern="update/{id}")
    public String update() {
        if (this.editForm.id == null) {
            throw new ActionMessagesException("errors.failed_to_update_because_of_no_id", new Object[0]);
        }
        this.widgetItems = (List)this.request.getSession().getAttribute("widgetItems");
        if (this.widgetItems == null) {
            throw new ActionMessagesException("errors.failed_to_update_because_of_no_session", new Object[0]);
        }
        this.widgetItems = (List)HotdeployUtil.rebuildValue((Object)this.widgetItems);
        boolean isUpdate = false;
        for (NvWidget widget : this.widgetItems) {
            if (!widget.getId().equals(this.editForm.id)) continue;
            try {
                NvWidgetUtil.store((HttpServletRequest)this.request, (NvWidget)widget);
                NvWidgetUtil.addMessage((HttpServletRequest)this.request, (String)"success.update_widget");
                isUpdate = true;
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new ActionMessagesException("errors.failed_to_update_because_of_system_error", new Object[0]);
            }
        }
        if (!isUpdate) {
            throw new ActionMessagesException("errors.failed_to_update_because_of_no_object", new Object[0]);
        }
        return this.index();
    }

    @Execute(validator=false, input="error.jsp")
    public String prev() {
        int start = this.nvWidgetPager.getPage();
        if (--start < 1) {
            start = 1;
        }
        this.nvWidgetPager.setPage(start);
        return this.index();
    }

    @Execute(validator=false, input="error.jsp")
    public String next() {
        int start = this.nvWidgetPager.getPage();
        this.nvWidgetPager.setPage(++start);
        return this.index();
    }

    public NvWidgetService getNvWidgetService() {
        return this.nvWidgetService;
    }

    public void setNvWidgetService(NvWidgetService widgetService) {
        this.nvWidgetService = widgetService;
    }

    public NvWidgetPager getNvWidgetPager() {
        return this.nvWidgetPager;
    }

    public void setNvWidgetPager(NvWidgetPager widgetPager) {
        this.nvWidgetPager = widgetPager;
    }

    public EditForm getEditForm() {
        return this.editForm;
    }

    public void setEditForm(EditForm editForm) {
        this.editForm = editForm;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }
}

