/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.usermodel;

import java.awt.Font;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.poi.hssf.usermodel.FontDetails;

class StaticFontMetrics {
    private static Properties fontMetricsProps;
    private static Map fontDetailsMap;
    static /* synthetic */ Class class$org$apache$poi$hssf$usermodel$FontDetails;

    StaticFontMetrics() {
    }

    public static FontDetails getFontDetails(Font font) {
        String fontName;
        if (fontMetricsProps == null) {
            InputStream metricsIn = null;
            try {
                fontMetricsProps = new Properties();
                if (System.getProperty("font.metrics.filename") != null) {
                    String filename = System.getProperty("font.metrics.filename");
                    File file = new File(filename);
                    if (!file.exists()) {
                        throw new FileNotFoundException("font_metrics.properties not found at path " + file.getAbsolutePath());
                    }
                    metricsIn = new FileInputStream(file);
                } else {
                    metricsIn = (class$org$apache$poi$hssf$usermodel$FontDetails == null ? (class$org$apache$poi$hssf$usermodel$FontDetails = StaticFontMetrics.class$("org.apache.poi.hssf.usermodel.FontDetails")) : class$org$apache$poi$hssf$usermodel$FontDetails).getResourceAsStream("/font_metrics.properties");
                    if (metricsIn == null) {
                        throw new FileNotFoundException("font_metrics.properties not found in classpath");
                    }
                }
                fontMetricsProps.load(metricsIn);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not load font metrics: " + e.getMessage());
            }
            finally {
                if (metricsIn != null) {
                    try {
                        metricsIn.close();
                    }
                    catch (IOException ignore) {}
                }
            }
        }
        if (fontDetailsMap.get(fontName = font.getName()) == null) {
            FontDetails fontDetails = FontDetails.create(fontName, fontMetricsProps);
            fontDetailsMap.put(fontName, fontDetails);
            return fontDetails;
        }
        return (FontDetails)fontDetailsMap.get(fontName);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        fontDetailsMap = new HashMap();
    }
}

