/*
 * Decompiled with CFR 0.152.
 */
package mondrian.xmla.impl;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Stack;
import mondrian.xmla.SaxWriter;
import org.eigenbase.xom.XMLUtil;
import org.eigenbase.xom.XOMUtil;
import org.xml.sax.Attributes;

public class DefaultSaxWriter
implements SaxWriter {
    private static final int STATE_IN_TAG = 0;
    private static final int STATE_END_ELEMENT = 1;
    private static final int STATE_AFTER_TAG = 2;
    private static final int STATE_CHARACTERS = 3;
    private final PrintWriter writer;
    private int indent;
    private String indentStr = "  ";
    private final Stack stack = new Stack();
    private int state = 1;
    private static final Attributes EmptyAttributes = new Attributes(){

        public int getLength() {
            return 0;
        }

        public String getURI(int index) {
            return null;
        }

        public String getLocalName(int index) {
            return null;
        }

        public String getQName(int index) {
            return null;
        }

        public String getType(int index) {
            return null;
        }

        public String getValue(int index) {
            return null;
        }

        public int getIndex(String uri, String localName) {
            return 0;
        }

        public int getIndex(String qName) {
            return 0;
        }

        public String getType(String uri, String localName) {
            return null;
        }

        public String getType(String qName) {
            return null;
        }

        public String getValue(String uri, String localName) {
            return null;
        }

        public String getValue(String qName) {
            return null;
        }
    };

    public DefaultSaxWriter(OutputStream stream) {
        this(new OutputStreamWriter(stream));
    }

    public DefaultSaxWriter(OutputStream stream, String xmlEncoding) throws UnsupportedEncodingException {
        this(new OutputStreamWriter(stream, xmlEncoding));
    }

    public DefaultSaxWriter(Writer writer) {
        this(new PrintWriter(writer), 0);
    }

    public DefaultSaxWriter(PrintWriter writer, int initialIndent) {
        this.writer = writer;
        this.indent = initialIndent;
    }

    private void _startElement(String namespaceURI, String localName, String qName, Attributes atts) {
        int i;
        this._checkTag();
        if (this.indent > 0) {
            this.writer.println();
        }
        for (i = 0; i < this.indent; ++i) {
            this.writer.write(this.indentStr);
        }
        ++this.indent;
        this.writer.write(60);
        this.writer.write(qName);
        for (i = 0; i < atts.getLength(); ++i) {
            XMLUtil.printAtt((PrintWriter)this.writer, (String)atts.getQName(i), (String)atts.getValue(i));
        }
        this.state = 0;
    }

    private void _checkTag() {
        if (this.state == 0) {
            this.state = 2;
            this.writer.print(">");
        }
    }

    private void _endElement(String namespaceURI, String localName, String qName) {
        --this.indent;
        if (this.state == 0) {
            this.writer.write("/>");
        } else {
            if (this.state != 3) {
                this.writer.println();
                for (int i = 0; i < this.indent; ++i) {
                    this.writer.write(this.indentStr);
                }
            }
            this.writer.write("</");
            this.writer.write(qName);
            this.writer.write(62);
        }
        this.state = 1;
    }

    private void _characters(char[] ch, int start, int length) {
        this._checkTag();
        String s = new String(ch, start, length);
        if (XOMUtil.stringHasXMLSpecials((String)s)) {
            XMLUtil.stringEncodeXML((String)s, (PrintWriter)this.writer);
        } else {
            this.writer.print(s);
        }
        this.state = 3;
    }

    public void characters(String s) {
        if (s != null && s.length() > 0) {
            this._characters(s.toCharArray(), 0, s.length());
        }
    }

    public void element(String tagName, String[] attributes) {
        this.startElement(tagName, attributes);
        this.endElement();
    }

    public void startElement(String tagName) {
        this._startElement(null, null, tagName, EmptyAttributes);
        this.stack.push(tagName);
    }

    public void startElement(String tagName, String[] attributes) {
        this._startElement(null, null, tagName, new StringAttributes(attributes));
        this.stack.push(tagName);
    }

    public void endElement() {
        String tagName = (String)this.stack.pop();
        this._endElement(null, null, tagName);
    }

    public void startDocument() {
        if (this.stack.size() != 0) {
            throw new IllegalStateException("Document already started");
        }
    }

    public void endDocument() {
        if (this.stack.size() != 0) {
            throw new IllegalStateException("Document may have unbalanced elements");
        }
        this.writer.flush();
    }

    public void completeBeforeElement(String tagName) {
        if (this.stack.indexOf(tagName) == -1) {
            return;
        }
        String currentTagName = (String)this.stack.peek();
        while (!tagName.equals(currentTagName)) {
            this._endElement(null, null, currentTagName);
            this.stack.pop();
            currentTagName = (String)this.stack.peek();
        }
    }

    public void verbatim(String text) {
        this._checkTag();
        this.writer.print(text);
    }

    public void flush() {
        this.writer.flush();
    }

    public static class StringAttributes
    implements Attributes {
        private final String[] strings;

        public StringAttributes(String[] strings) {
            this.strings = strings;
        }

        public int getLength() {
            return this.strings.length / 2;
        }

        public String getURI(int index) {
            return null;
        }

        public String getLocalName(int index) {
            return null;
        }

        public String getQName(int index) {
            return this.strings[index * 2];
        }

        public String getType(int index) {
            return null;
        }

        public String getValue(int index) {
            return this.strings[index * 2 + 1];
        }

        public int getIndex(String uri, String localName) {
            return -1;
        }

        public int getIndex(String qName) {
            int count = this.strings.length / 2;
            for (int i = 0; i < count; ++i) {
                String string = this.strings[i * 2];
                if (!string.equals(qName)) continue;
                return i;
            }
            return -1;
        }

        public String getType(String uri, String localName) {
            return null;
        }

        public String getType(String qName) {
            return null;
        }

        public String getValue(String uri, String localName) {
            return null;
        }

        public String getValue(String qName) {
            int index = this.getIndex(qName);
            if (index < 0) {
                return null;
            }
            return this.strings[index * 2 + 1];
        }
    }
}

