/*
 * Decompiled with CFR 0.152.
 */
package mondrian.util;

import java.util.Iterator;
import mondrian.util.PrimeFinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectPool<T> {
    protected static final byte FREE = 0;
    protected static final byte FULL = 1;
    protected static final int DEFAULT_CAPACITY = 277;
    protected static final double DEFAULT_MIN_LOAD_FACTOR = 0.2;
    protected static final double DEFAULT_MAX_LOAD_FACTOR = 0.5;
    protected int distinct;
    protected int lowWaterMark;
    protected int highWaterMark;
    protected double minLoadFactor;
    protected double maxLoadFactor;
    protected T[] values;
    protected byte[] state;
    protected int freeEntries;

    public ObjectPool() {
        this(277);
    }

    public ObjectPool(int initialCapacity) {
        this(initialCapacity, 0.2, 0.5);
    }

    public ObjectPool(int initialCapacity, double minLoadFactor, double maxLoadFactor) {
        this.setUp(initialCapacity, minLoadFactor, maxLoadFactor);
    }

    public int size() {
        return this.distinct;
    }

    public void trimToSize() {
        int newCapacity = this.nextPrime((int)(1.0 + 1.2 * (double)this.size()));
        if (this.values.length > newCapacity) {
            this.rehash(newCapacity);
        }
    }

    public boolean contains(T key) {
        int i = this.indexOfInsertion(key);
        return i < 0;
    }

    public T add(T key) {
        int i = this.indexOfInsertion(key);
        if (i < 0) {
            i = -i - 1;
            return this.values[i];
        }
        if (this.distinct > this.highWaterMark) {
            int newCapacity = this.chooseGrowCapacity(this.distinct + 1, this.minLoadFactor, this.maxLoadFactor);
            this.rehash(newCapacity);
            return this.add(key);
        }
        this.values[i] = key;
        if (this.state[i] == 0) {
            --this.freeEntries;
        }
        this.state[i] = 1;
        ++this.distinct;
        if (this.freeEntries < 1) {
            int newCapacity = this.chooseGrowCapacity(this.distinct + 1, this.minLoadFactor, this.maxLoadFactor);
            this.rehash(newCapacity);
        }
        return key;
    }

    public void clear() {
        this.values = new Object[this.values.length];
        this.state = new byte[this.state.length];
        this.distinct = 0;
        this.freeEntries = this.values.length;
        this.trimToSize();
    }

    public Iterator iterator() {
        return new Itr();
    }

    protected int chooseGrowCapacity(int size, double minLoad, double maxLoad) {
        return this.nextPrime(Math.max(size + 1, (int)((double)(4 * size) / (3.0 * minLoad + maxLoad))));
    }

    protected int chooseHighWaterMark(int capacity, double maxLoad) {
        return Math.min(capacity - 2, (int)((double)capacity * maxLoad));
    }

    protected int chooseLowWaterMark(int capacity, double minLoad) {
        return (int)((double)capacity * minLoad);
    }

    protected int chooseMeanCapacity(int size, double minLoad, double maxLoad) {
        return this.nextPrime(Math.max(size + 1, (int)((double)(2 * size) / (minLoad + maxLoad))));
    }

    protected int chooseShrinkCapacity(int size, double minLoad, double maxLoad) {
        return this.nextPrime(Math.max(size + 1, (int)((double)(4 * size) / (minLoad + 3.0 * maxLoad))));
    }

    protected int nextPrime(int desiredCapacity) {
        return PrimeFinder.nextPrime(desiredCapacity);
    }

    protected void setUp(int initialCapacity, double minLoadFactor, double maxLoadFactor) {
        int capacity = initialCapacity;
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Initial Capacity must not be less than zero: " + initialCapacity);
        }
        if (minLoadFactor < 0.0 || minLoadFactor >= 1.0) {
            throw new IllegalArgumentException("Illegal minLoadFactor: " + minLoadFactor);
        }
        if (maxLoadFactor <= 0.0 || maxLoadFactor >= 1.0) {
            throw new IllegalArgumentException("Illegal maxLoadFactor: " + maxLoadFactor);
        }
        if (minLoadFactor >= maxLoadFactor) {
            throw new IllegalArgumentException("Illegal minLoadFactor: " + minLoadFactor + " and maxLoadFactor: " + maxLoadFactor);
        }
        if ((capacity = this.nextPrime(capacity)) == 0) {
            capacity = 1;
        }
        this.values = new Object[capacity];
        this.state = new byte[capacity];
        this.minLoadFactor = minLoadFactor;
        this.maxLoadFactor = capacity == Integer.MAX_VALUE ? 1.0 : maxLoadFactor;
        this.distinct = 0;
        this.freeEntries = capacity;
        this.lowWaterMark = 0;
        this.highWaterMark = this.chooseHighWaterMark(capacity, this.maxLoadFactor);
    }

    protected int hash(T key) {
        return key == null ? 0 : key.hashCode();
    }

    protected boolean equals(T t, T key) {
        return t != null && t.equals(key);
    }

    protected int indexOfInsertion(T key) {
        T[] tab = this.values;
        byte[] stat = this.state;
        int length = tab.length;
        int hash = this.hash(key) & Integer.MAX_VALUE;
        int i = hash % length;
        int decrement = hash % (length - 2);
        if (decrement == 0) {
            decrement = 1;
        }
        while (stat[i] == 1 && !this.equals(tab[i], key)) {
            if ((i -= decrement) >= 0) continue;
            i += length;
        }
        return stat[i] == 1 ? -i - 1 : i;
    }

    protected void rehash(int newCapacity) {
        int oldCapacity = this.values.length;
        T[] oldValues = this.values;
        byte[] oldState = this.state;
        Object[] newValues = new Object[newCapacity];
        byte[] newState = new byte[newCapacity];
        this.lowWaterMark = this.chooseLowWaterMark(newCapacity, this.minLoadFactor);
        this.highWaterMark = this.chooseHighWaterMark(newCapacity, this.maxLoadFactor);
        this.values = newValues;
        this.state = newState;
        this.freeEntries = newCapacity - this.distinct;
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldState[i] != 1) continue;
            T element = oldValues[i];
            int index = this.indexOfInsertion(element);
            newValues[index] = element;
            newState[index] = 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Itr
    implements Iterator<T> {
        int index = 0;

        Itr() {
        }

        @Override
        public boolean hasNext() {
            if (this.index == ObjectPool.this.state.length) {
                return false;
            }
            while (ObjectPool.this.state[this.index] != 1) {
                ++this.index;
                if (this.index != ObjectPool.this.state.length) continue;
                return false;
            }
            return ObjectPool.this.state[this.index] == 1;
        }

        @Override
        public T next() {
            return ObjectPool.this.values[this.index++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("ObjectPool.Itr.remove");
        }
    }
}

