/*
 * Decompiled with CFR 0.152.
 */
package mondrian.gui;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class JDBCTreeModel
implements TreeModel {
    private Vector treeModelListeners = new Vector();
    Connection connection;
    DatabaseMetaData metadata;
    List catalogs;
    Node root;

    public JDBCTreeModel(Connection c) {
        this.connection = c;
        try {
            this.metadata = this.connection.getMetaData();
            this.catalogs = new ArrayList();
            String catalogName = this.connection.getCatalog();
            Node cat = new Node(catalogName, 0);
            ResultSet trs = this.metadata.getTables(cat.name, null, null, null);
            while (trs.next()) {
                Node table = new Node(trs.getString(3), 1);
                cat.children.add(table);
                ResultSet crs = this.metadata.getColumns(cat.name, null, table.name, null);
                while (crs.next()) {
                    Node column = new Node(crs.getString(4), 2);
                    table.children.add(column);
                }
            }
            this.root = cat;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void addTreeModelListener(TreeModelListener l) {
        this.treeModelListeners.add(l);
    }

    public Object getChild(Object parent, int index) {
        if (parent instanceof Node) {
            return ((Node)parent).children.get(index);
        }
        return null;
    }

    public int getChildCount(Object parent) {
        if (parent instanceof Node) {
            return ((Node)parent).children.size();
        }
        return 0;
    }

    public int getIndexOfChild(Object parent, Object child) {
        if (parent instanceof Node) {
            return ((Node)parent).children.indexOf(child);
        }
        return -1;
    }

    public Object getRoot() {
        return this.root;
    }

    public boolean isLeaf(Object node) {
        return this.getChildCount(node) == 0;
    }

    public void removeTreeModelListener(TreeModelListener l) {
        this.treeModelListeners.remove(l);
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    class Node {
        static final int CATALOG = 0;
        static final int TABLE = 1;
        static final int COLUMN = 2;
        String name;
        int type;
        ArrayList children;

        public Node(String n, int t) {
            this.name = n;
            this.type = t;
            this.children = new ArrayList();
        }

        public String toString() {
            return this.name;
        }
    }
}

