/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.treetable;

import java.io.File;
import java.util.List;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;

public class FileNode
extends DefaultMutableTreeNode {
    private final File file;
    private final boolean isDir;

    public FileNode(File file) {
        super(file);
        this.file = file;
        this.isDir = file.isDirectory();
    }

    public boolean getAllowsChildren() {
        return this.isDir;
    }

    protected List getChildren() {
        if (this.children == null) {
            try {
                String[] files = this.file.list();
                if (files != null) {
                    this.children = new Vector(files.length);
                    String path = this.file.getPath();
                    for (int i = 0; i < files.length; ++i) {
                        File childFile = new File(path, files[i]);
                        this.children.add(new FileNode(childFile));
                    }
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return this.children;
    }

    public File getFile() {
        return this.file;
    }

    public boolean isLeaf() {
        return !this.isDir;
    }

    public String toString() {
        return this.file.getName();
    }
}

