/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf.basic;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.text.View;

public class BasicHyperlinkUI
extends BasicButtonUI {
    private static Rectangle viewRect = new Rectangle();
    private static Rectangle textRect = new Rectangle();
    private static Rectangle iconRect = new Rectangle();
    private static MouseListener handCursorListener = new HandCursor();
    protected int dashedRectGapX;
    protected int dashedRectGapY;
    protected int dashedRectGapWidth;
    protected int dashedRectGapHeight;
    private Color focusColor;

    public static ComponentUI createUI(JComponent c) {
        return new BasicHyperlinkUI();
    }

    protected void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        b.setOpaque(false);
        b.setBorderPainted(false);
        b.setRolloverEnabled(true);
        b.setBorder(BorderFactory.createEmptyBorder());
        this.dashedRectGapX = UIManager.getInt("ButtonUI.dashedRectGapX");
        this.dashedRectGapY = UIManager.getInt("ButtonUI.dashedRectGapY");
        this.dashedRectGapWidth = UIManager.getInt("ButtonUI.dashedRectGapWidth");
        this.dashedRectGapHeight = UIManager.getInt("ButtonUI.dashedRectGapHeight");
        this.focusColor = UIManager.getColor("ButtonUI.focus");
        b.setHorizontalAlignment(10);
    }

    protected void installListeners(AbstractButton b) {
        super.installListeners(b);
        b.addMouseListener(handCursorListener);
    }

    protected void uninstallListeners(AbstractButton b) {
        super.uninstallListeners(b);
        b.removeMouseListener(handCursorListener);
    }

    protected Color getFocusColor() {
        return this.focusColor;
    }

    public void paint(Graphics g, JComponent c) {
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        FontMetrics fm = g.getFontMetrics();
        Insets i = c.getInsets();
        BasicHyperlinkUI.viewRect.x = i.left;
        BasicHyperlinkUI.viewRect.y = i.top;
        BasicHyperlinkUI.viewRect.width = b.getWidth() - (i.right + BasicHyperlinkUI.viewRect.x);
        BasicHyperlinkUI.viewRect.height = b.getHeight() - (i.bottom + BasicHyperlinkUI.viewRect.y);
        BasicHyperlinkUI.textRect.height = 0;
        BasicHyperlinkUI.textRect.width = 0;
        BasicHyperlinkUI.textRect.y = 0;
        BasicHyperlinkUI.textRect.x = 0;
        BasicHyperlinkUI.iconRect.height = 0;
        BasicHyperlinkUI.iconRect.width = 0;
        BasicHyperlinkUI.iconRect.y = 0;
        BasicHyperlinkUI.iconRect.x = 0;
        Font f = c.getFont();
        g.setFont(f);
        String text = SwingUtilities.layoutCompoundLabel(c, fm, b.getText(), b.getIcon(), b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, b.getText() == null ? 0 : b.getIconTextGap());
        this.clearTextShiftOffset();
        if (model.isArmed() && model.isPressed()) {
            this.paintButtonPressed(g, b);
        }
        if (b.getIcon() != null) {
            this.paintIcon(g, c, iconRect);
        }
        if (text != null && !text.equals("")) {
            View v = (View)c.getClientProperty("html");
            if (v != null) {
                this.paintHTMLText(g, b, textRect, text, v);
            } else {
                this.paintText(g, b, textRect, text);
            }
        }
        if (b.isFocusPainted() && b.hasFocus()) {
            this.paintFocus(g, b, viewRect, textRect, iconRect);
        }
    }

    protected void paintHTMLText(Graphics g, AbstractButton b, Rectangle textRect, String text, View v) {
        textRect.x += this.getTextShiftOffset();
        textRect.y += this.getTextShiftOffset();
        v.paint(g, textRect);
        if (b.getModel().isRollover()) {
            this.paintUnderline(g, b, textRect, text);
        }
        textRect.x -= this.getTextShiftOffset();
        textRect.y -= this.getTextShiftOffset();
    }

    protected void paintText(Graphics g, AbstractButton b, Rectangle textRect, String text) {
        super.paintText(g, b, textRect, text);
        if (b.getModel().isRollover()) {
            this.paintUnderline(g, b, textRect, text);
        }
    }

    private void paintUnderline(Graphics g, AbstractButton b, Rectangle rect, String text) {
        FontMetrics fm = g.getFontMetrics();
        int descent = fm.getDescent();
        g.drawLine(rect.x + this.getTextShiftOffset(), rect.y + rect.height - descent + 1 + this.getTextShiftOffset(), rect.x + rect.width + this.getTextShiftOffset(), rect.y + rect.height - descent + 1 + this.getTextShiftOffset());
    }

    protected void paintFocus(Graphics g, AbstractButton b, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
        if (b.getParent() instanceof JToolBar) {
            return;
        }
        int width = b.getWidth();
        int height = b.getHeight();
        g.setColor(this.getFocusColor());
        BasicGraphicsUtils.drawDashedRect(g, this.dashedRectGapX, this.dashedRectGapY, width - this.dashedRectGapWidth, height - this.dashedRectGapHeight);
    }

    protected void paintButtonPressed(Graphics g, AbstractButton b) {
    }

    static class HandCursor
    extends MouseAdapter {
        HandCursor() {
        }

        public void mouseEntered(MouseEvent e) {
            e.getComponent().setCursor(Cursor.getPredefinedCursor(12));
        }

        public void mouseExited(MouseEvent e) {
            e.getComponent().setCursor(null);
        }
    }
}

