/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.irplugin;

import com.jaspersoft.jasperserver.irplugin.IRPlugin;
import com.jaspersoft.jasperserver.irplugin.JServer;
import com.jaspersoft.jasperserver.irplugin.RepositoryReportUnit;
import it.businesslogic.ireport.export.JRTxtExporter;
import it.businesslogic.ireport.export.JRTxtExporterParameter;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.gui.logpane.LogTextArea;
import it.businesslogic.ireport.util.Misc;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JExcelApiExporter;
import net.sf.jasperreports.engine.export.JRCsvExporter;
import net.sf.jasperreports.engine.export.JRCsvExporterParameter;
import net.sf.jasperreports.engine.export.JRGraphics2DExporter;
import net.sf.jasperreports.engine.export.JRHtmlExporter;
import net.sf.jasperreports.engine.export.JRHtmlExporterParameter;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.export.JRPdfExporterParameter;
import net.sf.jasperreports.engine.export.JRRtfExporter;
import net.sf.jasperreports.engine.export.JRTextExporter;
import net.sf.jasperreports.engine.export.JRTextExporterParameter;
import net.sf.jasperreports.engine.export.JRXlsAbstractExporterParameter;
import net.sf.jasperreports.engine.export.JRXlsExporter;
import net.sf.jasperreports.view.JasperViewer;

public class ReportRunner
implements Runnable {
    protected static final String VERSION_SUPPORT_REPORT_LOCALE = "2.0.1";
    private RepositoryReportUnit reportUnit;
    private Map map;
    private JServer server;
    private LogTextArea lta;

    public void run() {
        try {
            this.lta.logOnConsole("<font face=\"SansSerif\"  size=\"3\" color=\"#0000CC\"><b>" + IRPlugin.getFormattedString("compiler.fillReportOnServer", "Filling report on server: {0}", new Object[]{"" + this.getServer().getUrl()}) + "</b> </font><hr>", true);
            Map params = this.getReportParameters();
            JasperPrint print = this.getServer().getWSClient().runReport(this.getReportUnit().getDescriptor(), params);
            MainFrame.getMainInstance();
            this.exportPrint(MainFrame.IREPORT_TMP_DIR, this.getReportUnit().getDescriptor().getName(), print, this.getLta());
        }
        catch (Exception t) {
            StringWriter sw = new StringWriter();
            t.printStackTrace(new PrintWriter(sw));
            sw.flush();
            this.lta.logOnConsole("<font face=\"SansSerif\"  size=\"3\" color=\"#CC0000\">" + t.getMessage() + "</font><hr>", true);
            this.lta.logOnConsole(sw.toString(), false);
        }
    }

    protected Map getReportParameters() throws Exception {
        String locale;
        HashMap<String, String> params = new HashMap<String, String>(this.getMap());
        String serverVersion = this.getServer().getWSClient().getVersion();
        if (VERSION_SUPPORT_REPORT_LOCALE.compareTo(serverVersion) <= 0 && !params.containsKey("REPORT_LOCALE") && (locale = this.getReportLocale()) != null && locale.length() > 0) {
            params.put("REPORT_LOCALE", locale);
        }
        return params;
    }

    protected String getReportLocale() {
        return this.getMainFrame().getProperties().getProperty("reportLocale");
    }

    public RepositoryReportUnit getReportUnit() {
        return this.reportUnit;
    }

    public void setReportUnit(RepositoryReportUnit reportUnit) {
        this.reportUnit = reportUnit;
    }

    public Map getMap() {
        return this.map;
    }

    public void setMap(Map map) {
        this.map = map;
    }

    public JServer getServer() {
        return this.server;
    }

    public void setServer(JServer server) {
        this.server = server;
    }

    public LogTextArea getLta() {
        return this.lta;
    }

    public void setLta(LogTextArea lta) {
        this.lta = lta;
    }

    public void exportPrint(String tmpDir, String fileName, JasperPrint print, LogTextArea lta) {
        String status = "";
        if (!tmpDir.endsWith(File.separator)) {
            tmpDir = tmpDir + File.separator;
        }
        int format = this.getMainFrame().getReportViewer();
        if (print != null) {
            JRPdfExporter exporter = null;
            lta.logOnConsole("<font face=\"SansSerif\"  size=\"3\" color=\"#0000CC\"><b>" + IRPlugin.getString("compiler.reportFilled", "Report filled") + "</b>&nbsp;" + IRPlugin.getFormattedString("compiler.pagesGenerated", "(pages generated: {0,number,integer} )", new Object[]{new Integer(print.getPages().size())}) + "</font><hr>", true);
            status = "exporting report";
            long start = System.currentTimeMillis();
            String viewer_program = "";
            String exportingMessage = "";
            boolean errorExporting = false;
            try {
                if (format == 2) {
                    exporter = new JRPdfExporter();
                    if (this.getMainFrame().getProperties().getProperty("PDF_IS_ENCRYPTED") != null) {
                        exporter.setParameter((JRExporterParameter)JRPdfExporterParameter.IS_ENCRYPTED, (Object)new Boolean(this.getMainFrame().getProperties().getProperty("PDF_IS_ENCRYPTED")));
                    }
                    if (this.getMainFrame().getProperties().getProperty("PDF_IS_128_BIT_KEY") != null) {
                        exporter.setParameter((JRExporterParameter)JRPdfExporterParameter.IS_128_BIT_KEY, (Object)new Boolean(this.getMainFrame().getProperties().getProperty("PDF_IS_128_BIT_KEY")));
                    }
                    if (this.getMainFrame().getProperties().getProperty("PDF_USER_PASSWORD") != null) {
                        exporter.setParameter((JRExporterParameter)JRPdfExporterParameter.USER_PASSWORD, (Object)this.getMainFrame().getProperties().getProperty("PDF_USER_PASSWORD"));
                    }
                    if (this.getMainFrame().getProperties().getProperty("PDF_OWNER_PASSWORD") != null) {
                        exporter.setParameter((JRExporterParameter)JRPdfExporterParameter.OWNER_PASSWORD, (Object)this.getMainFrame().getProperties().getProperty("PDF_OWNER_PASSWORD"));
                    }
                    if (this.getMainFrame().getProperties().getProperty("PDF_PERMISSIONS") != null) {
                        exporter.setParameter((JRExporterParameter)JRPdfExporterParameter.PERMISSIONS, (Object)new Integer(this.getMainFrame().getProperties().getProperty("PDF_PERMISSIONS")));
                    }
                    fileName = Misc.changeFileExtension((String)fileName, (String)"pdf");
                    exportingMessage = IRPlugin.getFormattedString("compiler.exporting.pdf", "Exporting pdf to file (using iText)... {0}", new Object[]{fileName});
                    viewer_program = this.getMainFrame().getProperties().getProperty("ExternalPDFViewer");
                } else if (format == 16) {
                    exporter = new JRCsvExporter();
                    if (this.getMainFrame().getProperties().getProperty("CSV_FIELD_DELIMITER") != null) {
                        exporter.setParameter((JRExporterParameter)JRCsvExporterParameter.FIELD_DELIMITER, (Object)this.getMainFrame().getProperties().getProperty("CSV_FIELD_DELIMITER"));
                    }
                    fileName = Misc.changeFileExtension((String)fileName, (String)"csv");
                    exportingMessage = IRPlugin.getFormattedString("compiler.exporting.cvs", "Exporting CSV to file... {0}", new Object[]{fileName});
                    viewer_program = Misc.nvl((Object)this.getMainFrame().getProperties().getProperty("ExternalCSVViewer"), (String)"");
                } else if (format == 4) {
                    exporter = new JRHtmlExporter();
                    if (this.getMainFrame().getProperties().getProperty("HTML_IMAGES_DIR_NAME") != null) {
                        exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IMAGES_DIR_NAME, (Object)this.getMainFrame().getProperties().getProperty("HTML_IMAGES_DIR_NAME"));
                    }
                    if (this.getMainFrame().getProperties().getProperty("HTML_IS_OUTPUT_IMAGES_TO_DIR") != null) {
                        exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IS_OUTPUT_IMAGES_TO_DIR, (Object)new Boolean(this.getMainFrame().getProperties().getProperty("HTML_IS_OUTPUT_IMAGES_TO_DIR")));
                    }
                    if (this.getMainFrame().getProperties().getProperty("HTML_IMAGES_URI") != null) {
                        exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IMAGES_URI, (Object)this.getMainFrame().getProperties().getProperty("HTML_IMAGES_URI"));
                    }
                    if (this.getMainFrame().getProperties().getProperty("HTML_HTML_HEADER") != null) {
                        exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.HTML_HEADER, (Object)this.getMainFrame().getProperties().getProperty("HTML_HTML_HEADER"));
                    }
                    if (this.getMainFrame().getProperties().getProperty("HTML_BETWEEN_PAGES_HTML") != null) {
                        exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.BETWEEN_PAGES_HTML, (Object)this.getMainFrame().getProperties().getProperty("HTML_BETWEEN_PAGES_HTML"));
                    }
                    if (this.getMainFrame().getProperties().getProperty("HTML_HTML_FOOTER") != null) {
                        exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.HTML_FOOTER, (Object)this.getMainFrame().getProperties().getProperty("HTML_HTML_FOOTER"));
                    }
                    if (this.getMainFrame().getProperties().getProperty("HTML_IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS") != null) {
                        exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS, (Object)new Boolean(this.getMainFrame().getProperties().getProperty("HTML_IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS")));
                    }
                    if (this.getMainFrame().getProperties().getProperty("HTML_IS_WHITE_PAGE_BACKGROUND") != null) {
                        exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IS_WHITE_PAGE_BACKGROUND, (Object)new Boolean(this.getMainFrame().getProperties().getProperty("HTML_IS_WHITE_PAGE_BACKGROUND")));
                    }
                    if (this.getMainFrame().getProperties().getProperty("HTML_IS_USING_IMAGES_TO_ALIGN") != null) {
                        exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IS_USING_IMAGES_TO_ALIGN, (Object)new Boolean(this.getMainFrame().getProperties().getProperty("HTML_IS_USING_IMAGES_TO_ALIGN")));
                    }
                    fileName = Misc.changeFileExtension((String)fileName, (String)"html");
                    exportingMessage = IRPlugin.getFormattedString("compiler.exporting.html", "Exporting HTML to file... {0}", new Object[]{fileName});
                    viewer_program = Misc.nvl((Object)this.getMainFrame().getProperties().getProperty("ExternalHTMLViewer"), (String)"");
                } else if (format == 8) {
                    exporter = new JRXlsExporter();
                    if (this.getMainFrame().getProperties().getProperty("XLS_IS_ONE_PAGE_PER_SHEET") != null) {
                        exporter.setParameter((JRExporterParameter)JRXlsAbstractExporterParameter.IS_ONE_PAGE_PER_SHEET, (Object)new Boolean(this.getMainFrame().getProperties().getProperty("XLS_IS_ONE_PAGE_PER_SHEET")));
                    }
                    if (this.getMainFrame().getProperties().getProperty("XLS_IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS") != null) {
                        exporter.setParameter((JRExporterParameter)JRXlsAbstractExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS, (Object)new Boolean(this.getMainFrame().getProperties().getProperty("XLS_IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS")));
                    }
                    if (this.getMainFrame().getProperties().getProperty("XLS_IS_WHITE_PAGE_BACKGROUND") != null) {
                        exporter.setParameter((JRExporterParameter)JRXlsAbstractExporterParameter.IS_WHITE_PAGE_BACKGROUND, (Object)new Boolean(this.getMainFrame().getProperties().getProperty("XLS_IS_WHITE_PAGE_BACKGROUND")));
                    }
                    if (this.getMainFrame().getProperties().getProperty("XLS_IS_AUTO_DETECT_CELL_TYPE") != null) {
                        exporter.setParameter((JRExporterParameter)JRXlsAbstractExporterParameter.IS_AUTO_DETECT_CELL_TYPE, (Object)new Boolean(this.getMainFrame().getProperties().getProperty("XLS_IS_AUTO_DETECT_CELL_TYPE")));
                    }
                    fileName = Misc.changeFileExtension((String)fileName, (String)"xls");
                    exportingMessage = IRPlugin.getFormattedString("compiler.exporting.xls", "Exporting xls to file (using POI)...  {0}", new Object[]{fileName});
                    viewer_program = Misc.nvl((Object)this.getMainFrame().getProperties().getProperty("ExternalXLSViewer"), (String)"");
                } else if (format == 512) {
                    exporter = new JExcelApiExporter();
                    if (this.getMainFrame().getProperties().getProperty("XLS2_IS_FONT_SIZE_FIX_ENABLED") != null) {
                        exporter.setParameter((JRExporterParameter)JRXlsAbstractExporterParameter.IS_FONT_SIZE_FIX_ENABLED, (Object)new Boolean(this.getMainFrame().getProperties().getProperty("XLS2_IS_FONT_SIZE_FIX_ENABLED")));
                    }
                    fileName = Misc.changeFileExtension((String)fileName, (String)"xls");
                    exportingMessage = IRPlugin.getFormattedString("compiler.exporting.xls2", "Exporting xls to file (using JExcelApi)... {0}", new Object[]{fileName});
                    viewer_program = Misc.nvl((Object)this.getMainFrame().getProperties().getProperty("ExternalXLSViewer"), (String)"");
                } else if (format == 1) {
                    exporter = new JRGraphics2DExporter();
                    exportingMessage = "Exporting to Java2D ";
                    viewer_program = null;
                } else if (format == 32) {
                    exportingMessage = IRPlugin.getString("compiler.exporting.jasper", "Viewing with JasperReports Viewer");
                    exporter = null;
                    viewer_program = null;
                } else if (format == 64) {
                    exporter = new JRTxtExporter();
                    if (this.getMainFrame().getProperties().getProperty("TXT_PAGE_ROWS") != null) {
                        exporter.setParameter((JRExporterParameter)JRTxtExporterParameter.PAGE_ROWS, (Object)this.getMainFrame().getProperties().getProperty("TXT_PAGE_ROWS"));
                    }
                    if (this.getMainFrame().getProperties().getProperty("TXT_PAGE_COLUMNS") != null) {
                        exporter.setParameter((JRExporterParameter)JRTxtExporterParameter.PAGE_COLUMNS, (Object)this.getMainFrame().getProperties().getProperty("TXT_PAGE_COLUMNS"));
                    }
                    if (this.getMainFrame().getProperties().getProperty("TXT_ADD_FORM_FEED") != null) {
                        exporter.setParameter((JRExporterParameter)JRTxtExporterParameter.ADD_FORM_FEED, (Object)new Boolean(this.getMainFrame().getProperties().getProperty("TXT_ADD_FORM_FEED")));
                    }
                    fileName = Misc.changeFileExtension((String)fileName, (String)"txt");
                    exportingMessage = IRPlugin.getFormattedString("compiler.exporting.txt", "Exporting txt (iReport) to file... {0}", new Object[]{fileName});
                    viewer_program = Misc.nvl((Object)this.getMainFrame().getProperties().getProperty("ExternalTXTViewer"), (String)"");
                } else if (format == 128) {
                    exporter = new JRTextExporter();
                    if (this.getMainFrame().getProperties().getProperty("JRTXT_PAGE_WIDTH") != null) {
                        exporter.setParameter((JRExporterParameter)JRTextExporterParameter.PAGE_WIDTH, (Object)new Integer(this.getMainFrame().getProperties().getProperty("JRTXT_PAGE_WIDTH")));
                    }
                    if (this.getMainFrame().getProperties().getProperty("JRTXT_PAGE_HEIGHT") != null) {
                        exporter.setParameter((JRExporterParameter)JRTextExporterParameter.PAGE_HEIGHT, (Object)new Integer(this.getMainFrame().getProperties().getProperty("JRTXT_PAGE_HEIGHT")));
                    }
                    if (this.getMainFrame().getProperties().getProperty("JRTXT_CHARACTER_WIDTH") != null) {
                        exporter.setParameter((JRExporterParameter)JRTextExporterParameter.CHARACTER_WIDTH, (Object)new Integer(this.getMainFrame().getProperties().getProperty("JRTXT_CHARACTER_WIDTH")));
                    }
                    if (this.getMainFrame().getProperties().getProperty("JRTXT_CHARACTER_HEIGHT") != null) {
                        exporter.setParameter((JRExporterParameter)JRTextExporterParameter.CHARACTER_HEIGHT, (Object)new Integer(this.getMainFrame().getProperties().getProperty("JRTXT_CHARACTER_HEIGHT")));
                    }
                    if (this.getMainFrame().getProperties().getProperty("JRTXT_BETWEEN_PAGES_TEXT") != null) {
                        exporter.setParameter((JRExporterParameter)JRTextExporterParameter.BETWEEN_PAGES_TEXT, (Object)this.getMainFrame().getProperties().getProperty("JRTXT_BETWEEN_PAGES_TEXT"));
                    }
                    fileName = Misc.changeFileExtension((String)fileName, (String)"txt");
                    exportingMessage = IRPlugin.getFormattedString("compiler.exporting.txt2", "Exporting txt (jasperReports) to file... {0}", new Object[]{fileName});
                    viewer_program = Misc.nvl((Object)this.getMainFrame().getProperties().getProperty("ExternalTXTViewer"), (String)"");
                } else if (format == 256) {
                    exporter = new JRRtfExporter();
                    fileName = Misc.changeFileExtension((String)fileName, (String)"rtf");
                    exportingMessage = IRPlugin.getFormattedString("compiler.exporting.rtf", "Exporting RTF to file... {0}", new Object[]{fileName});
                    viewer_program = Misc.nvl((Object)this.getMainFrame().getProperties().getProperty("ExternalRTFViewer"), (String)"");
                }
                URL img_url = this.getClass().getResource("/it/businesslogic/ireport/icons/printer_mini.png");
                lta.logOnConsole("<font face=\"SansSerif\"  size=\"3\"><img align=\"right\" src=\"" + img_url + "\"> &nbsp;" + exportingMessage + "</font>", true);
                if (exporter != null) {
                    exporter.setParameter(JRExporterParameter.OUTPUT_FILE_NAME, (Object)new StringBuilder().append(tmpDir).append(fileName).toString());
                    exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)print);
                    exporter.exportReport();
                } else if (format == 32) {
                    JasperViewer jasperViewer = new JasperViewer(print, false);
                    jasperViewer.setTitle("iReport JasperViewer");
                    jasperViewer.setVisible(true);
                }
            }
            catch (Throwable ex2) {
                errorExporting = true;
                lta.logOnConsole(IRPlugin.getString("compiler.exporting.error", "Error exporting print...") + "\n");
                ex2.printStackTrace();
                lta.logOnConsole(new StringBuilder().append("").append(ex2).toString());
            }
            if (!errorExporting) {
                lta.logOnConsole("<font face=\"SansSerif\"  size=\"3\" color=\"#0000CC\"><b>" + IRPlugin.getFormattedString("compiler.exporting.time", "Export running time: {0,number,long} millisecs", new Object[]{new Long(System.currentTimeMillis() - start)}) + "</b></font><hr>", true);
                Runtime rt = Runtime.getRuntime();
                if (viewer_program == null || viewer_program.equals("")) {
                    if (format != 32) {
                        lta.logOnConsole("<font face=\"SansSerif\"  size=\"3\">" + IRPlugin.getString("compiler.exporting.noviewer", "No external viewer specified for this type of print. Set it in the options frame!") + "</font>", true);
                    }
                } else {
                    try {
                        File f = new File(fileName);
                        String execute_string = new StringBuilder().append(viewer_program).append(" ").append(f).append("").toString();
                        lta.logOnConsole("<font face=\"SansSerif\"  size=\"3\">" + IRPlugin.getFormattedString("compiler.exporting.executing", "Executing: {0}", new Object[]{execute_string}) + "</font>", true);
                        rt.exec(execute_string);
                    }
                    catch (Exception ex) {
                        lta.logOnConsole(IRPlugin.getString("compiler.exporting.viewing", "Error viewing report...") + "\n");
                        ex.printStackTrace();
                    }
                }
            } else {
                lta.logOnConsole("<font face=\"SansSerif\"  size=\"3\" color=\"#CC0000\"><b>" + IRPlugin.getString("compiler.exporting.exporterror", "Error exporting the report, try to run the report using the internal viewer.") + "</b></font><hr>", true);
            }
        } else {
            lta.logOnConsole(IRPlugin.getString("compiler.printNotFilled", "Print not filled.") + "\n");
        }
    }

    public MainFrame getMainFrame() {
        return MainFrame.getMainInstance();
    }
}

