/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.mxml;

import flash.util.StringUtils;
import flex2.compiler.CompilationUnit;
import flex2.compiler.Compiler;
import flex2.compiler.Context;
import flex2.compiler.Logger;
import flex2.compiler.Source;
import flex2.compiler.SymbolTable;
import flex2.compiler.as3.Compiler;
import flex2.compiler.as3.SyntaxTreeEvaluator;
import flex2.compiler.as3.binding.ClassInfo;
import flex2.compiler.as3.reflect.NodeMagic;
import flex2.compiler.io.FileUtil;
import flex2.compiler.io.TextFile;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.mxml.Configuration;
import flex2.compiler.mxml.LogAdapter;
import flex2.compiler.mxml.ParseException;
import flex2.compiler.mxml.Parser;
import flex2.compiler.mxml.SourceCodeBuffer;
import flex2.compiler.mxml.Token;
import flex2.compiler.mxml.analyzer.SyntaxAnalyzer;
import flex2.compiler.mxml.dom.AnalyzerAdapter;
import flex2.compiler.mxml.dom.ApplicationNode;
import flex2.compiler.mxml.dom.ArgumentsNode;
import flex2.compiler.mxml.dom.ArrayNode;
import flex2.compiler.mxml.dom.BindingNode;
import flex2.compiler.mxml.dom.BooleanNode;
import flex2.compiler.mxml.dom.CDATANode;
import flex2.compiler.mxml.dom.HTTPServiceNode;
import flex2.compiler.mxml.dom.InlineComponentNode;
import flex2.compiler.mxml.dom.IntNode;
import flex2.compiler.mxml.dom.MetaDataNode;
import flex2.compiler.mxml.dom.MethodNode;
import flex2.compiler.mxml.dom.ModelNode;
import flex2.compiler.mxml.dom.Node;
import flex2.compiler.mxml.dom.NumberNode;
import flex2.compiler.mxml.dom.OperationNode;
import flex2.compiler.mxml.dom.RemoteObjectNode;
import flex2.compiler.mxml.dom.RequestNode;
import flex2.compiler.mxml.dom.Scanner;
import flex2.compiler.mxml.dom.ScannerError;
import flex2.compiler.mxml.dom.ScriptNode;
import flex2.compiler.mxml.dom.StringNode;
import flex2.compiler.mxml.dom.StyleNode;
import flex2.compiler.mxml.dom.SyntaxTreeBuilder;
import flex2.compiler.mxml.dom.UIntNode;
import flex2.compiler.mxml.dom.WebServiceNode;
import flex2.compiler.mxml.dom.XMLListNode;
import flex2.compiler.mxml.dom.XMLNode;
import flex2.compiler.mxml.lang.AttributeHandler;
import flex2.compiler.mxml.lang.ChildNodeHandler;
import flex2.compiler.mxml.lang.FrameworkDefs;
import flex2.compiler.mxml.lang.StandardDefs;
import flex2.compiler.mxml.lang.TextParser;
import flex2.compiler.mxml.reflect.Effect;
import flex2.compiler.mxml.reflect.Event;
import flex2.compiler.mxml.reflect.Property;
import flex2.compiler.mxml.reflect.Style;
import flex2.compiler.mxml.reflect.Type;
import flex2.compiler.mxml.reflect.TypeTable;
import flex2.compiler.mxml.rep.DocumentInfo;
import flex2.compiler.mxml.rep.Script;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.LineNumberMap;
import flex2.compiler.util.MultiName;
import flex2.compiler.util.MultiNameMap;
import flex2.compiler.util.MultiNameSet;
import flex2.compiler.util.NameFormatter;
import flex2.compiler.util.NameMappings;
import flex2.compiler.util.QName;
import flex2.compiler.util.QNameSet;
import flex2.compiler.util.ThreadLocalToolkit;
import flex2.compiler.util.VelocityManager;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import macromedia.asc.embedding.CompilerHandler;
import macromedia.asc.semantics.Emitter;
import macromedia.asc.util.ObjectList;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;

class InterfaceCompiler
implements Compiler {
    private static final String TemplatePath;
    private static final String AttrTypeRequests = "TypeRequests";
    private static final String AttrInlineComponentSyntaxTree = "InlineComponentSyntaxTree";
    private static final String APPLICATION_NODE = "ApplicationNode";
    private Configuration mxmlConfiguration;
    private NameMappings nameMappings;
    private String[] mimeTypes;
    private flex2.compiler.as3.Compiler asc;
    static final /* synthetic */ boolean $assertionsDisabled;

    public InterfaceCompiler(Configuration mxmlConfiguration, final flex2.compiler.as3.Configuration ascConfiguration, NameMappings mappings) {
        this.mxmlConfiguration = mxmlConfiguration;
        this.nameMappings = mappings;
        this.mimeTypes = new String[]{"text/mxml"};
        this.asc = new flex2.compiler.as3.Compiler(new flex2.compiler.as3.Configuration(){

            public boolean debug() {
                return false;
            }

            public boolean profile() {
                return false;
            }

            public boolean strict() {
                return ascConfiguration.strict();
            }

            public int dialect() {
                return ascConfiguration.dialect();
            }

            public boolean adjustOpDebugLine() {
                return ascConfiguration.adjustOpDebugLine();
            }

            public boolean warnings() {
                return false;
            }

            public boolean doc() {
                return false;
            }

            public String getEncoding() {
                return null;
            }

            public boolean metadataExport() {
                return false;
            }

            public boolean warn_array_tostring_changes() {
                return false;
            }

            public boolean warn_assignment_within_conditional() {
                return false;
            }

            public boolean warn_bad_array_cast() {
                return false;
            }

            public boolean warn_bad_bool_assignment() {
                return false;
            }

            public boolean warn_bad_date_cast() {
                return false;
            }

            public boolean warn_bad_es3_type_method() {
                return false;
            }

            public boolean warn_bad_es3_type_prop() {
                return false;
            }

            public boolean warn_bad_nan_comparison() {
                return false;
            }

            public boolean warn_bad_null_assignment() {
                return false;
            }

            public boolean warn_bad_null_comparison() {
                return false;
            }

            public boolean warn_bad_undefined_comparison() {
                return false;
            }

            public boolean warn_boolean_constructor_with_no_args() {
                return false;
            }

            public boolean warn_changes_in_resolve() {
                return false;
            }

            public boolean warn_class_is_sealed() {
                return false;
            }

            public boolean warn_const_not_initialized() {
                return false;
            }

            public boolean warn_constructor_returns_value() {
                return false;
            }

            public boolean warn_deprecated_event_handler_error() {
                return false;
            }

            public boolean warn_deprecated_function_error() {
                return false;
            }

            public boolean warn_deprecated_property_error() {
                return false;
            }

            public boolean warn_duplicate_argument_names() {
                return false;
            }

            public boolean warn_duplicate_variable_def() {
                return false;
            }

            public boolean warn_for_var_in_changes() {
                return false;
            }

            public boolean warn_import_hides_class() {
                return false;
            }

            public boolean warn_instance_of_changes() {
                return false;
            }

            public boolean warn_internal_error() {
                return false;
            }

            public boolean warn_level_not_supported() {
                return false;
            }

            public boolean warn_missing_namespace_decl() {
                return false;
            }

            public boolean warn_negative_uint_literal() {
                return false;
            }

            public boolean warn_no_constructor() {
                return false;
            }

            public boolean warn_no_explicit_super_call_in_constructor() {
                return false;
            }

            public boolean warn_no_type_decl() {
                return false;
            }

            public boolean warn_number_from_string_changes() {
                return false;
            }

            public boolean warn_scoping_change_in_this() {
                return false;
            }

            public boolean warn_slow_text_field_addition() {
                return false;
            }

            public boolean warn_unlikely_function_value() {
                return false;
            }

            public boolean warn_xml_class_has_changed() {
                return false;
            }

            public ObjectList getDefine() {
                return ascConfiguration.getDefine();
            }
        });
    }

    flex2.compiler.as3.Compiler getASCompiler() {
        return this.asc;
    }

    public boolean isSupported(String mimeType) {
        return this.mimeTypes[0].equals(mimeType);
    }

    public String[] getSupportedMimeTypes() {
        return this.mimeTypes;
    }

    public Source preprocess(Source source) {
        String componentName = source.getShortName();
        if (!TextParser.isValidIdentifier(componentName)) {
            InvalidComponentName m = new InvalidComponentName(componentName);
            m.setPath(source.getNameForReporting());
            ThreadLocalToolkit.log(m);
        }
        return source;
    }

    public CompilationUnit parse1(Source source, SymbolTable symbolTable) {
        CompilationUnit unit;
        ApplicationNode app;
        Context context = new Context();
        Object preparsedSyntaxTree = source.getSourceFragment(AttrInlineComponentSyntaxTree);
        if (preparsedSyntaxTree == null) {
            app = this.parseMXML(source);
            if (app == null) {
                return null;
            }
            unit = source.newCompilationUnit(app, context);
            app.analyze(new SyntaxAnalyzer(unit, this.mxmlConfiguration));
            if (ThreadLocalToolkit.errorCount() > 0) {
                return null;
            }
        } else {
            if (!$assertionsDisabled && !(preparsedSyntaxTree instanceof ApplicationNode)) {
                throw new AssertionError((Object)"bogus preparsed root node passed to InterfaceCompiler");
            }
            app = (ApplicationNode)preparsedSyntaxTree;
            unit = source.newCompilationUnit(app, context);
        }
        unit.getContext().setAttribute(APPLICATION_NODE, app);
        DocumentInfo docInfo = this.createDocumentInfo(app, source);
        if (ThreadLocalToolkit.errorCount() > 0) {
            return null;
        }
        unit.getContext().setAttribute("DocumentInfo", docInfo);
        unit.topLevelDefinitions.add(new QName(docInfo.getPackageName(), docInfo.getClassName()));
        this.transferDependencies(docInfo, unit.inheritance, unit.inheritanceHistory);
        return unit;
    }

    public void parse2(CompilationUnit unit, SymbolTable symbolTable) {
        DocumentInfo docInfo = (DocumentInfo)unit.getContext().getAttribute("DocumentInfo");
        Source source = unit.getSource();
        ClassInfo baseClassInfo = InterfaceCompiler.getClassInfo(source, symbolTable, docInfo.getQualifiedSuperClassName());
        if (baseClassInfo == null && docInfo.getQualifiedSuperClassName() != null) {
            String qualifiedClassName = NameFormatter.toDot(docInfo.getPackageName(), docInfo.getClassName());
            ThreadLocalToolkit.log((CompilerMessage)new BaseClassNotFound(qualifiedClassName, docInfo.getQualifiedSuperClassName()), source);
            return;
        }
        InterfaceAnalyzer analyzer = new InterfaceAnalyzer(unit, docInfo, baseClassInfo);
        ApplicationNode app = (ApplicationNode)unit.getContext().getAttribute(APPLICATION_NODE);
        app.analyze(analyzer);
        if (ThreadLocalToolkit.errorCount() > 0) {
            return;
        }
        LineNumberMap map = new LineNumberMap(source.getName());
        VirtualFile generated = this.generateSkeleton(docInfo, analyzer.bogusImports, map, source);
        if (generated == null) {
            return;
        }
        map.setNewName(generated.getName());
        CompilationUnit interfaceUnit = this.compileInterface(generated, source, docInfo, map, symbolTable);
        if (interfaceUnit == null) {
            return;
        }
        unit.getSource().addFileIncludes(interfaceUnit.getSource());
        unit.getContext().setAttribute("LineNumberMap", map);
        unit.getContext().setAttribute("DelegateUnit", interfaceUnit);
        Source.transferMetaData(interfaceUnit, unit);
        Source.transferInheritance(unit, interfaceUnit);
        Logger original = ThreadLocalToolkit.getLogger();
        LogAdapter adapter = new LogAdapter(original, map);
        adapter.addLineNumberMaps(unit.getSource().getSourceFragmentLineMaps());
        ThreadLocalToolkit.setLogger(adapter);
        this.asc.parse2(interfaceUnit, symbolTable);
        ThreadLocalToolkit.setLogger(original);
    }

    public void analyze1(CompilationUnit unit, SymbolTable symbolTable) {
        CompilationUnit interfaceUnit = (CompilationUnit)unit.getContext().getAttribute("DelegateUnit");
        Logger original = ThreadLocalToolkit.getLogger();
        LineNumberMap map = (LineNumberMap)unit.getContext().getAttribute("LineNumberMap");
        LogAdapter adapter = new LogAdapter(original, map);
        adapter.addLineNumberMaps(unit.getSource().getSourceFragmentLineMaps());
        ThreadLocalToolkit.setLogger(adapter);
        this.asc.analyze1(interfaceUnit, symbolTable);
        ThreadLocalToolkit.setLogger(original);
        Source.transferTypeInfo(interfaceUnit, unit);
        Source.transferNamespaces(interfaceUnit, unit);
    }

    public void analyze2(CompilationUnit unit, SymbolTable symbolTable) {
        CompilationUnit interfaceUnit = (CompilationUnit)unit.getContext().getAttribute("DelegateUnit");
        Source.transferDependencies(unit, interfaceUnit);
        Logger original = ThreadLocalToolkit.getLogger();
        LineNumberMap map = (LineNumberMap)unit.getContext().getAttribute("LineNumberMap");
        LogAdapter adapter = new LogAdapter(original, map);
        adapter.addLineNumberMaps(unit.getSource().getSourceFragmentLineMaps());
        ThreadLocalToolkit.setLogger(adapter);
        this.asc.analyze2(interfaceUnit, symbolTable);
        ThreadLocalToolkit.setLogger(original);
        Source.transferDependencies(interfaceUnit, unit);
    }

    public void analyze3(CompilationUnit unit, SymbolTable symbolTable) {
        CompilationUnit interfaceUnit = (CompilationUnit)unit.getContext().getAttribute("DelegateUnit");
        QNameSet importDefinitionStatements = new QNameSet((Collection)interfaceUnit.importDefinitionStatements);
        Source.transferDependencies(unit, interfaceUnit);
        interfaceUnit.importDefinitionStatements.addAll(importDefinitionStatements);
        Logger original = ThreadLocalToolkit.getLogger();
        LineNumberMap map = (LineNumberMap)unit.getContext().getAttribute("LineNumberMap");
        LogAdapter adapter = new LogAdapter(original, map);
        adapter.addLineNumberMaps(unit.getSource().getSourceFragmentLineMaps());
        ThreadLocalToolkit.setLogger(adapter);
        this.asc.analyze3(interfaceUnit, symbolTable);
        ThreadLocalToolkit.setLogger(original);
    }

    public void analyze4(CompilationUnit unit, SymbolTable symbolTable) {
        CompilationUnit interfaceUnit = (CompilationUnit)unit.getContext().getAttribute("DelegateUnit");
        Logger original = ThreadLocalToolkit.getLogger();
        LineNumberMap map = (LineNumberMap)unit.getContext().getAttribute("LineNumberMap");
        LogAdapter adapter = new LogAdapter(original, map);
        adapter.addLineNumberMaps(unit.getSource().getSourceFragmentLineMaps());
        ThreadLocalToolkit.setLogger(adapter);
        this.asc.analyze4(interfaceUnit, symbolTable);
        ThreadLocalToolkit.setLogger(original);
        Source.transferDependencies(interfaceUnit, unit);
        Source.transferLoaderClassBase(interfaceUnit, unit);
        Source.transferGeneratedSources(interfaceUnit, unit);
        Source.transferClassTable(interfaceUnit, unit);
        Source.transferStyles(interfaceUnit, unit);
    }

    public void generate(CompilationUnit unit, SymbolTable symbolTable) {
    }

    public void postprocess(CompilationUnit unit, SymbolTable symbolTable) {
        TypeTable typeTable = (TypeTable)symbolTable.getContext().getAttribute(flex2.compiler.mxml.Compiler.TYPE_TABLE);
        if (typeTable == null) {
            typeTable = new TypeTable(symbolTable, this.nameMappings);
            symbolTable.getContext().setAttribute(flex2.compiler.mxml.Compiler.TYPE_TABLE, typeTable);
        }
        DocumentInfo info = (DocumentInfo)unit.getContext().getAttribute("DocumentInfo");
        HashSet<ApplicationNode> checkNodes = (HashSet<ApplicationNode>)unit.getContext().getAttribute("CheckNodes");
        HashSet allTypeRequests = (HashSet)unit.getContext().getAttribute(AttrTypeRequests);
        if (checkNodes == null) {
            checkNodes = new HashSet<ApplicationNode>();
            checkNodes.add(info.getRootNode());
            allTypeRequests = new HashSet();
            unit.getContext().setAttribute(AttrTypeRequests, allTypeRequests);
        }
        if (!checkNodes.isEmpty()) {
            HashSet newCheckNodes = new HashSet();
            HashSet newTypeRequests = new HashSet();
            DependencyAnalyzer analyzer = new DependencyAnalyzer(unit, typeTable, info, newCheckNodes, newTypeRequests, allTypeRequests);
            Iterator i = checkNodes.iterator();
            while (i.hasNext()) {
                ((Node)i.next()).analyze(analyzer);
            }
            unit.getContext().setAttribute("CheckNodes", newCheckNodes);
            if (!newTypeRequests.isEmpty()) {
                allTypeRequests.addAll(newTypeRequests);
                unit.expressions.addAll(newTypeRequests);
            }
        }
    }

    private void transferDependencies(DocumentInfo docInfo, MultiNameSet target, MultiNameMap history) {
        target.add(NameFormatter.toMultiName(docInfo.getQualifiedSuperClassName()));
        Iterator iterator = docInfo.getInterfaceNames().iterator();
        while (iterator.hasNext()) {
            DocumentInfo.NameInfo nameInfo = (DocumentInfo.NameInfo)iterator.next();
            target.add(NameFormatter.toMultiName(nameInfo.getName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ApplicationNode parseMXML(Source source) {
        BufferedInputStream in;
        ApplicationNode app;
        block22: {
            app = null;
            in = null;
            in = new BufferedInputStream(source.getInputStream());
            Scanner s = new Scanner(in);
            Parser p = new Parser(s);
            SyntaxTreeBuilder v = new SyntaxTreeBuilder();
            p.setVisitor(v);
            app = (ApplicationNode)p.parseApplication();
            if (this.checkMxmlNamespace(source, app)) break block22;
            app = null;
        }
        Object var11_16 = null;
        if (in == null) return app;
        try {
            ((InputStream)in).close();
            return app;
        }
        catch (IOException ex2) {}
        return app;
        {
            catch (ParseException ex) {
                Token token = ex.currentToken.next;
                String msg = ex.getMessage();
                int wasExpecting = msg.indexOf(System.getProperty("line.separator") + "Was expecting");
                if (wasExpecting > 0) {
                    msg = msg.substring(0, wasExpecting);
                    Pattern msgPatt = Pattern.compile("Encountered \"(.*)\" at line.*");
                    Matcher m = msgPatt.matcher(msg);
                    if (m.matches()) {
                        msg = new InvalidText(m.group(1)).getLocalizedMessage();
                    }
                }
                ThreadLocalToolkit.logError(source.getNameForReporting(), token.beginLine, token.beginColumn, msg);
                app = null;
                Object var11_17 = null;
                if (in == null) return app;
                try {
                    ((InputStream)in).close();
                    return app;
                }
                catch (IOException ex2) {}
                return app;
            }
            catch (Exception ex) {
                String msg = ex.getMessage();
                if (msg == null) {
                    StringWriter stwriter = new StringWriter();
                    PrintWriter pw = new PrintWriter(stwriter);
                    ex.printStackTrace(pw);
                    msg = stwriter.toString();
                }
                ThreadLocalToolkit.logError(source.getNameForReporting(), msg);
                app = null;
                Object var11_18 = null;
                if (in == null) return app;
                try {
                    ((InputStream)in).close();
                    return app;
                }
                catch (IOException ex2) {}
                return app;
            }
            catch (ScannerError err) {
                String msg = err.getReason();
                if (msg.equals(Scanner.MarkupNotRecognizedInContent)) {
                    ThreadLocalToolkit.log((CompilerMessage)new InvalidCharacterOrMarkup(), source);
                } else if (msg.equals(Scanner.ReservedPITarget)) {
                    ThreadLocalToolkit.log((CompilerMessage)new WhitespaceBeforePI(), source);
                } else if (msg.equals(Scanner.MarkupNotRecognizedInMisc)) {
                    ThreadLocalToolkit.log((CompilerMessage)new InvalidMarkupAfterRootElement(), source);
                } else {
                    Pattern msgPatt = Pattern.compile("The element type \"(.*)\" must be terminated by the matching end-tag \"(.*)\".");
                    Matcher m = msgPatt.matcher(msg);
                    if (m.matches()) {
                        msg = new MissingEndTag(m.group(1), m.group(2)).getLocalizedMessage();
                    }
                    ThreadLocalToolkit.logError(source.getNameForReporting(), err.getLineNumber(), err.getColumnNumber(), msg);
                }
                app = null;
                Object var11_19 = null;
                if (in == null) return app;
                try {
                    ((InputStream)in).close();
                    return app;
                }
                catch (IOException ex2) {}
                return app;
            }
        }
        catch (Throwable throwable) {
            Object var11_20 = null;
            if (in == null) throw throwable;
            try {
                ((InputStream)in).close();
                throw throwable;
            }
            catch (IOException ex2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private boolean checkMxmlNamespace(Source source, Node node) {
        if (node.getNamespace().equals("http://www.macromedia.com/2003/mxml") || node.getNamespace().equals("http://www.macromedia.com/2005/mxml")) {
            ThreadLocalToolkit.log((CompilerMessage)new WrongMXMLNamespace(node.getNamespace(), "http://www.adobe.com/2006/mxml"), source);
            return false;
        }
        return true;
    }

    private DocumentInfo createDocumentInfo(ApplicationNode app, Source source) {
        DocumentInfo info = new DocumentInfo(source.getNameForReporting());
        info.setRootNode(app, app.beginLine);
        info.setClassName(source.getShortName());
        info.setPackageName(source.getRelativePath().replace('/', '.'));
        String superClassName = this.nameMappings.resolveClassName(app.getNamespace(), app.getLocalPart());
        if (superClassName == null) {
            ThreadLocalToolkit.log((CompilerMessage)new AnalyzerAdapter.CouldNotResolveToComponent(app.image), source, app.beginLine);
            return null;
        }
        info.setQualifiedSuperClassName(NameFormatter.toDot(superClassName), app.beginLine);
        String interfaceNames = (String)app.getAttribute("implements");
        if (interfaceNames != null) {
            StringTokenizer t = new StringTokenizer(interfaceNames, ",");
            while (t.hasMoreTokens()) {
                info.addInterfaceName(t.nextToken().trim(), app.getLineNumber("implements"));
            }
        }
        info.addImportNames(StandardDefs.implicitImports, app.beginLine);
        if (this.mxmlConfiguration.getCompilingForAIR()) {
            info.addImportNames(StandardDefs.airOnlyImplicitImports, app.beginLine);
        }
        info.addImportNames(StandardDefs.standardMxmlImports, app.beginLine);
        return info;
    }

    private static ClassInfo getClassInfo(Source source, SymbolTable symbolTable, String className) {
        macromedia.asc.util.Context tempContext = new macromedia.asc.util.Context(symbolTable.perCompileData);
        tempContext.setScriptName(source.getName());
        tempContext.setPath(source.getParent());
        tempContext.setEmitter((Emitter)symbolTable.emitter);
        tempContext.setHandler((CompilerHandler)new Compiler.CompilerHandler());
        symbolTable.perCompileData.handler = tempContext.getHandler();
        return symbolTable.getTypeAnalyzer().analyzeClass(tempContext, new MultiName(NameFormatter.toColon(className)));
    }

    private VirtualFile generateSkeleton(DocumentInfo info, Set bogusImports, LineNumberMap map, Source source) {
        String path = source.getName();
        Template template = VelocityManager.getTemplate(TemplatePath);
        if (template != null) {
            try {
                Object importName;
                VelocityContext velocityContext = VelocityManager.getCodeGenContext();
                SourceCodeBuffer out = new SourceCodeBuffer((int)source.size());
                LinkedHashSet<SourceCode> scriptSet = new LinkedHashSet<SourceCode>();
                Iterator iter = info.getScripts().iterator();
                while (iter.hasNext()) {
                    Script script = (Script)iter.next();
                    if (!script.isEmbedded()) {
                        scriptSet.add(new SourceCode(script.getText(), script.getXmlLineNumber(), out, map));
                        continue;
                    }
                    String n = source.getName().replace('\\', '/') + ":" + script.getXmlLineNumber() + "," + script.getEndXmlLineNumber();
                    TextFile f = new TextFile(script.getText(), n, source.getParent(), "text/as", source.getLastModified());
                    LineNumberMap m = new LineNumberMap(source.getNameForReporting(), n);
                    m.put(script.getXmlLineNumber(), 1, script.getEndXmlLineNumber() - script.getXmlLineNumber());
                    m.put(script.getEndXmlLineNumber(), script.getEndXmlLineNumber() - script.getXmlLineNumber() + 1, 1);
                    source.addSourceFragment(n, f, m);
                    scriptSet.add(new SourceCode("include \"" + n + "\";", script.getXmlLineNumber(), out, map));
                }
                LinkedHashSet<SourceCode> metadataSet = new LinkedHashSet<SourceCode>();
                Iterator iter2 = info.getMetadata().iterator();
                while (iter2.hasNext()) {
                    Script script = (Script)iter2.next();
                    metadataSet.add(new SourceCode(script.getText(), script.getXmlLineNumber(), out, map));
                }
                LinkedHashMap<String, SourceCode> varDeclMap = new LinkedHashMap<String, SourceCode>();
                Iterator iter3 = info.getVarDecls().values().iterator();
                while (iter3.hasNext()) {
                    DocumentInfo.VarDecl varDecl = (DocumentInfo.VarDecl)iter3.next();
                    varDeclMap.put(varDecl.name, new SourceCode(varDecl.className, varDecl.line, out, map));
                }
                int superClassLineNumber = 1;
                LinkedHashSet<SourceCode> importNameSet = new LinkedHashSet<SourceCode>();
                Iterator i = info.getImportNames().iterator();
                while (i.hasNext()) {
                    importName = (DocumentInfo.NameInfo)i.next();
                    importNameSet.add(new SourceCode(((DocumentInfo.NameInfo)importName).getName(), ((DocumentInfo.NameInfo)importName).getLine(), out, map));
                    if (!((DocumentInfo.NameInfo)importName).getName().equals(info.getQualifiedSuperClassName())) continue;
                    superClassLineNumber = ((DocumentInfo.NameInfo)importName).getLine();
                }
                i = bogusImports.iterator();
                while (i.hasNext()) {
                    importName = (String)i.next();
                    importNameSet.add(new SourceCode((String)importName, 1, out, map));
                }
                LinkedHashSet<SourceCode> interfaceNameSet = new LinkedHashSet<SourceCode>();
                Iterator i2 = info.getInterfaceNames().iterator();
                while (i2.hasNext()) {
                    DocumentInfo.NameInfo interfaceName = (DocumentInfo.NameInfo)i2.next();
                    interfaceNameSet.add(new SourceCode(interfaceName.getName(), interfaceName.getLine(), out, map));
                }
                velocityContext.put("imports", importNameSet);
                velocityContext.put("variables", varDeclMap.entrySet());
                velocityContext.put("scripts", scriptSet);
                velocityContext.put("classMetaData", metadataSet);
                velocityContext.put("bindingManagementVariables", (Object)FrameworkDefs.bindingManagementVars);
                velocityContext.put("superClassName", (Object)new SourceCode(info.getQualifiedSuperClassName(), superClassLineNumber, out, map));
                velocityContext.put("interfaceNames", interfaceNameSet);
                velocityContext.put("className", (Object)info.getClassName());
                velocityContext.put("packageName", (Object)info.getPackageName());
                template.merge((org.apache.velocity.context.Context)velocityContext, (Writer)out);
                String generated = out.toString().replaceAll("\r\n", "\n");
                String filename = this.writeGenerated(info, generated);
                return new TextFile(generated, filename, source.getParent(), "text/as", source.getLastModified());
            }
            catch (ResourceNotFoundException ex) {
                ThreadLocalToolkit.logError(path, FileUtil.getExceptionMessage((Exception)((Object)ex)));
            }
            catch (ParseErrorException ex) {
                ThreadLocalToolkit.logError(path, FileUtil.getExceptionMessage((Exception)((Object)ex)));
            }
            catch (MethodInvocationException ex) {
                ThreadLocalToolkit.logError(path, FileUtil.getExceptionMessage((Exception)((Object)ex)));
            }
            catch (Exception ex) {
                ThreadLocalToolkit.logError(path, FileUtil.getExceptionMessage(ex));
            }
        }
        return null;
    }

    private String writeGenerated(DocumentInfo info, String generated) throws IOException {
        String filename = flex2.compiler.mxml.Compiler.getGeneratedName(this.mxmlConfiguration, info.getPackageName(), info.getClassName(), "-interface.as");
        if (this.mxmlConfiguration.keepGeneratedActionScript()) {
            new File(filename).getParentFile().mkdirs();
            FileUtil.writeFile(filename, generated);
        }
        return filename;
    }

    private CompilationUnit compileInterface(VirtualFile generated, Source origSource, DocumentInfo info, LineNumberMap map, SymbolTable symbolTable) {
        List md;
        Source newSource = new Source(generated, origSource);
        Logger original = ThreadLocalToolkit.getLogger();
        LogAdapter adapter = new LogAdapter(original, map);
        adapter.addLineNumberMaps(origSource.getSourceFragmentLineMaps());
        ThreadLocalToolkit.setLogger(adapter);
        CompilationUnit interfaceUnit = this.asc.parse1(newSource, symbolTable);
        SyntaxTreeEvaluator.stripRedeclaredManagementVars(interfaceUnit, info.getQName().toString(), symbolTable);
        if (interfaceUnit != null && info != null && (md = info.getMetadata()).size() > 0) {
            int[] beginLines = new int[md.size()];
            int[] endLines = new int[md.size()];
            int size = md.size();
            for (int i = 0; i < size; ++i) {
                Script script = (Script)md.get(i);
                beginLines[i] = script.getXmlLineNumber();
                endLines[i] = script.getEndXmlLineNumber();
            }
            NodeMagic.metaDataOnly(interfaceUnit, map, beginLines, endLines);
        }
        if (interfaceUnit != null) {
            SyntaxTreeEvaluator.ensureMetaDataHasDefinition(interfaceUnit);
        }
        ThreadLocalToolkit.setLogger(original);
        return interfaceUnit;
    }

    static {
        $assertionsDisabled = !InterfaceCompiler.class.desiredAssertionStatus();
        TemplatePath = InterfaceCompiler.class.getPackage().getName().replace('.', '/') + "/gen/InterfaceDef.vm";
    }

    public static class InvalidMarkupAfterRootElement
    extends CompilerMessage.CompilerError {
    }

    public static class MissingEndTag
    extends CompilerMessage.CompilerError {
        public final String tag;
        public final String endTag;

        public MissingEndTag(String tag, String endTag) {
            this.tag = tag;
            this.endTag = endTag;
        }
    }

    public static class InvalidText
    extends CompilerMessage.CompilerError {
        public final String text;

        public InvalidText(String text) {
            this.text = text;
        }
    }

    public static class InvalidComponentName
    extends CompilerMessage.CompilerError {
        public String name;

        public InvalidComponentName(String name) {
            this.name = name;
        }
    }

    public static class BaseClassNotFound
    extends CompilerMessage.CompilerError {
        public String className;
        public String baseClassName;

        public BaseClassNotFound(String className, String baseClassName) {
            this.className = className;
            this.baseClassName = baseClassName;
        }
    }

    public static class InlineComponentInternalError
    extends CompilerMessage.CompilerError {
    }

    public static class ClassNameSpecifiedMoreThanOnce
    extends CompilerMessage.CompilerError {
    }

    public static class ClassNameInvalidActionScriptIdentifier
    extends CompilerMessage.CompilerError {
    }

    public static class IdentifierMatchesClassName
    extends CompilerMessage.CompilerError {
        public String name;

        public IdentifierMatchesClassName(String name) {
            this.name = name;
        }
    }

    public static class IdentifierUsedMoreThanOnce
    extends CompilerMessage.CompilerError {
        public final String id;

        public IdentifierUsedMoreThanOnce(String id) {
            this.id = id;
        }
    }

    public static class InvalidIdentifier
    extends CompilerMessage.CompilerError {
        public final String id;

        public InvalidIdentifier(String id) {
            this.id = id;
        }
    }

    public static class WrongMXMLNamespace
    extends CompilerMessage.CompilerError {
        public final String namespace1;
        public final String namespace2;

        public WrongMXMLNamespace(String namespace1, String namespace2) {
            this.namespace1 = namespace1;
            this.namespace2 = namespace2;
        }
    }

    public static class WhitespaceBeforePI
    extends CompilerMessage.CompilerError {
    }

    public static class InvalidCharacterOrMarkup
    extends CompilerMessage.CompilerError {
    }

    private class SourceCode {
        private String text;
        private int beginLine;
        private int newBeginLine;
        private int lineCount;
        private SourceCodeBuffer out;
        private LineNumberMap map;

        private SourceCode(String text, int beginLine, SourceCodeBuffer out, LineNumberMap map) {
            this.text = text;
            this.beginLine = beginLine;
            this.out = out;
            this.map = map;
            this.newBeginLine = 0;
            this.lineCount = StringUtils.countLines((String)text);
        }

        public String toString() {
            if (this.newBeginLine != 0) {
                throw new IllegalStateException("InterfaceGenerator: toString() was called more than once...");
            }
            this.newBeginLine = this.out.getLineNumber();
            this.map.put(this.beginLine, this.newBeginLine, this.lineCount + 1);
            return this.text;
        }
    }

    private class DependencyAnalyzer
    extends AnalyzerAdapter {
        private final TypeTable typeTable;
        private final DocumentInfo info;
        private final Set checkNodes;
        private final Set newTypeRequests;
        private final Set allTypeRequests;
        private AttributeDependencyScanner attributeDependencyScanner;
        private ChildNodeDependencyScanner childNodeDependencyScanner;
        private ClassInitializerTextParser classInitializerTextParser;

        private DependencyAnalyzer(CompilationUnit unit, TypeTable typeTable, DocumentInfo info, Set checkNodes, Set newTypeRequests, Set allTypeRequests) {
            super(unit, null);
            this.typeTable = typeTable;
            this.info = info;
            this.checkNodes = checkNodes;
            this.newTypeRequests = newTypeRequests;
            this.allTypeRequests = allTypeRequests;
            this.attributeDependencyScanner = new AttributeDependencyScanner();
            this.childNodeDependencyScanner = new ChildNodeDependencyScanner(typeTable);
            this.classInitializerTextParser = new ClassInitializerTextParser();
        }

        public void analyze(Node node) {
            this.registerDependencies(node);
        }

        public void analyze(CDATANode node) {
        }

        public void analyze(StyleNode node) {
        }

        public void analyze(ScriptNode node) {
        }

        public void analyze(MetaDataNode node) {
        }

        public void analyze(ModelNode node) {
            this.requestType(StandardDefs.CLASS_OBJECTPROXY, node);
        }

        public void analyze(XMLNode node) {
            this.requestType(StandardDefs.CLASS_XMLUTIL, node);
            this.requestType(StandardDefs.getXmlBackingClassName(node.isE4X()), node);
        }

        public void analyze(XMLListNode node) {
            this.requestType("XMLList", node);
        }

        public void analyze(BindingNode node) {
        }

        public void analyze(StringNode node) {
        }

        public void analyze(NumberNode node) {
        }

        public void analyze(IntNode node) {
        }

        public void analyze(UIntNode node) {
        }

        public void analyze(BooleanNode node) {
        }

        public void analyze(WebServiceNode node) {
            this.registerDependencies(node);
        }

        public void analyze(HTTPServiceNode node) {
            this.registerDependencies(node);
        }

        public void analyze(RemoteObjectNode node) {
            this.registerDependencies(node);
        }

        public void analyze(OperationNode node) {
            this.registerDependencies(node, StandardDefs.getConvertedTagName(node));
        }

        public void analyze(RequestNode node) {
        }

        public void analyze(MethodNode node) {
            this.registerDependencies(node, StandardDefs.getConvertedTagName(node));
        }

        public void analyze(ArgumentsNode node) {
        }

        public void analyze(InlineComponentNode node) {
            QName classQName = node.getClassQName();
            if (classQName == null) {
                this.log(node, (CompilerMessage)new InlineComponentInternalError());
            } else {
                this.newTypeRequests.add(NameFormatter.toMultiName(StandardDefs.CLASS_CLASSFACTORY));
                this.newTypeRequests.add(NameFormatter.toMultiName(classQName));
                this.info.addImportName(NameFormatter.toDot(StandardDefs.CLASS_CLASSFACTORY), node.beginLine);
                this.info.addImportName(NameFormatter.toDot(classQName), node.beginLine);
            }
        }

        private void registerDependencies(Node node) {
            this.registerDependencies(node, node.getLocalPart());
        }

        private void registerDependencies(Node node, String localPart) {
            String className = InterfaceCompiler.this.nameMappings.resolveClassName(node.getNamespace(), localPart);
            if (className == null) {
                ThreadLocalToolkit.log((CompilerMessage)new AnalyzerAdapter.CouldNotResolveToComponent(node.image), this.unit.getSource(), node.beginLine);
                return;
            }
            Type type = this.requestType(className, node);
            if (type != null) {
                Iterator iter = node.getAttributeNames();
                while (iter.hasNext() && ThreadLocalToolkit.errorCount() == 0) {
                    this.attributeDependencyScanner.invoke(node, type, (QName)iter.next());
                }
                this.childNodeDependencyScanner.scanChildNodes(node, type);
            }
        }

        private Type requestType(String className, Node node) {
            this.info.addImportName(NameFormatter.toDot(className), node.beginLine);
            Type type = this.typeTable.getType(className);
            if (type == null) {
                MultiName multiName = NameFormatter.toMultiName(className);
                if (this.allTypeRequests.contains(multiName)) {
                    ThreadLocalToolkit.log((CompilerMessage)new AnalyzerAdapter.CouldNotResolveToComponent(node.image), this.unit.getSource(), node.beginLine);
                } else {
                    this.checkNodes.add(node);
                    this.newTypeRequests.add(multiName);
                }
            }
            return type;
        }

        protected void requestEventType(Event event) {
            if (event.getType() == null) {
                this.newTypeRequests.add(NameFormatter.toMultiName(event.getTypeName()));
            }
        }

        protected class ClassInitializerTextParser
        extends TextParser {
            ClassInitializerTextParser() {
                super(DependencyAnalyzer.this.typeTable);
            }

            public void parse(String text, Type type) {
                super.parse(text, type, null, 0);
            }

            public String contextRoot(String text) {
                return null;
            }

            public Object embed(String text, Type type) {
                if (StandardDefs.isIFactory(type)) {
                    DependencyAnalyzer.this.newTypeRequests.add(NameFormatter.toMultiName(StandardDefs.CLASS_CLASSFACTORY));
                }
                return null;
            }

            public Object resource(String text, Type type) {
                return null;
            }

            public Object bindingExpression(String converted) {
                return null;
            }

            public Object percentage(String pct) {
                return null;
            }

            public Object array(Collection entries, Type arrayElementType) {
                return null;
            }

            public Object functionText(String text) {
                return null;
            }

            public Object className(String name, Type type) {
                if (StandardDefs.isIFactory(type)) {
                    DependencyAnalyzer.this.newTypeRequests.add(NameFormatter.toMultiName(StandardDefs.CLASS_CLASSFACTORY));
                }
                DependencyAnalyzer.this.newTypeRequests.add(NameFormatter.toMultiName(name));
                return null;
            }

            public void error(int err, String text, Type type, Type arrayElementType) {
            }
        }

        protected class ChildNodeDependencyScanner
        extends ChildNodeHandler {
            protected ChildNodeDependencyScanner(TypeTable typeTable) {
                super(typeTable);
            }

            private void scanGrandchildren() {
                Iterator iter = this.child.getChildIterator();
                while (iter.hasNext()) {
                    ((Node)iter.next()).analyze(DependencyAnalyzer.this);
                }
            }

            private void scanChild() {
                this.child.analyze(DependencyAnalyzer.this);
            }

            protected void event(Event event) {
                DependencyAnalyzer.this.requestEventType(event);
                this.scanGrandchildren();
            }

            protected void property(Property property) {
                CDATANode cdata;
                Type type = property.getType();
                if ((type.equals(type.getTypeTable().classType) || StandardDefs.isInstanceGenerator(type)) && (cdata = DependencyAnalyzer.this.getTextContent(this.child.getChildren(), true)) != null) {
                    DependencyAnalyzer.this.classInitializerTextParser.parse(cdata.image, type);
                }
                this.scanGrandchildren();
            }

            protected void effect(Effect effect) {
                this.scanGrandchildren();
            }

            protected void style(Style style) {
                this.scanGrandchildren();
            }

            protected void dynamicProperty(String name) {
                if (this.parent instanceof ApplicationNode) {
                    this.scanChild();
                } else {
                    this.scanGrandchildren();
                }
            }

            protected void defaultPropertyElement(boolean locError) {
                this.scanChild();
            }

            protected void nestedDeclaration() {
                this.scanChild();
            }

            protected void textContent() {
            }

            protected void languageNode() {
                this.scanChild();
            }
        }

        protected class AttributeDependencyScanner
        extends AttributeHandler {
            protected AttributeDependencyScanner() {
            }

            protected boolean isSpecial(String namespace, String localPart) {
                return false;
            }

            protected void special(String namespace, String localPart) {
            }

            protected void event(Event event) {
                DependencyAnalyzer.this.requestEventType(event);
            }

            protected void property(Property property) {
                Type type = property.getType();
                if (type.equals(type.getTypeTable().classType) || StandardDefs.isInstanceGenerator(type)) {
                    DependencyAnalyzer.this.classInitializerTextParser.parse(this.text, type);
                }
            }

            protected void effect(Effect effect) {
            }

            protected void style(Style style) {
            }

            protected void dynamicProperty(String name) {
            }

            protected void unknownNamespace(String namespace) {
            }

            protected void unknown(String name) {
            }
        }
    }

    private class InterfaceAnalyzer
    extends AnalyzerAdapter {
        private DocumentInfo docInfo;
        private ClassInfo baseClassInfo;
        private int repeaterNum;
        private int inlineComponentCount;
        private Set inlineComponentClassNames;
        private Set bogusImports;

        private InterfaceAnalyzer(CompilationUnit unit, DocumentInfo docInfo, ClassInfo baseClassInfo) {
            super(unit, null);
            this.repeaterNum = 0;
            this.inlineComponentCount = 0;
            this.inlineComponentClassNames = new HashSet();
            this.bogusImports = new HashSet();
            this.docInfo = docInfo;
            this.baseClassInfo = baseClassInfo;
        }

        public void analyze(Node node) {
            boolean inRepeater = false;
            String className = InterfaceCompiler.this.nameMappings.resolveClassName(node.getNamespace(), node.getLocalPart());
            if (className != null && StandardDefs.isRepeater(className)) {
                ++this.repeaterNum;
                inRepeater = true;
            }
            this.registerVariable(node);
            super.analyze(node);
            if (inRepeater) {
                --this.repeaterNum;
            }
        }

        public void analyze(ScriptNode node) {
            if (node.getSourceFile() == null) {
                CDATANode cdata = (CDATANode)node.getChildAt(0);
                if (cdata != null) {
                    Script script = new Script(cdata.image, cdata.beginLine, cdata.endLine);
                    script.setEmbeddedScript(true);
                    this.docInfo.addScript(script);
                }
            } else {
                String source = (String)node.getAttribute("source");
                if (source != null) {
                    Script script = new Script("include \"" + source + "\";", node.beginLine);
                    this.docInfo.addScript(script);
                }
            }
        }

        public void analyze(MetaDataNode node) {
            CDATANode cdata = (CDATANode)node.getChildAt(0);
            if (cdata != null) {
                Script script = new Script(cdata.image, cdata.beginLine, cdata.endLine);
                this.docInfo.addMetadata(script);
            }
        }

        public void analyze(ModelNode node) {
            this.registerVariable(node, "id", NameFormatter.toDot(StandardDefs.CLASS_OBJECTPROXY));
        }

        public void analyze(XMLNode node) {
            this.docInfo.addImportName(NameFormatter.toDot("XMLList"), node.beginLine);
            this.registerVariable(node, "id", NameFormatter.toDot(StandardDefs.getXmlBackingClassName(node.isE4X())));
        }

        public void analyze(XMLListNode node) {
            this.docInfo.addImportName(NameFormatter.toDot("XMLList"), node.beginLine);
            this.registerVariable(node, "id", NameFormatter.toDot("XMLList"));
        }

        public void analyze(ArrayNode node) {
            this.registerVariable(node, "id", "Array");
            super.analyze(node);
        }

        public void analyze(BindingNode node) {
        }

        public void analyze(StringNode node) {
            this.registerVariable(node);
        }

        public void analyze(NumberNode node) {
            this.registerVariable(node);
        }

        public void analyze(IntNode node) {
            this.registerVariable(node);
        }

        public void analyze(UIntNode node) {
            this.registerVariable(node);
        }

        public void analyze(BooleanNode node) {
            this.registerVariable(node);
        }

        public void analyze(WebServiceNode node) {
            this.registerVariable(node);
            super.analyze(node);
        }

        public void analyze(OperationNode node) {
            super.analyze(node);
        }

        public void analyze(HTTPServiceNode node) {
            this.registerVariable(node);
        }

        public void analyze(RemoteObjectNode node) {
            this.registerVariable(node);
        }

        public void analyze(InlineComponentNode node) {
            this.createInlineComponentUnit(node);
            this.registerVariable(node, "id", StandardDefs.INTERFACE_IFACTORY);
        }

        private void registerVariable(Node node) {
            this.registerVariable(node, "id");
        }

        private void registerVariable(Node node, String attrName) {
            this.registerVariable(node, attrName, null);
        }

        private void registerVariable(Node node, String attrName, String className) {
            String id = (String)node.getAttribute(attrName);
            int line = node.getLineNumber(attrName);
            if (id != null) {
                if (!TextParser.isValidIdentifier(id)) {
                    this.log(node, line, new InvalidIdentifier(id));
                } else if (this.docInfo.containsVarDecl(id)) {
                    this.log(line, (CompilerMessage)new IdentifierUsedMoreThanOnce(id));
                } else if (this.docInfo.getClassName().equals(id)) {
                    this.log(line, (CompilerMessage)new IdentifierMatchesClassName(id));
                } else {
                    if (className == null) {
                        className = InterfaceCompiler.this.nameMappings.resolveClassName(node.getNamespace(), node.getLocalPart());
                    }
                    if (this.repeaterNum > 0) {
                        className = "Array";
                    }
                    if (className != null) {
                        if (this.baseClassInfo == null || !this.baseClassInfo.definesVariable(id) && !this.baseClassInfo.definesGetter(id, true) && !this.baseClassInfo.definesSetter(id, true)) {
                            this.docInfo.addVarDecl(id, NameFormatter.toDot(className), line);
                        }
                    } else {
                        this.log(line, (CompilerMessage)new AnalyzerAdapter.CouldNotResolveToComponent(node.image));
                    }
                }
            } else {
                if (className == null) {
                    className = InterfaceCompiler.this.nameMappings.resolveClassName(node.getNamespace(), node.getLocalPart());
                }
                if (className != null && className.indexOf(42) == -1) {
                    this.bogusImports.add(NameFormatter.toDot(className));
                }
            }
        }

        private void createInlineComponentUnit(InlineComponentNode node) {
            Node root = (Node)node.getChildAt(0);
            String className = (String)node.getAttribute("className");
            if (className != null) {
                if (!TextParser.isValidIdentifier(className)) {
                    this.log(node.getLineNumber("className"), (CompilerMessage)new ClassNameInvalidActionScriptIdentifier());
                    className = null;
                } else if (this.inlineComponentClassNames.contains(className)) {
                    this.log(node.getLineNumber("className"), (CompilerMessage)new ClassNameSpecifiedMoreThanOnce());
                    className = null;
                } else {
                    this.inlineComponentClassNames.add(className);
                }
            }
            if (className == null) {
                className = this.docInfo.getClassName() + "_inlineComponent" + ++this.inlineComponentCount;
            }
            QName classQName = new QName(this.docInfo.getPackageName(), className);
            node.setClassQName(classQName);
            TextFile virtualFile = new TextFile("", className, this.unit.getSource().getName(), this.unit.getSource().getParent(), "text/mxml", this.unit.getSource().getLastModified());
            Source source = new Source(virtualFile, this.unit.getSource(), false, false);
            ApplicationNode inlineApplicationNode = ApplicationNode.inlineApplicationNode(root.getNamespace(), root.getLocalPart(), NameFormatter.toDot(this.docInfo.getPackageName(), this.docInfo.getClassName()));
            inlineApplicationNode.beginLine = root.beginLine;
            inlineApplicationNode.beginColumn = root.beginColumn;
            inlineApplicationNode.endLine = root.endLine;
            inlineApplicationNode.endColumn = root.endColumn;
            inlineApplicationNode.image = root.image;
            root.copy(inlineApplicationNode);
            source.addSourceFragment(InterfaceCompiler.AttrInlineComponentSyntaxTree, inlineApplicationNode, null);
            this.unit.addGeneratedSource(classQName, source);
        }
    }
}

