/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.as3.binding;

import flex2.compiler.CompilationUnit;
import flex2.compiler.as3.binding.BindableInfo;
import flex2.compiler.as3.binding.ClassInfo;
import flex2.compiler.as3.binding.InterfaceInfo;
import flex2.compiler.as3.binding.TypeAnalyzer;
import flex2.compiler.as3.genext.GenerativeClassInfo;
import flex2.compiler.as3.genext.GenerativeSecondPassEvaluator;
import flex2.compiler.as3.reflect.NodeMagic;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.MultiName;
import flex2.compiler.util.QName;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import macromedia.asc.parser.ClassDefinitionNode;
import macromedia.asc.parser.DefinitionNode;
import macromedia.asc.parser.Evaluator;
import macromedia.asc.parser.FunctionDefinitionNode;
import macromedia.asc.parser.MetaDataNode;
import macromedia.asc.parser.VariableDefinitionNode;
import macromedia.asc.semantics.Value;
import macromedia.asc.util.Context;

public class BindableSecondPassEvaluator
extends GenerativeSecondPassEvaluator {
    private static final String CODEGEN_TEMPLATE_PATH = "flex2/compiler/as3/binding/";
    private static final String STATIC_EVENT_DISPATCHER = "staticEventDispatcher";
    private BindableInfo bindableInfo;
    private boolean inClass = false;

    public BindableSecondPassEvaluator(CompilationUnit unit, Map classMap, TypeAnalyzer typeAnalyzer, String generatedOutputDirectory) {
        super(unit, classMap, typeAnalyzer, generatedOutputDirectory);
    }

    public Value evaluate(Context context, ClassDefinitionNode node) {
        if (!this.evaluatedClasses.contains(node)) {
            this.inClass = true;
            String className = NodeMagic.getClassName(node);
            this.bindableInfo = (BindableInfo)this.classMap.get(className);
            if (this.bindableInfo != null) {
                ClassInfo classInfo = this.bindableInfo.getClassInfo();
                if (!classInfo.implementsInterface("flash.events", "IEventDispatcher")) {
                    this.bindableInfo.setNeedsToImplementIEventDispatcher(true);
                    MultiName multiName = new MultiName("flash.events", "IEventDispatcher");
                    InterfaceInfo interfaceInfo = this.typeAnalyzer.analyzeInterface(context, multiName, classInfo);
                    if (interfaceInfo == null || this.checkForExistingMethods(context, node, classInfo, interfaceInfo)) {
                        return null;
                    }
                    classInfo.addInterfaceMultiName("flash.events", "IEventDispatcher");
                }
                if (this.bindableInfo.getRequiresStaticEventDispatcher() && !classInfo.definesVariable(STATIC_EVENT_DISPATCHER) && !classInfo.definesGetter(STATIC_EVENT_DISPATCHER, true)) {
                    this.bindableInfo.setNeedsStaticEventDispatcher(true);
                }
                this.postProcessClassInfo(context, this.bindableInfo);
                this.prepClassDef(node);
                if (node.statements != null) {
                    node.statements.evaluate(context, (Evaluator)this);
                    this.modifySyntaxTree(context, node, this.bindableInfo);
                }
                this.bindableInfo = null;
            }
            this.inClass = false;
            this.evaluatedClasses.add(node);
        }
        return null;
    }

    private void prepClassDef(ClassDefinitionNode node) {
        if (node.metaData != null && node.metaData.items != null) {
            Iterator iter = node.metaData.items.iterator();
            while (iter.hasNext()) {
                MetaDataNode md = (MetaDataNode)iter.next();
                if (!"Bindable".equals(md.id) || md.count() != 0) continue;
                iter.remove();
            }
        }
    }

    public Value evaluate(Context context, FunctionDefinitionNode node) {
        QName qname;
        GenerativeClassInfo.AccessorInfo accessorInfo;
        if (this.inClass && (accessorInfo = this.bindableInfo.getAccessor(qname = new QName(NodeMagic.getUserNamespace((DefinitionNode)node), NodeMagic.getFunctionName(node)))) != null) {
            if (!NodeMagic.functionIsGetter(node)) {
                BindableSecondPassEvaluator.hideFunction(node, accessorInfo);
                this.registerRenamedAccessor(accessorInfo);
            } else if (!this.bindableInfo.getClassInfo().definesSetter(qname.getLocalPart(), false)) {
                context.localizedError2(node.pos(), (Object)new MissingNonInheritedSetter(qname.getLocalPart()));
            }
        }
        return null;
    }

    public Value evaluate(Context context, VariableDefinitionNode node) {
        QName qname;
        GenerativeClassInfo.AccessorInfo accessorInfo;
        if (this.inClass && (accessorInfo = this.bindableInfo.getAccessor(qname = new QName(NodeMagic.getUserNamespace((DefinitionNode)node), NodeMagic.getVariableName(node)))) != null) {
            BindableSecondPassEvaluator.hideVariable(node, accessorInfo);
            this.registerRenamedAccessor(accessorInfo);
        }
        return null;
    }

    protected String getTemplateName() {
        return "BindableProperty";
    }

    protected String getTemplatePath() {
        return CODEGEN_TEMPLATE_PATH;
    }

    protected Map getTemplateVars() {
        HashMap<String, BindableInfo> vars = new HashMap<String, BindableInfo>();
        vars.put("bindableInfo", this.bindableInfo);
        return vars;
    }

    protected String getGeneratedSuffix() {
        return "-binding-generated.as";
    }

    public static class MissingNonInheritedSetter
    extends CompilerMessage.CompilerError {
        public String getter;

        public MissingNonInheritedSetter(String getter) {
            this.getter = getter;
        }
    }
}

