/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.plugin.textwizard;

import it.businesslogic.ireport.Band;
import it.businesslogic.ireport.IReportConnection;
import it.businesslogic.ireport.JRField;
import it.businesslogic.ireport.ReportElement;
import it.businesslogic.ireport.StaticTextReportElement;
import it.businesslogic.ireport.TextFieldReportElement;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.gui.event.ReportElementChangedEvent;
import it.businesslogic.ireport.plugin.textwizard.TextColumn;
import it.businesslogic.ireport.undo.InsertElementOperation;
import it.businesslogic.ireport.util.I18n;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.SpinnerNumberModel;
import javax.swing.table.DefaultTableModel;

public class TextWizardForm
extends JDialog {
    private JButton jButton1;
    private JButton jButton2;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JSpinner jSpinner1;
    private JTable jTable1;

    public TextWizardForm(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.applyI18n();
        SpinnerNumberModel smodel = new SpinnerNumberModel();
        smodel.setMinimum(new Integer(0));
        smodel.setMaximum(new Integer(1000000));
        this.jSpinner1.setModel(smodel);
    }

    private void initComponents() {
        this.jPanel4 = new JPanel();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jSpinner1 = new JSpinner();
        this.jPanel2 = new JPanel();
        this.jSeparator1 = new JSeparator();
        this.jPanel3 = new JPanel();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jPanel5 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.setDefaultCloseOperation(2);
        this.jPanel4.setLayout(new BorderLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel1.setPreferredSize(new Dimension(10, 70));
        this.jLabel1.setText("Max report width (chars): ");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(4, 4, 0, 0);
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        this.jSpinner1.setPreferredSize(new Dimension(100, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(4, 4, 0, 0);
        this.jPanel1.add((Component)this.jSpinner1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.jPanel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.jPanel1.add((Component)this.jSeparator1, gridBagConstraints);
        this.jPanel3.setLayout(new GridBagLayout());
        this.jButton1.setText("Check for fields widths");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TextWizardForm.this.jButton1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.jPanel3.add((Component)this.jButton1, gridBagConstraints);
        this.jButton2.setText("Add elements");
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TextWizardForm.this.jButton2ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.jPanel3.add((Component)this.jButton2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel3.add((Component)this.jPanel5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jPanel3, gridBagConstraints);
        this.jPanel4.add((Component)this.jPanel1, "North");
        this.jTable1.setModel(new DefaultTableModel(new Object[0][], new String[]{"Column", "Display size", "Cut to..."}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Object.class, Integer.class, Integer.class};
                this.canEdit = new boolean[]{false, false, true};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jScrollPane1.setViewportView(this.jTable1);
        this.jPanel4.add((Component)this.jScrollPane1, "Center");
        this.getContentPane().add((Component)this.jPanel4, "Center");
        this.pack();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        if (MainFrame.getMainInstance().getActiveReportFrame() == null) {
            JOptionPane.showMessageDialog(this, I18n.getString("messages.textWizardForm.noReportFrame", "No report frame selected!"));
            return;
        }
        int count_chars = 0;
        int[] selectedRows = this.jTable1.getSelectedRows();
        for (int i = 0; i < this.jTable1.getSelectedRowCount(); ++i) {
            count_chars += ((Integer)this.jTable1.getValueAt(selectedRows[i], 2)).intValue();
        }
        if (count_chars > (Integer)this.jSpinner1.getValue() && 0 != JOptionPane.showConfirmDialog(this, I18n.getString("messages.textWizardForm.outOfMargin", "Fields will go out of margins. Continue anyway?"))) {
            return;
        }
        Vector elements = MainFrame.getMainInstance().getActiveReportFrame().getReport().getElements();
        Enumeration enum_elements = elements.elements();
        Vector<ReportElement> elements_to_remove = new Vector<ReportElement>();
        while (enum_elements.hasMoreElements()) {
            ReportElement element = (ReportElement)enum_elements.nextElement();
            if (!element.getBand().getName().equalsIgnoreCase("columnHeader") && !element.getBand().getName().equalsIgnoreCase("detail")) continue;
            elements_to_remove.add(element);
        }
        MainFrame.getMainInstance().getActiveReportFrame().setSelectedElements(elements_to_remove);
        MainFrame.getMainInstance().getActiveReportFrame().deleteSelectedElements();
        int left_char = 0;
        Band columnHeader = MainFrame.getMainInstance().getActiveReportFrame().getReport().getBandByName("columnHeader");
        Band detail = MainFrame.getMainInstance().getActiveReportFrame().getReport().getBandByName("detail");
        for (int i = 0; i < this.jTable1.getSelectedRowCount(); ++i) {
            int cut_to = (Integer)this.jTable1.getValueAt(selectedRows[i], 2);
            StaticTextReportElement stre = new StaticTextReportElement(left_char * 10 + 10, columnHeader.getBandYLocation() + 10, 10 * cut_to, 20);
            stre.setBand(columnHeader);
            stre.setText(this.jTable1.getValueAt(selectedRows[i], 0) + "");
            stre.setFontName("Monospaced");
            stre.setFontSize(14);
            MainFrame.getMainInstance().getActiveReportFrame().fireReportListenerReportElementsChanged(new ReportElementChangedEvent(MainFrame.getMainInstance().getActiveReportFrame(), stre, 2));
            MainFrame.getMainInstance().getActiveReportFrame().addUndoOperation(new InsertElementOperation(MainFrame.getMainInstance().getActiveReportFrame(), stre));
            MainFrame.getMainInstance().getActiveReportFrame().getReport().getElements().add(stre);
            TextFieldReportElement tfre = new TextFieldReportElement(left_char * 10 + 10, detail.getBandYLocation() + 10, 10 * cut_to, 20);
            tfre.setBand(detail);
            tfre.setFontName("Monospaced");
            tfre.setFontSize(14);
            String name = "$F{" + this.jTable1.getValueAt(selectedRows[i], 0) + "}";
            Enumeration fields = MainFrame.getMainInstance().getActiveReportFrame().getReport().getFields().elements();
            boolean is_string = false;
            String type = "";
            while (fields.hasMoreElements()) {
                JRField field = (JRField)fields.nextElement();
                if (!field.getName().equalsIgnoreCase(this.jTable1.getValueAt(selectedRows[i], 0) + "")) continue;
                if (field.getClassType().equalsIgnoreCase("java.lang.String")) {
                    is_string = true;
                }
                type = field.getClassType();
                break;
            }
            if (is_string) {
                tfre.setText("( ((" + name + "!=null) && (" + name + ".length() > " + cut_to + ")) ? " + name + ".substring(0," + cut_to + ") : " + name + ")");
            } else {
                tfre.setText(name);
            }
            tfre.setClassExpression(type);
            MainFrame.getMainInstance().getActiveReportFrame().fireReportListenerReportElementsChanged(new ReportElementChangedEvent(MainFrame.getMainInstance().getActiveReportFrame(), tfre, 2));
            MainFrame.getMainInstance().getActiveReportFrame().addUndoOperation(new InsertElementOperation(MainFrame.getMainInstance().getActiveReportFrame(), tfre));
            MainFrame.getMainInstance().getActiveReportFrame().getReport().getElements().add(tfre);
            left_char += cut_to + 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void jButton1ActionPerformed(ActionEvent evt) {
        block26: {
            DefaultTableModel dtm = (DefaultTableModel)this.jTable1.getModel();
            dtm.setRowCount(0);
            if (MainFrame.getMainInstance().getActiveReportFrame() == null) {
                JOptionPane.showMessageDialog(this, I18n.getString("messages.textWizardForm.noReportFrame", "No report frame selected!"));
                return;
            }
            int chars = MainFrame.getMainInstance().getActiveReportFrame().getReport().getWidth() / 10;
            ((SpinnerNumberModel)this.jSpinner1.getModel()).setValue(new Integer(chars));
            IReportConnection conn = (IReportConnection)MainFrame.getMainInstance().getProperties().get("DefaultConnection");
            if (!conn.isJDBCConnection()) {
                JOptionPane.showMessageDialog(this, I18n.getString("messages.textWizardForm.noActiveJDBC", "The active connection is not of type JDBC. Activate a JDBC connection first."));
                return;
            }
            String query = MainFrame.getMainInstance().getActiveReportFrame().getReport().getQuery();
            if (query.toLowerCase().indexOf("where") >= 0) {
                query = query.substring(0, query.toLowerCase().lastIndexOf("where"));
            }
            Connection con = null;
            Statement stmt = null;
            ResultSet rs = null;
            ResultSetMetaData rsmd = null;
            con = conn.getConnection();
            stmt = con.createStatement();
            try {
                stmt.setMaxRows(1);
            }
            catch (Exception ex) {
                // empty catch block
            }
            rs = stmt.executeQuery(query);
            rsmd = rs.getMetaData();
            for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
                String name = rsmd.getColumnName(i);
                TextColumn ct = new TextColumn(name, rsmd.getColumnDisplaySize(i));
                Enumeration fields = MainFrame.getMainInstance().getActiveReportFrame().getReport().getFields().elements();
                boolean found = false;
                while (fields.hasMoreElements()) {
                    JRField field = (JRField)fields.nextElement();
                    if (!field.getName().equalsIgnoreCase(name)) continue;
                    found = true;
                }
                if (!found) continue;
                dtm.addRow(new Object[]{ct, new Integer(ct.getSize()), new Integer(ct.getSize())});
            }
            Object var17_18 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception ex2) {
                // empty catch block
            }
            try {
                if (con != null) {
                    con.close();
                }
                break block26;
            }
            catch (Exception ex2) {}
            break block26;
            {
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(this, I18n.getFormattedString("messages.textWizardForm.queryError", "error during query execution: {0}", new Object[]{ex.getMessage()}));
                    ex.printStackTrace();
                    Object var17_19 = null;
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                    catch (Exception ex2) {
                        // empty catch block
                    }
                    try {
                        if (con != null) {
                            con.close();
                        }
                        break block26;
                    }
                    catch (Exception ex2) {}
                }
            }
            catch (Throwable throwable) {
                Object var17_20 = null;
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception ex2) {
                    // empty catch block
                }
                try {
                    if (con != null) {
                        con.close();
                    }
                }
                catch (Exception ex2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public static void main(String[] args) {
        new TextWizardForm((Frame)new JFrame(), true).setVisible(true);
    }

    public void applyI18n() {
        this.jButton1.setText(I18n.getString("textWizardForm.button1", "Check for fields widths"));
        this.jButton2.setText(I18n.getString("textWizardForm.button2", "Add elements"));
        this.jLabel1.setText(I18n.getString("textWizardForm.label1", "Max report width (chars): "));
        this.jTable1.getColumnModel().getColumn(0).setHeaderValue(I18n.getString("textWizardForm.tablecolumn.column", "Column"));
        this.jTable1.getColumnModel().getColumn(1).setHeaderValue(I18n.getString("textWizardForm.tablecolumn.displaySize", "Display size"));
        this.jTable1.getColumnModel().getColumn(2).setHeaderValue(I18n.getString("textWizardForm.tablecolumn.cutTo", "Cut to..."));
    }
}

