/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.plugin.locale;

import it.businesslogic.ireport.IReportConnection;
import it.businesslogic.ireport.connection.JDBCConnection;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.plugin.locale.ProgressBarCellRenderer;
import it.businesslogic.ireport.plugin.locale.QueryLocalesDialog;
import it.businesslogic.ireport.plugin.locale.TranslationStatusDetailDialog;
import it.businesslogic.ireport.util.I18n;
import it.businesslogic.ireport.util.LocaleAdapter;
import it.businesslogic.ireport.util.Misc;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class TranslationStatusDialog
extends JDialog {
    private JButton jButtonDetails;
    private JButton jButtonExportToJB;
    private JButton jButtonInsertDb;
    private JButton jButtonOk;
    private JLabel jLabelLocalizableString;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JTable jTableLanguages;

    public TranslationStatusDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        TableColumnModel tcm = this.jTableLanguages.getColumnModel();
        TableColumn tc = tcm.getColumn(1);
        tc.setCellRenderer(new ProgressBarCellRenderer());
        DefaultListSelectionModel dsm = new DefaultListSelectionModel();
        dsm.setSelectionMode(0);
        dsm.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                TranslationStatusDialog.this.jButtonDetails.setEnabled(TranslationStatusDialog.this.jTableLanguages.getSelectedRow() >= 0);
            }
        });
        this.jTableLanguages.setSelectionModel(dsm);
        this.applyI18n();
        this.updateStatus();
        this.jButtonInsertDb.setVisible(false);
        this.pack();
        Misc.centerFrame(this);
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                TranslationStatusDialog.this.jButtonOkActionPerformed(e);
            }
        };
        this.getRootPane().getInputMap(2).put(escape, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", escapeAction);
        this.getRootPane().setDefaultButton(this.jButtonOk);
    }

    public void updateStatus() {
        List listOfLanguages = I18n.getListOfAvailLanguages();
        DefaultTableModel dtm = (DefaultTableModel)this.jTableLanguages.getModel();
        dtm.setRowCount(0);
        Properties props_default = new Properties();
        try {
            props_default.load(MainFrame.getMainInstance().getReportClassLoader().getResourceAsStream("it/businesslogic/ireport/locale/Ireport.properties"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.jLabelLocalizableString.setText(I18n.getFormattedString("translationStatusDialog.localizableStrings", "Localizable strings: {0}", new Object[]{new Integer(props_default.size() - 1)}));
        for (int i = 0; i < listOfLanguages.size(); ++i) {
            Locale lang = (Locale)listOfLanguages.get(i);
            LocaleAdapter adapter = new LocaleAdapter(lang);
            String language = lang.getLanguage();
            String country = lang.getCountry();
            String variant = lang.getVariant();
            String language_name = language.length() > 0 ? "_" + language : "";
            language_name = language_name + (country.length() > 0 ? "_" + country : "");
            language_name = language_name + (variant.length() > 0 ? "_" + variant : "");
            language_name = "Ireport" + language_name + ".properties";
            int percentage_language = this.getLanguageCompletation(props_default, language_name);
            dtm.addRow(new Object[]{adapter, new Integer(percentage_language), language_name});
        }
    }

    public int getLanguageCompletation(Properties defaultTranslations, String language) {
        Properties props2 = new Properties();
        try {
            props2.load(MainFrame.getMainInstance().getReportClassLoader().getResourceAsStream("it/businesslogic/ireport/locale/" + language));
        }
        catch (Exception ex) {
            // empty catch block
        }
        double size = 0.0;
        Iterator<Object> namesIterator = defaultTranslations.keySet().iterator();
        size = defaultTranslations.size();
        double translated = 0.0;
        while (namesIterator.hasNext()) {
            String name = "" + namesIterator.next();
            if (name.equals("defaultFont")) {
                size -= 1.0;
                continue;
            }
            if (props2.getProperty(name) == null) continue;
            translated += 1.0;
        }
        if (translated == 0.0) {
            return 0;
        }
        return (int)(translated / size * 100.0);
    }

    private void initComponents() {
        this.jLabelLocalizableString = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTableLanguages = new JTable();
        this.jPanel1 = new JPanel();
        this.jButtonDetails = new JButton();
        this.jButtonInsertDb = new JButton();
        this.jButtonExportToJB = new JButton();
        this.jButtonOk = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(2);
        this.jLabelLocalizableString.setText("Localizable strings:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabelLocalizableString, gridBagConstraints);
        this.jTableLanguages.setModel(new DefaultTableModel(new Object[0][], new String[]{"Title 1", "Title 2", "Title 3"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{false, false, false};
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jTableLanguages.setGridColor(new Color(204, 204, 204));
        this.jTableLanguages.setShowVerticalLines(false);
        this.jTableLanguages.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                TranslationStatusDialog.this.jTableLanguagesMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTableLanguages);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jScrollPane1, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jButtonDetails.setText("Details...");
        this.jButtonDetails.setEnabled(false);
        this.jButtonDetails.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TranslationStatusDialog.this.jButtonDetailsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.jButtonDetails, gridBagConstraints);
        this.jButtonInsertDb.setText("InsertDB");
        this.jButtonInsertDb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TranslationStatusDialog.this.jButtonInsertDbActionPerformed(evt);
            }
        });
        this.jPanel1.add((Component)this.jButtonInsertDb, new GridBagConstraints());
        this.jButtonExportToJB.setText("Import from JasperBabylon");
        this.jButtonExportToJB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TranslationStatusDialog.this.jButtonExportToJBjButtonDetailsActionPerformed2(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 4, 4);
        this.jPanel1.add((Component)this.jButtonExportToJB, gridBagConstraints);
        this.jButtonOk.setText("Close");
        this.jButtonOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TranslationStatusDialog.this.jButtonOkActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.jButtonOk, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.pack();
    }

    private void jButtonExportToJBjButtonDetailsActionPerformed2(ActionEvent evt) {
        QueryLocalesDialog qld = new QueryLocalesDialog((Dialog)this, true);
        qld.setVisible(true);
        if (qld.getDialogResult() == 0) {
            Misc.saveTemporaryLocale(qld.getLocaleProperties(), "Ireport_" + qld.getLocale_code() + ".properties");
            this.updateStatus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void jButtonInsertDbActionPerformed(ActionEvent evt) {
        block19: {
            block18: {
                c = (IReportConnection)MainFrame.getMainInstance().getProperties().get("DefaultConnection");
                conn = null;
                stmt = null;
                try {
                    try {
                        if (c == null || !(c instanceof JDBCConnection)) {
                            JOptionPane.showMessageDialog(this, "Not a JDBC connection", "", 0);
                            var20_5 = null;
                            if (conn == null) return;
                            break block18;
                        }
                        conn = c.getConnection();
                        conn.createStatement().execute("delete from translations where app_id=1");
                        stmt = conn.prepareStatement("insert into translations (app_id, language_id, s_key, s_value) values(1,?,?,?);");
                        props_default = new Properties();
                        try {
                            props_default.load(MainFrame.getMainInstance().getReportClassLoader().getResourceAsStream("it/businesslogic/ireport/locale/Ireport.properties"));
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                        enum_keys = props_default.keys();
                        while (enum_keys.hasMoreElements()) {
                            key = ("" + enum_keys.nextElement()).trim();
                            val = props_default.getProperty(key);
                            stmt.setString(1, "");
                            stmt.setString(2, key);
                            stmt.setString(3, val);
                            stmt.executeUpdate();
                        }
                        listOfLanguages = I18n.getListOfAvailLanguages();
                        System.out.println("Languages: " + listOfLanguages.size());
                        for (k = 0; k < listOfLanguages.size(); ++k) {
                            lang = (Locale)listOfLanguages.get(k);
                            adapter = new LocaleAdapter(lang);
                            language = lang.getLanguage();
                            country = lang.getCountry();
                            variant = lang.getVariant();
                            language_id = language;
                            language_id = language_id + (country.length() > 0 ? "_" + country : "");
                            language_id = language_id + (variant.length() > 0 ? "_" + variant : "");
                            language_name = "Ireport" + (language.length() > 0 ? "_" : "") + language_id + ".properties";
                            System.out.println("Working on " + language_name);
                            props2 = new Properties();
                            try {
                                props2.load(MainFrame.getMainInstance().getReportClassLoader().getResourceAsStream("it/businesslogic/ireport/locale/" + language_name));
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                            enum_keys = props2.keys();
                            while (enum_keys.hasMoreElements()) {
                                key = ("" + enum_keys.nextElement()).trim();
                                val = props2.getProperty(key);
                                if (!props_default.containsKey(key)) continue;
                                stmt.setString(1, language_id);
                                stmt.setString(2, key);
                                stmt.setString(3, val);
                                stmt.executeUpdate();
                            }
                        }
                        break block19;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        var20_7 = null;
                        if (conn == null) return;
                        try {
                            conn.close();
                            return;
                        }
                        catch (Exception ex) {
                            return;
                        }
                    }
                }
                catch (Throwable var19_31) {
                    var20_8 = null;
                    if (conn == null) throw var19_31;
                    ** try [egrp 4[TRYBLOCK] [8 : 682->691)] { 
lbl79:
                    // 1 sources

                    conn.close();
                    throw var19_31;
lbl81:
                    // 1 sources

                    catch (Exception ex) {
                        // empty catch block
                    }
                    throw var19_31;
                }
            }
            ** try [egrp 4[TRYBLOCK] [8 : 682->691)] { 
lbl86:
            // 1 sources

            conn.close();
            return;
lbl88:
            // 1 sources

            catch (Exception ex) {
                // empty catch block
            }
            return;
        }
        var20_6 = null;
        if (conn == null) return;
        try {}
        catch (Exception ex) {}
        conn.close();
        return;
    }

    private void jButtonOkActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void jTableLanguagesMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            if (evt.getButton() == 1) {
                this.jButtonDetailsActionPerformed(null);
            }
        }
    }

    private void jButtonDetailsActionPerformed(ActionEvent evt) {
        if (this.jTableLanguages.getSelectedRow() < 0) {
            return;
        }
        int row = this.jTableLanguages.getSelectedRow();
        LocaleAdapter adapter = (LocaleAdapter)this.jTableLanguages.getValueAt(this.jTableLanguages.getSelectedRow(), 0);
        TranslationStatusDetailDialog tsdd = new TranslationStatusDetailDialog((Dialog)this, true);
        Properties props_default = new Properties();
        try {
            props_default.load(MainFrame.getMainInstance().getReportClassLoader().getResourceAsStream("it/businesslogic/ireport/locale/Ireport.properties"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (props_default != null) {
            tsdd.setLanguage("" + this.jTableLanguages.getValueAt(this.jTableLanguages.getSelectedRow(), 2), props_default);
            tsdd.setVisible(true);
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new TranslationStatusDialog((Frame)new JFrame(), true).setVisible(true);
            }
        });
    }

    public void applyI18n() {
        this.jButtonDetails.setText(I18n.getString("translationStatusDialog.buttonDetails", "Details..."));
        this.jButtonOk.setText(I18n.getString("translationStatusDialog.buttonOk", "Close"));
        this.jLabelLocalizableString.setText(I18n.getFormattedString("translationStatusDialog.buttonOk", "Close", new Object[]{new Integer(0)}));
        this.jTableLanguages.getColumnModel().getColumn(0).setHeaderValue(I18n.getString("translationStatusDialog.table.Language", "Language"));
        this.jTableLanguages.getColumnModel().getColumn(1).setHeaderValue(I18n.getString("translationStatusDialog.table.Status", "Status"));
        this.jTableLanguages.getColumnModel().getColumn(2).setHeaderValue(I18n.getString("translationStatusDialog.table.File", "File name"));
        this.jButtonExportToJB.setText(I18n.getString("translationStatusDialog.buttonExportToJB", "Import from JasperBabylon"));
    }
}

