/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.plugin.jrx;

import it.businesslogic.ireport.IReportConnection;
import it.businesslogic.ireport.IReportConnectionEditor;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.plugin.jrx.JRXMLDataSourceConnectionEditor;
import it.businesslogic.ireport.util.I18n;
import it.businesslogic.ireport.util.Misc;
import java.io.File;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.swing.JOptionPane;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.data.JRXmlDataSource;
import net.sf.jasperreports.engine.util.JRXmlUtils;
import org.w3c.dom.Document;

public class JRXMLDataSourceConnection
extends IReportConnection {
    private String name;
    private String filename;
    private String selectExpression;
    private boolean useConnection = false;
    private Locale locale = null;
    private String datePattern = null;
    private String numberPattern = null;
    private TimeZone timeZone = null;

    public Connection getConnection() {
        return null;
    }

    public boolean isJDBCConnection() {
        return false;
    }

    public boolean isJRDataSource() {
        return !this.isUseConnection();
    }

    public HashMap getProperties() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Filename", Misc.nvl(this.getFilename(), ""));
        map.put("SelectExpression", Misc.nvl(this.getSelectExpression(), ""));
        map.put("UseConnection", Misc.nvl("" + this.isUseConnection(), "false"));
        if (this.getLocale() != null) {
            map.put("Locale_language", Misc.nvl(this.getLocale().getLanguage(), ""));
            map.put("Locale_country", Misc.nvl(this.getLocale().getCountry(), ""));
            map.put("Locale_variant", Misc.nvl(this.getLocale().getVariant(), ""));
        }
        map.put("DatePattern", Misc.nvl(this.getDatePattern(), ""));
        map.put("NumberPattern", Misc.nvl(this.getNumberPattern(), ""));
        if (this.getTimeZone() != null) {
            map.put("timeZone", Misc.nvl(this.getTimeZone().getID(), ""));
        }
        return map;
    }

    public void loadProperties(HashMap map) {
        String timezoneId;
        String numberPatternValue;
        String datePatternValue;
        this.setFilename((String)map.get("Filename"));
        this.setSelectExpression((String)map.get("SelectExpression"));
        this.setUseConnection(Boolean.valueOf(Misc.nvl(map.get("UseConnection"), "false")));
        String language = (String)map.get("Locale_language");
        String country = (String)map.get("Locale_country");
        String variant = (String)map.get("Locale_variant");
        if (language != null && language.trim().length() > 0) {
            if (country != null && country.trim().length() > 0) {
                if (variant != null && variant.trim().length() > 0) {
                    this.setLocale(new Locale(language, country, variant));
                } else {
                    this.setLocale(new Locale(language, country));
                }
            } else {
                this.setLocale(new Locale(language));
            }
        }
        if ((datePatternValue = (String)map.get("DatePattern")) != null && datePatternValue.trim().length() > 0) {
            this.setDatePattern(datePatternValue);
        }
        if ((numberPatternValue = (String)map.get("NumberPattern")) != null && numberPatternValue.trim().length() > 0) {
            this.setNumberPattern(numberPatternValue);
        }
        if ((timezoneId = (String)map.get("timeZone")) != null && timezoneId.trim().length() > 0) {
            this.setTimeZone(TimeZone.getTimeZone(timezoneId));
        }
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public JRDataSource getJRDataSource() {
        try {
            JRXmlDataSource ds = new JRXmlDataSource(this.filename, this.getSelectExpression());
            if (this.getLocale() != null) {
                ds.setLocale(this.getLocale());
            }
            if (this.getTimeZone() != null) {
                ds.setTimeZone(this.getTimeZone());
            }
            if (this.getDatePattern() != null && this.getDatePattern().trim().length() > 0) {
                ds.setDatePattern(this.getDatePattern());
            }
            if (this.getNumberPattern() != null && this.getNumberPattern().trim().length() > 0) {
                ds.setNumberPattern(this.getNumberPattern());
            }
            return ds;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getSelectExpression() {
        return this.selectExpression;
    }

    public void setSelectExpression(String selectExpression) {
        this.selectExpression = selectExpression;
    }

    public boolean isUseConnection() {
        return this.useConnection;
    }

    public void setUseConnection(boolean useConnection) {
        this.useConnection = useConnection;
    }

    public Map getSpecialParameters(Map map) throws JRException {
        if (this.isUseConnection()) {
            System.out.println("Running against: " + this.getFilename());
            System.out.flush();
            if (this.getFilename().toLowerCase().startsWith("https://") || this.getFilename().toLowerCase().startsWith("http://") || this.getFilename().toLowerCase().startsWith("file:")) {
                map.put("XML_URL", this.getFilename());
            } else {
                Document document = JRXmlUtils.parse((File)new File(this.getFilename()));
                map.put("XML_DATA_DOCUMENT", document);
            }
            if (this.getLocale() != null) {
                map.put("XML_LOCALE", this.getLocale());
            }
            if (this.getTimeZone() != null) {
                map.put("XML_TIME_ZONE", this.getTimeZone());
            }
            if (this.getDatePattern() != null && this.getDatePattern().trim().length() > 0) {
                map.put("XML_DATE_PATTERN", this.getDatePattern());
            }
            if (this.getNumberPattern() != null && this.getNumberPattern().trim().length() > 0) {
                map.put("XML_NUMBER_PATTERN", this.getNumberPattern());
            }
        }
        return map;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public String getDatePattern() {
        return this.datePattern;
    }

    public void setDatePattern(String datePattern) {
        this.datePattern = datePattern;
    }

    public String getNumberPattern() {
        return this.numberPattern;
    }

    public void setNumberPattern(String numberPattern) {
        this.numberPattern = numberPattern;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public String getDescription() {
        return "\u30ea\u30e2\u30fc\u30c8XML\u30d5\u30a1\u30a4\u30eb\u30c7\u30fc\u30bf\u30bd\u30fc\u30b9";
    }

    public IReportConnectionEditor getIReportConnectionEditor() {
        return new JRXMLDataSourceConnectionEditor();
    }

    public void test() throws Exception {
        JOptionPane.showMessageDialog(MainFrame.getMainInstance(), I18n.getString("messages.connectionDialog.connectionTestSuccessful", "Connection test successful!"), "", 1);
        return;
    }
}

