/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui.sheet;

import it.businesslogic.ireport.ExpressionContext;
import it.businesslogic.ireport.JRField;
import it.businesslogic.ireport.JRParameter;
import it.businesslogic.ireport.JRVariable;
import it.businesslogic.ireport.SubDataset;
import it.businesslogic.ireport.gui.JReportFrame;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.gui.event.ReportBandChangedEvent;
import it.businesslogic.ireport.gui.event.ReportBandsSelectionEvent;
import it.businesslogic.ireport.gui.event.ReportElementChangedEvent;
import it.businesslogic.ireport.gui.event.ReportElementsSelectionEvent;
import it.businesslogic.ireport.gui.event.ReportFrameActivatedEvent;
import it.businesslogic.ireport.gui.event.ReportFrameActivatedListener;
import it.businesslogic.ireport.gui.event.ReportListener;
import it.businesslogic.ireport.gui.event.ReportObjectsSelectionEvent;
import it.businesslogic.ireport.gui.event.SheetPropertyValueChangedEvent;
import it.businesslogic.ireport.gui.event.SubDatasetObjectChangedEvent;
import it.businesslogic.ireport.gui.sheet.CategorySheetPanel;
import it.businesslogic.ireport.gui.sheet.ComboBoxSheetProperty;
import it.businesslogic.ireport.gui.sheet.ExpressionSheetProperty;
import it.businesslogic.ireport.gui.sheet.PropertiesSheetProperty;
import it.businesslogic.ireport.gui.sheet.SheetProperty;
import it.businesslogic.ireport.gui.sheet.Tag;
import it.businesslogic.ireport.util.I18n;
import it.businesslogic.ireport.util.LanguageChangedEvent;
import it.businesslogic.ireport.util.LanguageChangedListener;
import it.businesslogic.ireport.util.Misc;
import java.awt.Color;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.JComboBox;

public class ReportObjectSheetPanel
extends CategorySheetPanel
implements ReportListener,
LanguageChangedListener,
ReportFrameActivatedListener {
    private SheetProperty spParameterName;
    private SheetProperty spParameterDescription;
    private ExpressionSheetProperty spParameterDefaultValueExpression;
    private PropertiesSheetProperty spParameterProperties;
    private SheetProperty spParameterClassType;
    private SheetProperty spParameterIsForPrompting;
    private SheetProperty spFieldName;
    private SheetProperty spFieldDescription;
    private PropertiesSheetProperty spFieldProperties;
    private SheetProperty spFieldClassType;
    private SheetProperty spVariableName;
    private SheetProperty spVariableClassType;
    private SheetProperty spVariableCalculationType;
    private SheetProperty spVariableResetType;
    private ComboBoxSheetProperty spVariableResetGroup;
    private SheetProperty spVariableIncrementType;
    private ComboBoxSheetProperty spVariableIncrementGroup;
    private SheetProperty spVariableIncrementerClass;
    private ExpressionSheetProperty spVariableExpression;
    private ExpressionSheetProperty spVariableInitialValueExpression;
    public static Color sharedDifferentValueLabelColor = Color.red.darker().darker();
    public static Color mandatoryPropertiesLabelColor = Color.black;
    private JReportFrame jrf = null;
    private boolean init = false;
    private Vector objectSelection = new Vector();

    public ReportObjectSheetPanel() {
        this.setBackground(Color.BLUE);
        this.initSheetProperties();
        MainFrame mf = MainFrame.getMainInstance();
        mf.addReportListener(this);
        mf.addReportFrameActivatedListener(this);
        I18n.addOnLanguageChangedListener(this);
    }

    public void reportFrameActivated(ReportFrameActivatedEvent evt) {
        if (MainFrame.getMainInstance().getActiveReportFrame() == this.getJrf()) {
            return;
        }
        this.updateSelection(MainFrame.getMainInstance().getActiveReportFrame());
    }

    public void languageChanged(LanguageChangedEvent evt) {
        this.removeAllProperties();
        this.initSheetProperties();
        this.updateSelection();
    }

    public void updateSelection() {
        JReportFrame newJrf = MainFrame.getMainInstance().getActiveReportFrame();
        this.updateSelection(newJrf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSelection(JReportFrame newJrf) {
        if (newJrf != null && newJrf.getSelectedElements().size() > 0) {
            return;
        }
        if (newJrf == null) {
            this.setSelection(new Vector());
        } else {
            this.setSelection(newJrf.getSelectedObjects());
        }
        this.setInit(true);
        this.removeAllProperties();
        this.jrf = newJrf;
        if (this.jrf == null || this.getSelection().size() == 0) {
            this.recreateSheet();
            return;
        }
        try {
            try {
                Vector selectedElements = this.getSelection();
                boolean sameParameterDescription = true;
                boolean sameParameterDefaultValueExpression = true;
                boolean sameParameterClassType = true;
                boolean sameParameterIsForPrompting = true;
                boolean sameFieldDescription = true;
                boolean sameFieldClassType = true;
                boolean sameVariableResetType = true;
                boolean sameVariableResetGroup = true;
                boolean sameVariableCalculationType = true;
                boolean sameVariableClassType = true;
                boolean sameVariableExpression = true;
                boolean sameVariableInitialValueExpression = true;
                boolean sameVariableIncrementGroup = true;
                boolean sameVariableIncrementType = true;
                boolean sameVariableIncrementerClass = true;
                boolean areAllparameters = true;
                boolean areAllfields = true;
                boolean areAllvariables = true;
                boolean isTheFirstElement = true;
                boolean areBuiltInParameters = false;
                boolean areBuiltInVariables = false;
                SubDataset subdataset = null;
                for (int i = 0; i < selectedElements.size(); ++i) {
                    SubDataset s2;
                    Object obj = selectedElements.elementAt(i);
                    if (!(obj instanceof JRParameter)) {
                        areAllparameters = false;
                    }
                    if (!(obj instanceof JRField)) {
                        areAllfields = false;
                    }
                    if (!(obj instanceof JRVariable)) {
                        areAllvariables = false;
                    }
                    if (isTheFirstElement) {
                        subdataset = Misc.getObjectSubDataset(this.jrf.getReport(), obj);
                        this.updateAllComboBoxes(subdataset);
                    } else if (subdataset != null && (s2 = Misc.getObjectSubDataset(subdataset, obj)) != subdataset) {
                        subdataset = null;
                    }
                    if (areAllparameters) {
                        JRParameter param = (JRParameter)selectedElements.elementAt(i);
                        if (!areBuiltInParameters) {
                            areBuiltInParameters = param.isBuiltin();
                        }
                        if (selectedElements.size() == 1) {
                            this.setTextArea(isTheFirstElement, param.getName(), this.spParameterName);
                            this.spParameterProperties.setValue(param.getProperties());
                        }
                        if (sameParameterDescription) {
                            sameParameterDescription = this.setTextArea(isTheFirstElement, param.getDescription(), this.spParameterDescription);
                        }
                        if (sameParameterDefaultValueExpression) {
                            sameParameterDefaultValueExpression = this.setTextArea(isTheFirstElement, param.getDefaultValueExpression(), this.spParameterDefaultValueExpression);
                        }
                        if (sameParameterClassType) {
                            sameParameterClassType = this.setGenericSheetProperty(isTheFirstElement, param.getClassType(), this.spParameterClassType);
                        }
                        if (sameParameterIsForPrompting) {
                            sameParameterIsForPrompting = this.setCheckBox(isTheFirstElement, param.isIsForPrompting(), false, this.spParameterIsForPrompting);
                        }
                    }
                    if (areAllfields) {
                        JRField field = (JRField)selectedElements.elementAt(i);
                        if (selectedElements.size() == 1) {
                            this.setTextArea(isTheFirstElement, field.getName(), this.spFieldName);
                            this.spFieldProperties.setValue(field.getProperties());
                        }
                        if (sameFieldDescription) {
                            sameFieldDescription = this.setTextArea(isTheFirstElement, field.getDescription(), this.spFieldDescription);
                        }
                        if (sameFieldClassType) {
                            sameFieldClassType = this.setGenericSheetProperty(isTheFirstElement, field.getClassType(), this.spFieldClassType);
                        }
                    }
                    if (areAllvariables) {
                        JRVariable variable = (JRVariable)selectedElements.elementAt(i);
                        if (!areBuiltInVariables) {
                            areBuiltInVariables = variable.isBuiltin();
                        }
                        if (selectedElements.size() == 1) {
                            this.setTextArea(isTheFirstElement, variable.getName(), this.spVariableName);
                        }
                        if (subdataset != null) {
                            if (sameVariableResetType) {
                                sameVariableResetType = this.setTagComboBox(isTheFirstElement, variable.getResetType(), this.spVariableResetType);
                            }
                            if (sameVariableResetGroup) {
                                sameVariableResetGroup = this.setTagComboBox(isTheFirstElement, variable.getResetGroup(), this.spVariableResetGroup);
                            }
                            if (sameVariableIncrementType) {
                                sameVariableIncrementType = this.setTagComboBox(isTheFirstElement, variable.getIncrementType(), this.spVariableIncrementType);
                            }
                            if (sameVariableIncrementGroup) {
                                sameVariableIncrementGroup = this.setTagComboBox(isTheFirstElement, variable.getIncrementGroup(), this.spVariableIncrementGroup);
                            }
                        }
                        if (sameVariableCalculationType) {
                            sameVariableCalculationType = this.setTagComboBox(isTheFirstElement, variable.getCalculation(), this.spVariableCalculationType);
                        }
                        if (sameVariableIncrementerClass) {
                            sameVariableIncrementerClass = this.setTextArea(isTheFirstElement, variable.getIncrementerFactoryClass(), this.spVariableIncrementerClass);
                        }
                        if (sameVariableClassType) {
                            sameVariableClassType = this.setGenericSheetProperty(isTheFirstElement, variable.getClassType(), this.spVariableClassType);
                        }
                        if (sameVariableExpression) {
                            sameVariableExpression = this.setTextArea(isTheFirstElement, variable.getExpression(), this.spVariableExpression);
                        }
                        if (sameVariableInitialValueExpression) {
                            sameVariableInitialValueExpression = this.setTextArea(isTheFirstElement, variable.getInitialValueExpression(), this.spVariableInitialValueExpression);
                        }
                    }
                    isTheFirstElement = false;
                }
                if (subdataset != null) {
                    ExpressionContext ec = new ExpressionContext();
                    ec.setSubDataset(subdataset);
                    this.spParameterDefaultValueExpression.setExpressionContext(ec);
                    this.spVariableExpression.setExpressionContext(ec);
                    this.spVariableInitialValueExpression.setExpressionContext(ec);
                }
                this.spParameterDefaultValueExpression.setLabelError(null);
                this.spParameterDefaultValueExpression.updateLabel();
                this.spVariableExpression.setLabelError(null);
                this.spVariableExpression.updateLabel();
                this.spVariableInitialValueExpression.setLabelError(null);
                this.spVariableInitialValueExpression.updateLabel();
                if (areAllparameters) {
                    String commonStr = I18n.getString("parameterProperties", "Parameter Properties");
                    if (this.getSelection().size() == 1) {
                        this.addSheetProperty(commonStr, this.spParameterName);
                    }
                    this.spParameterIsForPrompting.setDefaultValue(new Boolean(true));
                    this.addSheetProperty(commonStr, this.spParameterClassType);
                    this.spParameterClassType.setLabelColor(sameParameterClassType ? mandatoryPropertiesLabelColor : sharedDifferentValueLabelColor);
                    if (!areBuiltInParameters) {
                        this.spParameterName.setReadOnly(false);
                        this.spParameterClassType.setReadOnly(false);
                        this.spParameterIsForPrompting.setLabelColor(sameParameterIsForPrompting ? mandatoryPropertiesLabelColor : sharedDifferentValueLabelColor);
                        this.addSheetProperty(commonStr, this.spParameterIsForPrompting);
                        this.spParameterDefaultValueExpression.setLabelColor(sameParameterDefaultValueExpression ? mandatoryPropertiesLabelColor : sharedDifferentValueLabelColor);
                        this.addSheetProperty(commonStr, this.spParameterDefaultValueExpression);
                        if (this.getSelection().size() == 1) {
                            this.addSheetProperty(commonStr, this.spParameterProperties);
                        }
                    } else {
                        this.spParameterName.setReadOnly(true);
                        this.spParameterClassType.setReadOnly(true);
                    }
                } else if (areAllfields) {
                    String commonStr = I18n.getString("fieldProperties", "Field Properties");
                    if (this.getSelection().size() == 1) {
                        this.addSheetProperty(commonStr, this.spFieldName);
                    }
                    this.spFieldClassType.setLabelColor(sameFieldClassType ? mandatoryPropertiesLabelColor : sharedDifferentValueLabelColor);
                    this.addSheetProperty(commonStr, this.spFieldClassType);
                    this.spFieldDescription.setLabelColor(sameFieldDescription ? mandatoryPropertiesLabelColor : sharedDifferentValueLabelColor);
                    this.addSheetProperty(commonStr, this.spFieldDescription);
                    if (this.getSelection().size() == 1) {
                        this.addSheetProperty(commonStr, this.spFieldProperties);
                    }
                } else if (areAllvariables) {
                    String commonStr = I18n.getString("variableProperties", "Variable Properties");
                    if (this.getSelection().size() == 1) {
                        this.addSheetProperty(commonStr, this.spVariableName);
                    }
                    this.spVariableClassType.setLabelColor(sameVariableClassType ? mandatoryPropertiesLabelColor : sharedDifferentValueLabelColor);
                    this.addSheetProperty(commonStr, this.spVariableClassType);
                    if (!areBuiltInVariables) {
                        this.spVariableName.setReadOnly(false);
                        this.spVariableClassType.setReadOnly(false);
                        this.spVariableCalculationType.setLabelColor(sameVariableCalculationType ? mandatoryPropertiesLabelColor : sharedDifferentValueLabelColor);
                        this.addSheetProperty(commonStr, this.spVariableCalculationType);
                        if (subdataset != null) {
                            this.spVariableResetType.setLabelColor(sameVariableResetType ? mandatoryPropertiesLabelColor : sharedDifferentValueLabelColor);
                            this.addSheetProperty(commonStr, this.spVariableResetType);
                            this.spVariableResetGroup.setLabelColor(sameVariableResetGroup ? mandatoryPropertiesLabelColor : sharedDifferentValueLabelColor);
                            this.addSheetProperty(commonStr, this.spVariableResetGroup);
                            this.spVariableIncrementType.setLabelColor(sameVariableIncrementType ? mandatoryPropertiesLabelColor : sharedDifferentValueLabelColor);
                            this.addSheetProperty(commonStr, this.spVariableIncrementType);
                            this.spVariableIncrementGroup.setLabelColor(sameVariableIncrementGroup ? mandatoryPropertiesLabelColor : sharedDifferentValueLabelColor);
                            this.addSheetProperty(commonStr, this.spVariableIncrementGroup);
                            if (!sameVariableResetType || !this.spVariableResetType.getValue().equals("Group")) {
                                this.spVariableResetGroup.setReadOnly(true);
                            } else {
                                this.spVariableResetGroup.setReadOnly(false);
                            }
                            if (!sameVariableIncrementType || !this.spVariableIncrementType.getValue().equals("Group")) {
                                this.spVariableIncrementGroup.setReadOnly(true);
                            } else {
                                this.spVariableIncrementGroup.setReadOnly(false);
                            }
                        }
                        this.spVariableIncrementerClass.setLabelColor(sameVariableIncrementerClass ? mandatoryPropertiesLabelColor : sharedDifferentValueLabelColor);
                        this.addSheetProperty(commonStr, this.spVariableIncrementerClass);
                        this.spVariableExpression.setLabelColor(sameVariableExpression ? mandatoryPropertiesLabelColor : sharedDifferentValueLabelColor);
                        this.addSheetProperty(commonStr, this.spVariableExpression);
                        this.spVariableInitialValueExpression.setLabelColor(sameVariableInitialValueExpression ? mandatoryPropertiesLabelColor : sharedDifferentValueLabelColor);
                        this.addSheetProperty(commonStr, this.spVariableInitialValueExpression);
                    } else {
                        this.spVariableName.setReadOnly(true);
                        this.spVariableClassType.setReadOnly(true);
                    }
                }
                this.recreateSheet();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                Object var29_34 = null;
            }
            Object var29_33 = null;
        }
        catch (Throwable throwable) {
            Object var29_35 = null;
            throw throwable;
        }
        this.setInit(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sheetPropertyValueChanged(SheetPropertyValueChangedEvent evt) {
        if (this.isInit()) {
            return;
        }
        try {
            this.setInit(true);
            Vector selectedElements = this.getSelection();
            Vector modified_parameters = new Vector();
            Vector<JRParameter> original_parameters = new Vector<JRParameter>();
            Vector modified_fields = new Vector();
            Vector<JRField> original_fields = new Vector<JRField>();
            Vector modified_variables = new Vector();
            Vector<JRVariable> original_variables = new Vector<JRVariable>();
            for (int i = 0; i < selectedElements.size(); ++i) {
                SubDataset sd;
                int k;
                Object object = selectedElements.elementAt(i);
                if (object instanceof JRParameter) {
                    JRParameter param = (JRParameter)object;
                    if (param.isBuiltin()) continue;
                    JRParameter originalParam = param.cloneMe();
                    if (this.applyNewParameterProperty(param, evt.getPropertyName(), evt.getOldValue(), evt.getNewValue())) {
                        modified_parameters.add(object);
                        original_parameters.add(originalParam);
                    }
                } else if (object instanceof JRField) {
                    JRField field = (JRField)object;
                    JRField originalField = field.cloneMe();
                    if (this.applyNewFieldProperty(field, evt.getPropertyName(), evt.getOldValue(), evt.getNewValue())) {
                        modified_fields.add(object);
                        original_fields.add(originalField);
                    }
                } else if (object instanceof JRVariable) {
                    JRVariable variable = (JRVariable)object;
                    JRVariable originalVariable = variable.cloneMe();
                    if (this.applyNewVariableProperty(variable, evt.getPropertyName(), evt.getOldValue(), evt.getNewValue())) {
                        modified_variables.add(object);
                        original_variables.add(originalVariable);
                    }
                }
                for (k = 0; k < modified_parameters.size(); ++k) {
                    JRParameter param = (JRParameter)modified_parameters.get(k);
                    JRParameter oldParam = (JRParameter)original_parameters.get(k);
                    sd = Misc.getObjectSubDataset(this.getJrf().getReport(), param);
                    sd.fireSubDatasetObjectChangedListenerSubDatasetObjectChanged(new SubDatasetObjectChangedEvent(sd, 2, 1, oldParam, param));
                }
                for (k = 0; k < modified_fields.size(); ++k) {
                    JRField field = (JRField)modified_fields.get(k);
                    JRField oldField = (JRField)original_fields.get(k);
                    sd = Misc.getObjectSubDataset(this.getJrf().getReport(), field);
                    sd.fireSubDatasetObjectChangedListenerSubDatasetObjectChanged(new SubDatasetObjectChangedEvent(sd, 0, 1, oldField, field));
                }
                for (k = 0; k < modified_variables.size(); ++k) {
                    JRVariable variable = (JRVariable)modified_variables.get(k);
                    JRVariable oldVariable = (JRVariable)original_variables.get(k);
                    sd = Misc.getObjectSubDataset(this.getJrf().getReport(), variable);
                    sd.fireSubDatasetObjectChangedListenerSubDatasetObjectChanged(new SubDatasetObjectChangedEvent(sd, 1, 1, oldVariable, variable));
                }
            }
            this.getJrf().getReport().incrementReportChanges();
            Object var16_16 = null;
            this.setInit(false);
        }
        catch (Throwable throwable) {
            Object var16_17 = null;
            this.setInit(false);
            throw throwable;
        }
    }

    private boolean applyNewParameterProperty(JRParameter param, String propertyName, Object oldValue, Object newValue) {
        if (propertyName == null) {
            return false;
        }
        boolean objectModified = true;
        if (propertyName.equals("parameterName")) {
            SubDataset paramSubdataset = Misc.getObjectSubDataset(this.getJrf().getReport(), param);
            if (paramSubdataset != null && newValue != null) {
                for (int i = 0; i < paramSubdataset.getParameters().size(); ++i) {
                    JRParameter f = (JRParameter)paramSubdataset.getParameters().get(i);
                    if (!f.getName().equals(newValue)) continue;
                    ((SheetProperty)this.getSheetProperty(propertyName)).setLabelError(I18n.getString("messages.jRParameterDialog.DuplicatedParameterName", "A parameter with this name already exists!"));
                    ((SheetProperty)this.getSheetProperty(propertyName)).updateLabel();
                    return false;
                }
                param.setName("" + newValue);
                ((SheetProperty)this.getSheetProperty(propertyName)).setLabelError(null);
                ((SheetProperty)this.getSheetProperty(propertyName)).updateLabel();
            }
        } else if (propertyName.equals("parameterIsForPrompting")) {
            param.setIsForPrompting((Boolean)newValue);
        } else if (propertyName.equals("parameterDescription")) {
            if (newValue != null) {
                param.setDescription("" + newValue);
            }
        } else if (propertyName.equals("parameterProperties")) {
            if (newValue != null && newValue instanceof List) {
                param.setProperties((List)newValue);
            }
        } else if (propertyName.equals("parameterClassType")) {
            if (newValue != null) {
                param.setClassType("" + newValue);
            }
        } else if (propertyName.equals("parameterDefaultValueExpression")) {
            if (newValue != null) {
                param.setDefaultValueExpression("" + newValue);
            }
            ((SheetProperty)this.getSheetProperty(propertyName)).setLabelError(null);
            ((SheetProperty)this.getSheetProperty(propertyName)).updateLabel();
        }
        return objectModified;
    }

    private boolean applyNewFieldProperty(JRField field, String propertyName, Object oldValue, Object newValue) {
        if (propertyName == null) {
            return false;
        }
        boolean objectModified = true;
        if (propertyName.equals("fieldName")) {
            SubDataset paramSubdataset = Misc.getObjectSubDataset(this.getJrf().getReport(), field);
            if (paramSubdataset != null && newValue != null) {
                for (int i = 0; i < paramSubdataset.getFields().size(); ++i) {
                    JRField f = (JRField)paramSubdataset.getFields().get(i);
                    if (!f.getName().equals(newValue)) continue;
                    ((SheetProperty)this.getSheetProperty(propertyName)).setLabelError(I18n.getString("messages.JRFieldDialog.DuplicatedFieldName", "A field with this name already exists!"));
                    ((SheetProperty)this.getSheetProperty(propertyName)).updateLabel();
                    return false;
                }
                field.setName("" + newValue);
                ((SheetProperty)this.getSheetProperty(propertyName)).setLabelError(null);
                ((SheetProperty)this.getSheetProperty(propertyName)).updateLabel();
            }
        } else if (propertyName.equals("fieldDescription")) {
            if (newValue != null) {
                field.setDescription("" + newValue);
            }
        } else if (propertyName.equals("fieldProperties")) {
            if (newValue != null && newValue instanceof List) {
                field.setProperties((List)newValue);
            }
        } else if (propertyName.equals("fieldClassType") && newValue != null) {
            field.setClassType("" + newValue);
        }
        return objectModified;
    }

    private boolean applyNewVariableProperty(JRVariable variable, String propertyName, Object oldValue, Object newValue) {
        if (propertyName == null) {
            return false;
        }
        boolean objectModified = true;
        if (propertyName.equals("variableName")) {
            SubDataset paramSubdataset = Misc.getObjectSubDataset(this.getJrf().getReport(), variable);
            if (paramSubdataset != null && newValue != null) {
                for (int i = 0; i < paramSubdataset.getVariables().size(); ++i) {
                    JRVariable f = (JRVariable)paramSubdataset.getVariables().get(i);
                    if (!f.getName().equals(newValue)) continue;
                    ((SheetProperty)this.getSheetProperty(propertyName)).setLabelError(I18n.getString("messages.JRVariableDialog.DuplicatedVariableName", "A variable with this name already exists!"));
                    ((SheetProperty)this.getSheetProperty(propertyName)).updateLabel();
                    return false;
                }
                variable.setName("" + newValue);
                ((SheetProperty)this.getSheetProperty(propertyName)).setLabelError(null);
                ((SheetProperty)this.getSheetProperty(propertyName)).updateLabel();
            }
        } else if (propertyName.equals("variableClassType")) {
            if (newValue != null) {
                variable.setClassType("" + newValue);
            }
        } else if (propertyName.equals("variableCalculationType")) {
            if (newValue != null) {
                variable.setCalculation("" + newValue);
            }
        } else if (propertyName.equals("variableResetType")) {
            if (newValue != null) {
                variable.setResetType("" + newValue);
            }
            if (newValue != null && newValue.equals("Group")) {
                this.spVariableResetGroup.setReadOnly(false);
                variable.setResetGroup(this.spVariableResetGroup.getValue() + "");
            } else {
                this.spVariableResetGroup.setReadOnly(true);
                variable.setResetGroup("");
            }
            this.spVariableResetGroup.updateLabel();
        } else if (propertyName.equals("variableResetGroup")) {
            variable.setResetGroup(newValue == null ? "" : "" + newValue);
        } else if (propertyName.equals("variableIncrementType")) {
            if (newValue != null) {
                variable.setIncrementType("" + newValue);
            }
            if (newValue != null && newValue.equals("Group")) {
                this.spVariableIncrementGroup.setReadOnly(false);
                variable.setResetGroup(this.spVariableIncrementGroup.getValue() + "");
            } else {
                this.spVariableIncrementGroup.setReadOnly(true);
                variable.setIncrementGroup("");
            }
            this.spVariableIncrementGroup.updateLabel();
        } else if (propertyName.equals("variableIncrementGroup")) {
            variable.setIncrementGroup(newValue == null ? "" : "" + newValue);
        } else if (propertyName.equals("variableIncrementerClass")) {
            variable.setIncrementerFactoryClass(newValue == null ? "" : "" + newValue);
        } else if (propertyName.equals("variableExpression")) {
            if (newValue != null) {
                variable.setExpression("" + newValue);
            }
            ((SheetProperty)this.getSheetProperty(propertyName)).setLabelError(null);
            ((SheetProperty)this.getSheetProperty(propertyName)).updateLabel();
        } else if (propertyName.equals("variableInitialValueExpression")) {
            if (newValue != null) {
                variable.setInitialValueExpression("" + newValue);
            }
            ((SheetProperty)this.getSheetProperty(propertyName)).setLabelError(null);
            ((SheetProperty)this.getSheetProperty(propertyName)).updateLabel();
        }
        return objectModified;
    }

    public void reportBandChanged(ReportBandChangedEvent evt) {
    }

    protected void initSheetProperties() {
        this.spParameterName = new SheetProperty("parameterName", I18n.getString("crosstabParameterDialog.label1", "Parameter name"), 8);
        this.spParameterName.setShowResetButton(false);
        this.spParameterDescription = new SheetProperty("parameterDescription", I18n.getString("jRParameterDialog.label4", "Parameter Description"), 8);
        this.spParameterDescription.setShowResetButton(false);
        this.spParameterDefaultValueExpression = new ExpressionSheetProperty("parameterDefaultValueExpression", I18n.getString("jRParameterDialog.label3", "Default Value Expression"));
        this.spParameterDefaultValueExpression.setShowResetButton(false);
        this.spParameterProperties = new PropertiesSheetProperty("parameterProperties", I18n.getString("parameterProperties", "Parameter Properties"));
        this.spParameterProperties.setShowResetButton(false);
        this.spParameterClassType = new ComboBoxSheetProperty("parameterClassType", I18n.getString("jRParameterDialog.label2", "Parameter Class Type"));
        this.spParameterClassType.setShowResetButton(false);
        JComboBox classTypeCombo = (JComboBox)this.spParameterClassType.getEditor();
        classTypeCombo.setEditable(true);
        classTypeCombo.addItem("java.lang.Boolean");
        classTypeCombo.addItem("java.lang.Byte");
        classTypeCombo.addItem("java.util.Date");
        classTypeCombo.addItem("java.sql.Timestamp");
        classTypeCombo.addItem("java.sql.Time");
        classTypeCombo.addItem("java.lang.Double");
        classTypeCombo.addItem("java.lang.Float");
        classTypeCombo.addItem("java.lang.Integer");
        classTypeCombo.addItem("java.lang.Long");
        classTypeCombo.addItem("java.lang.Short");
        classTypeCombo.addItem("java.math.BigDecimal");
        classTypeCombo.addItem("java.lang.Number");
        classTypeCombo.addItem("java.lang.String");
        classTypeCombo.addItem("java.util.Collection");
        classTypeCombo.addItem("java.util.List");
        classTypeCombo.addItem("java.lang.Object");
        classTypeCombo.addItem("java.io.InputStream");
        classTypeCombo.addItem("net.sf.jasperreports.engine.JREmptyDataSource");
        this.spParameterIsForPrompting = new SheetProperty("parameterIsForPrompting", I18n.getString("jRParameterDialog.checkBoxIsForPrompting", "Use as a Prompt"), 4);
        this.spParameterIsForPrompting.setShowResetButton(false);
        this.spFieldName = new SheetProperty("fieldName", I18n.getString("jRFieldDialog.label1", "Field name"), 8);
        this.spFieldName.setShowResetButton(false);
        this.spFieldDescription = new SheetProperty("fieldDescription", I18n.getString("jRFieldDialog.label4", "Field Description"), 8);
        this.spFieldDescription.setShowResetButton(false);
        this.spFieldClassType = new ComboBoxSheetProperty("fieldClassType", I18n.getString("jRFieldDialog.label2", "Field Class Type"));
        this.spFieldClassType.setShowResetButton(false);
        classTypeCombo = (JComboBox)this.spFieldClassType.getEditor();
        classTypeCombo.setEditable(true);
        classTypeCombo.addItem("java.lang.Boolean");
        classTypeCombo.addItem("java.lang.Byte");
        classTypeCombo.addItem("java.util.Date");
        classTypeCombo.addItem("java.sql.Timestamp");
        classTypeCombo.addItem("java.sql.Time");
        classTypeCombo.addItem("java.lang.Double");
        classTypeCombo.addItem("java.lang.Float");
        classTypeCombo.addItem("java.lang.Integer");
        classTypeCombo.addItem("java.lang.Long");
        classTypeCombo.addItem("java.lang.Short");
        classTypeCombo.addItem("java.math.BigDecimal");
        classTypeCombo.addItem("java.lang.Number");
        classTypeCombo.addItem("java.lang.String");
        classTypeCombo.addItem("java.util.Collection");
        classTypeCombo.addItem("java.util.List");
        this.spFieldProperties = new PropertiesSheetProperty("fieldProperties", I18n.getString("fieldProperties", "Field Properties"));
        this.spFieldProperties.setShowResetButton(false);
        this.spVariableName = new SheetProperty("variableName", I18n.getString("jRVariableDialog.label1", "Variable name"), 8);
        this.spVariableName.setShowResetButton(false);
        this.spVariableClassType = new ComboBoxSheetProperty("variableClassType", I18n.getString("jRVariableDialog.label5", "Variable Class Type"));
        this.spVariableClassType.setShowResetButton(false);
        classTypeCombo = (JComboBox)this.spVariableClassType.getEditor();
        classTypeCombo.setEditable(true);
        classTypeCombo.addItem("java.lang.Boolean");
        classTypeCombo.addItem("java.lang.Byte");
        classTypeCombo.addItem("java.util.Date");
        classTypeCombo.addItem("java.sql.Timestamp");
        classTypeCombo.addItem("java.sql.Time");
        classTypeCombo.addItem("java.lang.Double");
        classTypeCombo.addItem("java.lang.Float");
        classTypeCombo.addItem("java.lang.Integer");
        classTypeCombo.addItem("java.lang.Long");
        classTypeCombo.addItem("java.lang.Short");
        classTypeCombo.addItem("java.math.BigDecimal");
        classTypeCombo.addItem("java.lang.Number");
        classTypeCombo.addItem("java.lang.String");
        classTypeCombo.addItem("java.util.Collection");
        classTypeCombo.addItem("java.util.List");
        classTypeCombo.addItem("java.lang.Object");
        classTypeCombo.addItem("java.io.InputStream");
        classTypeCombo.addItem("net.sf.jasperreports.engine.JREmptyDataSource");
        this.spVariableCalculationType = new SheetProperty("variableCalculationType", I18n.getString("jRVariableDialog.label2", "Calculation Type"), 2);
        Vector<Tag> tags = new Vector<Tag>();
        tags.add(new Tag("Nothing", I18n.getString("variable.calculationType.Nothing", "Nothing")));
        tags.add(new Tag("Count", I18n.getString("variable.calculationType.Count", "Count")));
        tags.add(new Tag("DistinctCount", I18n.getString("variable.calculationType.DistinctCount", "Distinct count")));
        tags.add(new Tag("Sum", I18n.getString("variable.calculationType.Sum", "Sum")));
        tags.add(new Tag("Average", I18n.getString("variable.calculationType.Average", "Average")));
        tags.add(new Tag("Lowest", I18n.getString("variable.calculationType.Lowest", "Lowest")));
        tags.add(new Tag("Highest", I18n.getString("variable.calculationType.Highest", "Highest")));
        tags.add(new Tag("StandardDeviation", I18n.getString("variable.calculationType.StandardDeviation", "Standard deviation")));
        tags.add(new Tag("Variance", I18n.getString("variable.calculationType.Variance", "Variance")));
        tags.add(new Tag("System", I18n.getString("variable.calculationType.System", "System")));
        tags.add(new Tag("First", I18n.getString("variable.calculationType.First", "First")));
        this.spVariableCalculationType.setTags(tags);
        this.spVariableCalculationType.setDefaultValue("Now");
        this.spVariableCalculationType.setShowResetButton(false);
        this.spVariableResetType = new SheetProperty("variableResetType", I18n.getString("jRVariableDialog.label7", "Reset Type"), 2);
        this.spVariableResetType.setShowResetButton(false);
        tags = new Vector();
        tags.add(new Tag("None", I18n.getString("resetType.None", "None")));
        tags.add(new Tag("Report", I18n.getString("resetType.Report", "Report")));
        tags.add(new Tag("Page", I18n.getString("resetType.Page", "Page")));
        tags.add(new Tag("Column", I18n.getString("resetType.Column", "Column")));
        tags.add(new Tag("Group", I18n.getString("resetType.Group", "Group")));
        this.spVariableResetType.setTags(tags);
        this.spVariableResetType.setDefaultValue("Report");
        this.spVariableResetGroup = new ComboBoxSheetProperty("variableResetGroup", I18n.getString("jRVariableDialog.label6", "Reset Group"));
        this.spVariableResetGroup.setShowResetButton(false);
        this.spVariableIncrementType = new SheetProperty("variableIncrementType", I18n.getString("gui.elementpropertiessheet.textfieldEvaluationTime", "Eval. time"), 2);
        tags = new Vector();
        tags.add(new Tag("None", I18n.getString("incrementType.None", "None")));
        tags.add(new Tag("Report", I18n.getString("incrementType.Report", "Report")));
        tags.add(new Tag("Page", I18n.getString("incrementType.Page", "Page")));
        tags.add(new Tag("Column", I18n.getString("incrementType.Column", "Column")));
        tags.add(new Tag("Group", I18n.getString("incrementType.Group", "Group")));
        this.spVariableIncrementType.setShowResetButton(false);
        this.spVariableIncrementType.setTags(tags);
        this.spVariableIncrementType.setDefaultValue("None");
        this.spVariableIncrementGroup = new ComboBoxSheetProperty("variableIncrementGroup", I18n.getString("jRVariableDialog.label10", "Increment Group"));
        this.spVariableIncrementGroup.setShowResetButton(false);
        this.spVariableIncrementerClass = new SheetProperty("variableIncrementerClass", I18n.getString("jRVariableDialog.label8", "Custom Incrementer Factory Class"), 8);
        this.spVariableIncrementerClass.setShowResetButton(false);
        this.spVariableExpression = new ExpressionSheetProperty("variableExpression", I18n.getString("jRVariableDialog.label3", "Variable Expression"));
        this.spVariableExpression.setShowResetButton(false);
        this.spVariableInitialValueExpression = new ExpressionSheetProperty("variableInitialValueExpression", I18n.getString("jRVariableDialog.label4", "Initial Value Expression"));
        this.spVariableInitialValueExpression.setShowResetButton(false);
    }

    protected void updateAllComboBoxes(SubDataset subDataset) {
        if (this.jrf == null) {
            return;
        }
        Vector<String> group_names = new Vector<String>();
        if (subDataset != null) {
            Enumeration e = subDataset.getGroups().elements();
            while (e.hasMoreElements()) {
                group_names.addElement("" + e.nextElement());
            }
        }
        this.spVariableIncrementGroup.updateValues(group_names, false);
        this.spVariableResetGroup.updateValues(group_names, false);
    }

    public boolean isInit() {
        return this.init;
    }

    public void setInit(boolean init) {
        this.init = init;
    }

    public JReportFrame getJrf() {
        return this.jrf;
    }

    public void setJrf(JReportFrame jrf) {
        this.jrf = jrf;
    }

    public void repaintEditor() {
        if (this.jrf == null) {
            return;
        }
        this.jrf.getJPanelReport().repaint();
    }

    public Vector getSelection() {
        return this.objectSelection;
    }

    public void setSelection(Vector newSelection) {
        this.objectSelection.removeAllElements();
        if (newSelection == null) {
            return;
        }
        this.objectSelection.addAll(newSelection);
    }

    public void reportElementsSelectionChanged(ReportElementsSelectionEvent evt) {
    }

    public void reportElementsChanged(ReportElementChangedEvent evt) {
    }

    public void reportBandsSelectionChanged(ReportBandsSelectionEvent evt) {
    }

    public void reportObjectsSelectionChanged(ReportObjectsSelectionEvent evt) {
        this.updateSelection();
    }
}

