/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui.sheet;

import it.businesslogic.ireport.Band;
import it.businesslogic.ireport.ChartReportElement;
import it.businesslogic.ireport.ExpressionContext;
import it.businesslogic.ireport.Group;
import it.businesslogic.ireport.ImageReportElement;
import it.businesslogic.ireport.JRVariable;
import it.businesslogic.ireport.Report;
import it.businesslogic.ireport.ReportElement;
import it.businesslogic.ireport.SubDataset;
import it.businesslogic.ireport.TextFieldReportElement;
import it.businesslogic.ireport.gui.BandsDialog;
import it.businesslogic.ireport.gui.JNumberField;
import it.businesslogic.ireport.gui.JReportFrame;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.gui.event.ReportBandChangedEvent;
import it.businesslogic.ireport.gui.event.ReportBandsSelectionEvent;
import it.businesslogic.ireport.gui.event.ReportElementChangedEvent;
import it.businesslogic.ireport.gui.event.ReportElementsSelectionEvent;
import it.businesslogic.ireport.gui.event.ReportFrameActivatedEvent;
import it.businesslogic.ireport.gui.event.ReportFrameActivatedListener;
import it.businesslogic.ireport.gui.event.ReportListener;
import it.businesslogic.ireport.gui.event.ReportObjectsSelectionEvent;
import it.businesslogic.ireport.gui.event.SheetPropertyValueChangedEvent;
import it.businesslogic.ireport.gui.event.SubDatasetObjectChangedEvent;
import it.businesslogic.ireport.gui.sheet.CategorySheetPanel;
import it.businesslogic.ireport.gui.sheet.ExpressionSheetProperty;
import it.businesslogic.ireport.gui.sheet.SheetProperty;
import it.businesslogic.ireport.refactoring.ReportRefactor;
import it.businesslogic.ireport.util.I18n;
import it.businesslogic.ireport.util.LanguageChangedEvent;
import it.businesslogic.ireport.util.LanguageChangedListener;
import java.awt.Color;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComponent;

public class ReportBandSheetPanel
extends CategorySheetPanel
implements ReportListener,
LanguageChangedListener,
ReportFrameActivatedListener {
    private SheetProperty spHeight;
    private SheetProperty spSplitAllowed;
    private ExpressionSheetProperty spPrintWhenExpression;
    private SheetProperty spGroupName;
    private ExpressionSheetProperty spGroupExpression;
    private SheetProperty spGroupOnNewPage;
    private SheetProperty spGroupOnNewColumn;
    private SheetProperty spGroupResetPageNumber;
    private SheetProperty spGroupPrintHeaderOnEachPage;
    private SheetProperty spGroupMinHeightToStartOnNewPage;
    public static Color sharedDifferentValueLabelColor = Color.red.darker().darker();
    public static Color mandatoryPropertiesLabelColor = Color.blue;
    public static Color notMandatoryPropertiesLabelColor = Color.black;
    private JReportFrame jrf = null;
    private boolean init = false;
    private Vector bandSelection = new Vector();

    public ReportBandSheetPanel() {
        this.setBackground(Color.BLUE);
        this.initSheetProperties();
        MainFrame mf = MainFrame.getMainInstance();
        mf.addReportListener(this);
        mf.addReportFrameActivatedListener(this);
        I18n.addOnLanguageChangedListener(this);
    }

    public void reportFrameActivated(ReportFrameActivatedEvent evt) {
        if (MainFrame.getMainInstance().getActiveReportFrame() == this.getJrf()) {
            return;
        }
        this.updateSelection(MainFrame.getMainInstance().getActiveReportFrame());
    }

    public void languageChanged(LanguageChangedEvent evt) {
        this.removeAllProperties();
        this.initSheetProperties();
        this.updateSelection();
    }

    public void updateSelection() {
        JReportFrame newJrf = MainFrame.getMainInstance().getActiveReportFrame();
        this.updateSelection(newJrf);
    }

    public void applyValueForNumbers() {
        Enumeration e = this.getProperties().elements();
        while (e.hasMoreElements()) {
            JComponent c;
            SheetProperty sp = (SheetProperty)e.nextElement();
            if (sp.getType() != 6) {
                if (sp.getType() != 1) continue;
            }
            if (!(c = sp.getEditor()).hasFocus() || !(c instanceof JNumberField)) continue;
            ((JNumberField)c).focusLost(null);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSelection(JReportFrame newJrf) {
        if (newJrf != null && newJrf.getSelectedElements().size() > 0) {
            return;
        }
        this.applyValueForNumbers();
        if (newJrf == null) {
            this.setBandSelection(new Vector());
        } else {
            this.setBandSelection(newJrf.getSelectedBands());
        }
        this.setInit(true);
        this.removeAllProperties();
        this.jrf = newJrf;
        if (this.jrf == null || this.getBandSelection().size() == 0) {
            this.recreateSheet();
            return;
        }
        try {
            try {
                Vector selectedElements = this.getBandSelection();
                boolean sameHeight = true;
                boolean sameSplitAllowed = true;
                boolean samePrintWhenExpression = true;
                boolean isTheFirstElement = true;
                boolean sameIsGroup = true;
                boolean sameGroupName = true;
                boolean sameGroupExpression = true;
                boolean sameGroupOnNewPage = true;
                boolean sameGroupOnNewColumn = true;
                boolean sameGroupResetPageNumber = true;
                boolean sameGroupPrintHeaderOnEachPage = true;
                boolean sameGroupMinHeightToStartOnNewPage = true;
                for (int i = 0; i < selectedElements.size(); ++i) {
                    Band band = (Band)selectedElements.elementAt(i);
                    if (sameHeight) {
                        sameHeight = this.setElementNumber(isTheFirstElement, band.getHeight(), (JNumberField)this.spHeight.getEditor());
                    }
                    if (sameSplitAllowed) {
                        sameSplitAllowed = this.setCheckBox(isTheFirstElement, band.isSplitAllowed(), false, this.spSplitAllowed);
                    }
                    if (samePrintWhenExpression) {
                        samePrintWhenExpression = this.setTextArea(isTheFirstElement, band.getPrintWhenExpression(), this.spPrintWhenExpression);
                    }
                    if (sameIsGroup && (sameIsGroup &= band.getGroup() != null)) {
                        Group group = band.getGroup();
                        if (sameGroupExpression) {
                            sameGroupExpression = this.setTextArea(isTheFirstElement, group.getGroupExpression(), this.spGroupExpression);
                        }
                        if (sameGroupName) {
                            sameGroupName = this.setTextArea(isTheFirstElement, group.getName(), this.spGroupName);
                        }
                        if (sameGroupOnNewPage) {
                            sameGroupOnNewPage = this.setCheckBox(isTheFirstElement, group.isIsStartNewPage(), false, this.spGroupOnNewPage);
                        }
                        if (sameGroupOnNewColumn) {
                            sameGroupOnNewColumn = this.setCheckBox(isTheFirstElement, group.isIsStartNewColumn(), false, this.spGroupOnNewColumn);
                        }
                        if (sameGroupResetPageNumber) {
                            sameGroupResetPageNumber = this.setCheckBox(isTheFirstElement, group.isIsResetPageNumber(), false, this.spGroupResetPageNumber);
                        }
                        if (sameGroupPrintHeaderOnEachPage) {
                            sameGroupPrintHeaderOnEachPage = this.setCheckBox(isTheFirstElement, group.isIsReprintHeaderOnEachPage(), false, this.spGroupPrintHeaderOnEachPage);
                        }
                        if (sameGroupMinHeightToStartOnNewPage) {
                            sameGroupMinHeightToStartOnNewPage = this.setElementNumber(isTheFirstElement, group.getMinHeightToStartNewPage(), (JNumberField)this.spGroupMinHeightToStartOnNewPage.getEditor());
                        }
                    }
                    isTheFirstElement = false;
                }
                this.spHeight.setLabelColor(sameHeight ? notMandatoryPropertiesLabelColor : sharedDifferentValueLabelColor);
                ExpressionContext ec = new ExpressionContext();
                ec.setSubDataset(this.jrf.getReport());
                this.spPrintWhenExpression.setExpressionContext(ec);
                this.spPrintWhenExpression.setLabelError(null);
                this.spPrintWhenExpression.updateLabel();
                String commonStr = I18n.getString("bandProperties", "Band Properties");
                this.addSheetProperty(commonStr, this.spHeight);
                this.addSheetProperty(commonStr, this.spSplitAllowed);
                this.addSheetProperty(commonStr, this.spPrintWhenExpression);
                if (sameIsGroup) {
                    String groupStr = I18n.getString("groupProperties", "Group Properties");
                    this.addSheetProperty(groupStr, this.spGroupName);
                    this.addSheetProperty(groupStr, this.spGroupExpression);
                    this.addSheetProperty(groupStr, this.spGroupOnNewPage);
                    this.addSheetProperty(groupStr, this.spGroupOnNewColumn);
                    this.addSheetProperty(groupStr, this.spGroupResetPageNumber);
                    this.addSheetProperty(groupStr, this.spGroupPrintHeaderOnEachPage);
                    this.addSheetProperty(groupStr, this.spGroupMinHeightToStartOnNewPage);
                    this.spGroupExpression.setLabelError(null);
                    this.spGroupExpression.updateLabel();
                }
                this.spSplitAllowed.setDefaultValue(new Boolean(true));
                this.recreateSheet();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                Object var19_21 = null;
            }
            Object var19_20 = null;
        }
        catch (Throwable throwable) {
            Object var19_22 = null;
            throw throwable;
        }
        this.setInit(false);
    }

    public void sheetPropertyValueChanged(SheetPropertyValueChangedEvent evt) {
        Band band;
        int i;
        if (this.isInit()) {
            return;
        }
        Vector selectedElements = this.getBandSelection();
        Vector<Group> modified_groups = new Vector<Group>();
        Vector<Band> modified_bands = new Vector<Band>();
        for (i = 0; i < selectedElements.size(); ++i) {
            Group g;
            band = (Band)selectedElements.elementAt(i);
            if (this.applyNewBandProperty(band, evt.getPropertyName(), evt.getOldValue(), evt.getNewValue())) {
                modified_bands.add(band);
            }
            if (band.getGroup() == null || modified_groups.contains(g = band.getGroup())) continue;
            modified_groups.add(g);
            if (!this.applyNewGroupProperty(band, g, evt.getPropertyName(), evt.getOldValue(), evt.getNewValue())) continue;
            if (!modified_bands.contains(g.getGroupFooter())) {
                modified_bands.add(g.getGroupFooter());
            }
            if (modified_bands.contains(g.getGroupHeader())) continue;
            modified_bands.add(g.getGroupHeader());
        }
        for (i = 0; i < modified_bands.size(); ++i) {
            band = (Band)modified_bands.elementAt(i);
            this.getJrf().fireReportListenerReportBandChanged(new ReportBandChangedEvent(this.getJrf(), band, 3, this));
        }
        this.repaintEditor();
        this.getJrf().getReport().incrementReportChanges();
    }

    private boolean applyNewBandProperty(Band b, String propertyName, Object oldValue, Object newValue) {
        if (propertyName == null) {
            return false;
        }
        if (this.isInit()) {
            return false;
        }
        boolean fireEvent = true;
        if (propertyName.equals("height")) {
            if (newValue != null && !newValue.equals("")) {
                int val = Integer.parseInt("" + newValue);
                BandsDialog.updateBandHeight(this.getJrf().getReport(), b, val);
                int newHeight = b.getHeight();
                if (newHeight != val) {
                    boolean oldInit = this.isInit();
                    this.setInit(true);
                    this.spHeight.setValue("" + newHeight);
                    this.setInit(oldInit);
                }
            }
        } else if (propertyName.equals("splitAllowed")) {
            b.setSplitAllowed((Boolean)newValue);
        } else if (propertyName.equals("printWhenExpression")) {
            if (newValue != null) {
                b.setPrintWhenExpression("" + newValue);
            }
            ((SheetProperty)this.getSheetProperty(propertyName)).setLabelError(null);
            ((SheetProperty)this.getSheetProperty(propertyName)).updateLabel();
        }
        return fireEvent;
    }

    public void changeGroupName(Report report, SubDataset subDataset, Group group, String oldName) {
        JRVariable var;
        if (group.getName().equals(oldName)) {
            return;
        }
        group.getGroupHeader().setName(group.getName() + "Header");
        group.getGroupFooter().setName(group.getName() + "Footer");
        for (int k = subDataset.getVariables().size() - 1; k >= 0; --k) {
            var = (JRVariable)subDataset.getVariables().elementAt(k);
            if (!var.isBuiltin() || !var.getName().equalsIgnoreCase(oldName + "_COUNT")) continue;
            JRVariable oldVar = var.cloneMe();
            var.setName(group.getName() + "_COUNT");
            subDataset.fireSubDatasetObjectChangedListenerSubDatasetObjectChanged(new SubDatasetObjectChangedEvent(subDataset, 1, 1, oldVar, var));
            break;
        }
        Enumeration e = subDataset.getVariables().elements();
        while (e.hasMoreElements()) {
            var = (JRVariable)e.nextElement();
            if (var.getResetGroup() == null || !var.getResetGroup().equals(oldName)) continue;
            var.setResetGroup(group.getName());
        }
        if (subDataset instanceof Report) {
            e = ((Report)subDataset).getElements().elements();
            while (e.hasMoreElements()) {
                ReportElement re = (ReportElement)e.nextElement();
                if (re.printWhenGroupChanges.equals(oldName)) {
                    re.printWhenGroupChanges = group.getName();
                }
                if (re instanceof TextFieldReportElement && ((TextFieldReportElement)re).getGroup().equals(oldName)) {
                    ((TextFieldReportElement)re).setGroup(group.getName());
                }
                if (re instanceof ImageReportElement && ((ImageReportElement)re).getEvaluationGroup().equals(oldName)) {
                    ((ImageReportElement)re).setEvaluationGroup(group.getName());
                }
                if (!(re instanceof ChartReportElement) || !((ChartReportElement)re).getEvaluationGroup().equals(oldName)) continue;
                ((ChartReportElement)re).setEvaluationGroup(group.getName());
            }
        }
        ReportRefactor.replaceInReportExpressions("$V{" + oldName + "_COUNT}", "$V{" + group.getName() + "_COUNT}", subDataset, report);
    }

    public static boolean isValidGroupName(SubDataset report, Group group, String newName) {
        if (newName.equals("page")) {
            return false;
        }
        if (newName.equals("column")) {
            return false;
        }
        if (newName.equals("lastPage")) {
            return false;
        }
        for (int i = 0; i < report.getGroups().size(); ++i) {
            Group tmpGroup = (Group)report.getGroups().get(i);
            if (tmpGroup == group || !tmpGroup.getName().equals(newName)) continue;
            return false;
        }
        return true;
    }

    private boolean applyNewGroupProperty(Band band, Group group, String propertyName, Object oldValue, Object newValue) {
        if (propertyName == null) {
            return false;
        }
        if (this.isInit()) {
            return false;
        }
        boolean needBandChangedEvent = false;
        if (propertyName.equals("groupName")) {
            String oldName = group.getName();
            if (newValue == null || !ReportBandSheetPanel.isValidGroupName(this.getJrf().getReport(), group, "" + newValue)) {
                ((SheetProperty)this.getSheetProperty(propertyName)).setLabelError(I18n.getString("messages.invalidGroupName", "Invalid group name!"));
                ((SheetProperty)this.getSheetProperty(propertyName)).updateLabel();
            } else {
                ((SheetProperty)this.getSheetProperty(propertyName)).setLabelError(null);
                ((SheetProperty)this.getSheetProperty(propertyName)).updateLabel();
                String newName = ("" + newValue).trim();
                group.setName(newName);
                this.changeGroupName(this.getJrf().getReport(), this.getJrf().getReport(), group, oldName);
                needBandChangedEvent = true;
                boolean oldInit = this.isInit();
                this.setInit(true);
                this.spPrintWhenExpression.setValue("" + band.getPrintWhenExpression());
                this.spGroupExpression.setValue("" + group.getGroupExpression());
                this.setInit(oldInit);
            }
        } else if (propertyName.equals("groupExpression")) {
            if (newValue != null) {
                group.setGroupExpression("" + newValue);
            }
            ((SheetProperty)this.getSheetProperty(propertyName)).setLabelError(null);
            ((SheetProperty)this.getSheetProperty(propertyName)).updateLabel();
        } else if (propertyName.equals("groupStartOnNewPage")) {
            group.setIsStartNewPage((Boolean)newValue);
        } else if (propertyName.equals("groupStartOnNewColumn")) {
            group.setIsStartNewColumn((Boolean)newValue);
        } else if (propertyName.equals("groupResetPageNumber")) {
            group.setIsResetPageNumber((Boolean)newValue);
        } else if (propertyName.equals("groupPrintHeaderOnEachPage")) {
            group.setIsReprintHeaderOnEachPage((Boolean)newValue);
        } else if (propertyName.equals("groupMinHeightToStartOnNewPage") && newValue != null && !newValue.equals("")) {
            int val = 0;
            try {
                int newHeight = val = Integer.parseInt("" + newValue);
                if (val < 0) {
                    newHeight = 0;
                }
                int maxH = this.getJrf().getReport().getHeight() - this.getJrf().getReport().getTopMargin() + this.getJrf().getReport().getBottomMargin();
                maxH -= this.getJrf().getReport().getBandByName("pageHeader").getHeight();
                if (val > (maxH -= this.getJrf().getReport().getBandByName("pageFooter").getHeight())) {
                    newHeight = maxH;
                }
                if (newHeight != val) {
                    boolean oldInit = this.isInit();
                    this.setInit(true);
                    this.spGroupMinHeightToStartOnNewPage.setValue("" + newHeight);
                    this.setInit(oldInit);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return needBandChangedEvent;
    }

    public void reportBandChanged(ReportBandChangedEvent evt) {
        if (evt.getSource() != null && evt.getSource() == this) {
            return;
        }
        this.updateSelection();
    }

    protected void initSheetProperties() {
        this.spHeight = new SheetProperty("height", I18n.getString("gui.elementpropertiessheet.height", "Height"), 6);
        this.spHeight.setShowResetButton(false);
        this.spSplitAllowed = new SheetProperty("splitAllowed", I18n.getString("gui.bandpropertiessheet.splitAllowed", "Is split allowed"), 4);
        this.spSplitAllowed.setShowResetButton(false);
        this.spPrintWhenExpression = new ExpressionSheetProperty("printWhenExpression", I18n.getString("gui.elementpropertiessheet.printWhenExpression", "Print When Expression"));
        this.spPrintWhenExpression.setShowResetButton(false);
        this.spGroupExpression = new ExpressionSheetProperty("groupExpression", I18n.getString("jRGroupDialog.label3", "Group expression"));
        this.spGroupExpression.setShowResetButton(false);
        this.spGroupName = new SheetProperty("groupName", I18n.getString("jRGroupDialog.label1", "Group name"), 8);
        this.spGroupName.setShowResetButton(false);
        this.spGroupOnNewPage = new SheetProperty("groupStartOnNewPage", I18n.getString("jRGroupDialog.checkBoxStartNewPage", "Start on a new page"), 4);
        this.spGroupOnNewPage.setShowResetButton(false);
        this.spGroupOnNewColumn = new SheetProperty("groupStartOnNewColumn", I18n.getString("jRGroupDialog.checkBoxStartNewColumn", "Start on a new column"), 4);
        this.spGroupOnNewColumn.setShowResetButton(false);
        this.spGroupResetPageNumber = new SheetProperty("groupResetPageNumber", I18n.getString("jRGroupDialog.checkBoxResetPageNumber", "Reset page number"), 4);
        this.spGroupResetPageNumber.setShowResetButton(false);
        this.spGroupPrintHeaderOnEachPage = new SheetProperty("groupPrintHeaderOnEachPage", I18n.getString("jRGroupDialog.checkBoxPrintHeaderEachPage", "Print header on each page"), 4);
        this.spGroupPrintHeaderOnEachPage.setShowResetButton(false);
        this.spGroupMinHeightToStartOnNewPage = new SheetProperty("groupMinHeightToStartOnNewPage", I18n.getString("jRGroupDialog.label5", "Min height to start new page"), 6);
        this.spGroupMinHeightToStartOnNewPage.setShowResetButton(false);
    }

    public boolean isInit() {
        return this.init;
    }

    public void setInit(boolean init) {
        this.init = init;
    }

    public JReportFrame getJrf() {
        return this.jrf;
    }

    public void setJrf(JReportFrame jrf) {
        this.jrf = jrf;
    }

    public void repaintEditor() {
        if (this.jrf == null) {
            return;
        }
        this.jrf.getJPanelReport().repaint();
    }

    public Vector getBandSelection() {
        return this.bandSelection;
    }

    public void setBandSelection(Vector newBandSelection) {
        this.bandSelection.removeAllElements();
        if (newBandSelection == null) {
            return;
        }
        this.bandSelection.addAll(newBandSelection);
    }

    public void reportElementsSelectionChanged(ReportElementsSelectionEvent evt) {
    }

    public void reportElementsChanged(ReportElementChangedEvent evt) {
    }

    public void reportBandsSelectionChanged(ReportBandsSelectionEvent evt) {
        this.updateSelection();
    }

    public void reportObjectsSelectionChanged(ReportObjectsSelectionEvent evt) {
    }
}

