/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui.export;

import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.gui.sheet.CategorySheetPanel;
import it.businesslogic.ireport.gui.sheet.ComboBoxSheetProperty;
import it.businesslogic.ireport.gui.sheet.SheetProperty;
import it.businesslogic.ireport.gui.sheet.Tag;
import it.businesslogic.ireport.util.I18n;
import it.businesslogic.ireport.util.Misc;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public class ExportPreferencesDialog
extends JDialog {
    private CategorySheetPanel categorySheetPanel = null;
    private Properties defaultValues = null;
    private JButton jButtonCancel;
    private JButton jButtonSave;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private Object I18;

    public ExportPreferencesDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.applyI18n();
        this.categorySheetPanel = new CategorySheetPanel();
        this.defaultValues = new Properties();
        this.categorySheetPanel.addSheetProperty(I18n.getString("elementPropertiesDialog.tab.Common", "Common"), new SheetProperty("CHARACTER_ENCODING", I18n.getString("reportOptions.Encoding", "Character encoding"), 0));
        this.defaultValues.setProperty("CHARACTER_ENCODING", "");
        this.categorySheetPanel.addSheetProperty(I18n.getString("elementPropertiesDialog.tab.Common", "Common"), new SheetProperty("OFFSET_X", I18n.getString("reportOptions.offsetX", "Offset X"), 6));
        this.defaultValues.setProperty("OFFSET_X", "0");
        this.categorySheetPanel.addSheetProperty(I18n.getString("elementPropertiesDialog.tab.Common", "Common"), new SheetProperty("OFFSET_Y", I18n.getString("reportOptions.offsetY", "Offset Y"), 6));
        this.defaultValues.setProperty("OFFSET_Y", "0");
        this.categorySheetPanel.addSheetProperty("PDF Exporter", new SheetProperty("PDF_IS_ENCRYPTED", I18n.getString("isEncrypted", "Is Encrypted"), 4));
        this.defaultValues.setProperty("PDF_IS_ENCRYPTED", "false");
        this.categorySheetPanel.addSheetProperty("PDF Exporter", new SheetProperty("PDF_IS_128_BIT_KEY", I18n.getString("is128BitKey", "Is 128 Bit Key"), 4));
        this.defaultValues.setProperty("PDF_IS_128_BIT_KEY", "false");
        this.categorySheetPanel.addSheetProperty("PDF Exporter", new SheetProperty("PDF_USER_PASSWORD", I18n.getString("userPassword", "User Password"), 7));
        this.defaultValues.setProperty("PDF_USER_PASSWORD", "");
        this.categorySheetPanel.addSheetProperty("PDF Exporter", new SheetProperty("PDF_OWNER_PASSWORD", I18n.getString("ownerPassword", "Owner Password"), 7));
        this.defaultValues.setProperty("PDF_OWNER_PASSWORD", "");
        this.categorySheetPanel.addSheetProperty("PDF Exporter", new SheetProperty("PDF_PERMISSIONS", I18n.getString("permissions", "Permissions"), 6));
        this.defaultValues.setProperty("PDF_PERMISSIONS", "0");
        this.categorySheetPanel.addSheetProperty("PDF Exporter", new SheetProperty("net.sf.jasperreports.export.pdf.compressed", I18n.getString("isCompressed", "Is Compressed"), 4));
        this.defaultValues.setProperty("net.sf.jasperreports.export.pdf.compressed", "false");
        this.categorySheetPanel.addSheetProperty("PDF Exporter", new SheetProperty("net.sf.jasperreports.export.pdf.create.batch.mode.bookmarks", I18n.getString("isCreatingBatchModeBookmarks", "Is Creating Batch Mode Bookmarks"), 4));
        this.defaultValues.setProperty("net.sf.jasperreports.export.pdf.create.batch.mode.bookmarks", "false");
        ComboBoxSheetProperty combo = new ComboBoxSheetProperty("net.sf.jasperreports.export.pdf.version", I18n.getString("pdfVersion", "Pdf version"));
        Vector<Tag> tags = new Vector<Tag>();
        tags.add(new Tag("", "Default"));
        tags.add(new Tag("2", "Version 2"));
        tags.add(new Tag("3", "Version 3"));
        tags.add(new Tag("4", "Version 4"));
        tags.add(new Tag("5", "Version 5"));
        tags.add(new Tag("6", "Version 6"));
        combo.setTags(tags);
        this.categorySheetPanel.addSheetProperty("PDF Exporter", combo);
        this.defaultValues.setProperty("net.sf.jasperreports.export.pdf.version", "");
        this.categorySheetPanel.addSheetProperty("PDF Exporter", new SheetProperty("METADATA_TITLE", I18n.getString("metadataTitle", "Metadata Title"), 0));
        this.defaultValues.setProperty("METADATA_TITLE", "");
        this.categorySheetPanel.addSheetProperty("PDF Exporter", new SheetProperty("METADATA_AUTHOR", I18n.getString("metadataAuthor", "Metadata Author"), 0));
        this.defaultValues.setProperty("METADATA_AUTHOR", "");
        this.categorySheetPanel.addSheetProperty("PDF Exporter", new SheetProperty("METADATA_SUBJECT", I18n.getString("metadataSubject", "Metadata Subject"), 0));
        this.defaultValues.setProperty("METADATA_SUBJECT", "");
        this.categorySheetPanel.addSheetProperty("PDF Exporter", new SheetProperty("METADATA_KEYWORDS", I18n.getString("metadataKeywords", "Metadata Keywords"), 0));
        this.defaultValues.setProperty("METADATA_KEYWORDS", "");
        this.categorySheetPanel.addSheetProperty("PDF Exporter", new SheetProperty("METADATA_CREATOR", I18n.getString("metadataCreator", "Metadata Creator"), 0));
        this.defaultValues.setProperty("METADATA_CREATOR", "");
        this.categorySheetPanel.addSheetProperty("PDF Exporter", new SheetProperty("net.sf.jasperreports.export.pdf.force.linebreak.policy", I18n.getString("forceLinebreakPolicy", "Force linebreak policy"), 0));
        this.defaultValues.setProperty("net.sf.jasperreports.export.pdf.force.linebreak.policy", "");
        this.categorySheetPanel.addSheetProperty("PDF Exporter", new SheetProperty("net.sf.jasperreports.export.pdf.force.svg.shapes", I18n.getString("forceSVGShapes", "Force SVG Shapes"), 4));
        this.defaultValues.setProperty("net.sf.jasperreports.export.pdf.force.svg.shapes", "true");
        this.categorySheetPanel.addSheetProperty("PDF Exporter", new SheetProperty("net.sf.jasperreports.export.pdf.javascript", I18n.getString("PDFJavaScript", "PDF JavaScript"), 0));
        this.defaultValues.setProperty("net.sf.jasperreports.export.pdf.javascript", "");
        this.categorySheetPanel.addSheetProperty("HTML Exporter", new SheetProperty("HTML_IMAGES_MAP", "Images Map Object", 0));
        this.defaultValues.setProperty("HTML_IMAGES_MAP", "");
        ((SheetProperty)this.categorySheetPanel.getSheetProperty("HTML_IMAGES_MAP")).setReadOnly(true);
        this.categorySheetPanel.addSheetProperty("HTML Exporter", new SheetProperty("HTML_IMAGES_DIR", "Images Directory", 0));
        this.defaultValues.setProperty("HTML_IMAGES_DIR", "");
        ((SheetProperty)this.categorySheetPanel.getSheetProperty("HTML_IMAGES_DIR")).setReadOnly(true);
        this.categorySheetPanel.addSheetProperty("HTML Exporter", new SheetProperty("HTML_IMAGES_DIR_NAME", "Images Directory Name", 0));
        this.defaultValues.setProperty("HTML_IMAGES_DIR_NAME", "");
        this.categorySheetPanel.addSheetProperty("HTML Exporter", new SheetProperty("HTML_IS_OUTPUT_IMAGES_TO_DIR", "Is Output Images to Directory Flag", 4));
        this.defaultValues.setProperty("HTML_IS_OUTPUT_IMAGES_TO_DIR", "false");
        this.categorySheetPanel.addSheetProperty("HTML Exporter", new SheetProperty("HTML_IMAGES_URI", "Images URI", 0));
        this.defaultValues.setProperty("HTML_IMAGES_URI", "");
        this.categorySheetPanel.addSheetProperty("HTML Exporter", new SheetProperty("HTML_HTML_HEADER", "HTML Header", 0));
        this.defaultValues.setProperty("HTML_HTML_HEADER", "");
        this.categorySheetPanel.addSheetProperty("HTML Exporter", new SheetProperty("HTML_BETWEEN_PAGES_HTML", "Between Pages HTML", 0));
        this.defaultValues.setProperty("HTML_BETWEEN_PAGES_HTML", "");
        this.categorySheetPanel.addSheetProperty("HTML Exporter", new SheetProperty("HTML_HTML_FOOTER", "HTML Footer", 0));
        this.defaultValues.setProperty("HTML_HTML_FOOTER", "");
        this.categorySheetPanel.addSheetProperty("HTML Exporter", new SheetProperty("HTML_IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS", "Is Remove Empty Space Between Rows", 4));
        this.defaultValues.setProperty("HTML_IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS", "false");
        this.categorySheetPanel.addSheetProperty("HTML Exporter", new SheetProperty("HTML_IS_WHITE_PAGE_BACKGROUND", "Is White Page Background", 4));
        this.defaultValues.setProperty("HTML_IS_WHITE_PAGE_BACKGROUND", "ture");
        this.categorySheetPanel.addSheetProperty("HTML Exporter", new SheetProperty("HTML_IS_USING_IMAGES_TO_ALIGN", "Is Using Images To Align", 4));
        this.defaultValues.setProperty("HTML_IS_USING_IMAGES_TO_ALIGN", "true");
        this.categorySheetPanel.addSheetProperty("HTML Exporter", new SheetProperty("net.sf.jasperreports.export.html.wrap.break.word", "Is Wrap Break Word", 0));
        this.defaultValues.setProperty("net.sf.jasperreports.export.html.wrap.break.word", "");
        this.categorySheetPanel.addSheetProperty("HTML Exporter", new SheetProperty("net.sf.jasperreports.export.html.size.unit", "Size Unit", 0));
        this.defaultValues.setProperty("net.sf.jasperreports.export.html.size.unit", "px");
        this.categorySheetPanel.addSheetProperty("HTML Exporter", new SheetProperty("net.sf.jasperreports.export.html.frames.as.nested.tables", "Export frames as nested tables", 4));
        this.defaultValues.setProperty("net.sf.jasperreports.export.html.frames.as.nested.tables", "true");
        this.categorySheetPanel.addSheetProperty("XLS Exporter", new SheetProperty("XLS_IS_ONE_PAGE_PER_SHEET", "Is One Page per Sheet", 4));
        this.defaultValues.setProperty("XLS_IS_ONE_PAGE_PER_SHEET", "false");
        this.categorySheetPanel.addSheetProperty("XLS Exporter", new SheetProperty("XLS_IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS", "Is Remove Empty Space Between Rows", 4));
        this.defaultValues.setProperty("XLS_IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS", "false");
        this.categorySheetPanel.addSheetProperty("XLS Exporter", new SheetProperty("XLS_IS_REMOVE_EMPTY_SPACE_BETWEEN_COLUMNS", "Is Remove Empty Space Between Columns", 4));
        this.defaultValues.setProperty("XLS_IS_REMOVE_EMPTY_SPACE_BETWEEN_COLUMNS", "false");
        this.categorySheetPanel.addSheetProperty("XLS Exporter", new SheetProperty("XLS_IS_WHITE_PAGE_BACKGROUND", "Is White Page Background", 4));
        this.defaultValues.setProperty("XLS_IS_WHITE_PAGE_BACKGROUND", "true");
        this.categorySheetPanel.addSheetProperty("XLS Exporter", new SheetProperty("XLS_IS_AUTO_DETECT_CELL_TYPE", "Auto Detect Cell Type (deprecated)", 4));
        this.defaultValues.setProperty("XLS_IS_AUTO_DETECT_CELL_TYPE", "false");
        this.categorySheetPanel.addSheetProperty("XLS Exporter", new SheetProperty("net.sf.jasperreports.export.xls.detect.cell.type", "Detect Cell Type (New)", 4));
        this.defaultValues.setProperty("net.sf.jasperreports.export.xls.detect.cell.type", "false");
        this.categorySheetPanel.addSheetProperty("XLS Exporter", new SheetProperty("net.sf.jasperreports.export.xls.create.custom.palette", "Create Custom Palette", 4));
        this.defaultValues.setProperty("net.sf.jasperreports.export.xls.create.custom.palette", "true");
        this.categorySheetPanel.addSheetProperty("XLS Exporter", new SheetProperty("net.sf.jasperreports.export.xls.create.custom.palette", "Create Custom Palette", 4));
        this.defaultValues.setProperty("net.sf.jasperreports.export.xls.font.size.fix.enabled", "false");
        this.categorySheetPanel.addSheetProperty("XLS Exporter", new SheetProperty("net.sf.jasperreports.export.xls.max.rows.per.sheet", "Maximum Rows Per Sheet", 6));
        this.defaultValues.setProperty("net.sf.jasperreports.export.xls.max.rows.per.sheet", "0");
        this.categorySheetPanel.addSheetProperty("XLS Exporter", new SheetProperty("net.sf.jasperreports.export.xls.ignore.graphics", "Is Ignore Graphics", 4));
        this.defaultValues.setProperty("net.sf.jasperreports.export.xls.ignore.graphics", "false");
        this.categorySheetPanel.addSheetProperty("XLS Exporter", new SheetProperty("net.sf.jasperreports.export.xls.collapse.row.span", "Is Collapse Row Span", 4));
        this.defaultValues.setProperty("net.sf.jasperreports.export.xls.collapse.row.span", "false");
        this.categorySheetPanel.addSheetProperty("XLS Exporter", new SheetProperty("net.sf.jasperreports.export.xls.ignore.cell.border", "Is Ignore Cell Border", 4));
        this.defaultValues.setProperty("net.sf.jasperreports.export.xls.ignore.cell.border", "false");
        this.categorySheetPanel.addSheetProperty("XML Exporter", new SheetProperty("XML_IS_EMBEDDING_IMAGES", "Is Embedding Images Flag", 4));
        this.defaultValues.setProperty("XML_IS_EMBEDDING_IMAGES", "true");
        this.categorySheetPanel.addSheetProperty("XML Exporter", new SheetProperty("XML_DTD_LOCATION", "DTD Location", 0));
        this.defaultValues.setProperty("XML_DTD_LOCATION", "");
        this.categorySheetPanel.addSheetProperty("Text Exporter", new SheetProperty("TXT_PAGE_ROWS", "Rows per page", 6));
        this.defaultValues.setProperty("TXT_PAGE_ROWS", "61");
        this.categorySheetPanel.addSheetProperty("Text Exporter", new SheetProperty("TXT_PAGE_COLUMNS", "Columns per page", 6));
        this.defaultValues.setProperty("TXT_PAGE_COLUMNS", "255");
        this.categorySheetPanel.addSheetProperty("Text Exporter", new SheetProperty("TXT_ADD_FORM_FEED", "Add FORM FEED", 4));
        this.defaultValues.setProperty("TXT_ADD_FORM_FEED", "true");
        this.categorySheetPanel.addSheetProperty("Text Exporter", new SheetProperty("TXT_DISPLAY_WIDTH_PROVIDER_FACTORY", "Display Width Provider Factory calss", 0));
        this.defaultValues.setProperty("TXT_DISPLAY_WIDTH_PROVIDER_FACTORY", "");
        this.categorySheetPanel.addSheetProperty("CSV Exporter", new SheetProperty("CSV_FIELD_DELIMITER", "Field Delimiter", 0));
        this.defaultValues.setProperty("CSV_RECORD_DELIMITER", ",");
        this.categorySheetPanel.addSheetProperty("CSV Exporter", new SheetProperty("net.sf.jasperreports.export.csv.record.delimiter", "Record Delimiter", 0));
        this.defaultValues.setProperty("net.sf.jasperreports.export.csv.record.delimiter", "\n");
        this.categorySheetPanel.addSheetProperty("JR Text Exporter", new SheetProperty("JRTXT_CHARACTER_WIDTH", "Character Width", 6));
        this.defaultValues.setProperty("JRTXT_CHARACTER_WIDTH", "10");
        this.categorySheetPanel.addSheetProperty("JR Text Exporter", new SheetProperty("JRTXT_CHARACTER_HEIGHT", "Character Height", 6));
        this.defaultValues.setProperty("JRTXT_CHARACTER_HEIGHT", "20");
        this.categorySheetPanel.addSheetProperty("JR Text Exporter", new SheetProperty("JRTXT_PAGE_WIDTH", "Page Width", 6));
        this.defaultValues.setProperty("JRTXT_PAGE_WIDTH", "225");
        this.categorySheetPanel.addSheetProperty("JR Text Exporter", new SheetProperty("JRTXT_PAGE_HEIGHT", "Page Height", 6));
        this.defaultValues.setProperty("JRTXT_PAGE_HEIGHT", "61");
        this.categorySheetPanel.addSheetProperty("JR Text Exporter", new SheetProperty("JRTXT_BETWEEN_PAGES_TEXT", "Between Pages Text", 0));
        this.defaultValues.setProperty("JRTXT_BETWEEN_PAGES_TEXT", "\n\n");
        this.jPanel1.add("Center", this.categorySheetPanel);
        this.categorySheetPanel.setShowResetButton(false);
        ((SheetProperty)this.categorySheetPanel.getSheetProperty("HTML_IMAGES_DIR_NAME")).setShowResetButton(true);
        this.categorySheetPanel.recreateSheet();
        this.loadConfiguration();
        Misc.centerFrame(this);
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                ExportPreferencesDialog.this.jButtonCancelActionPerformed(e);
            }
        };
        this.getRootPane().getInputMap(2).put(escape, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", escapeAction);
        this.getRootPane().setDefaultButton(this.jButtonSave);
    }

    public void loadConfiguration() {
        Properties props = MainFrame.getMainInstance().getProperties();
        Enumeration p_props = this.categorySheetPanel.getProperties().elements();
        while (p_props.hasMoreElements()) {
            SheetProperty sp = (SheetProperty)p_props.nextElement();
            String property_name = sp.getKeyName();
            if (props.getProperty(property_name) != null) {
                sp.setValue(props.getProperty(property_name));
                continue;
            }
            if (this.defaultValues.getProperty(property_name) == null) continue;
            sp.setValue(this.defaultValues.getProperty(property_name));
        }
    }

    public void saveConfiguration() {
        Properties props = MainFrame.getMainInstance().getProperties();
        Enumeration p_props = this.categorySheetPanel.getProperties().elements();
        while (p_props.hasMoreElements()) {
            SheetProperty sp = (SheetProperty)p_props.nextElement();
            String property_name = sp.getKeyName();
            if (sp.getValue() != null && (sp.getValue() + "").length() > 0) {
                props.setProperty(property_name, sp.getValue() + "");
                continue;
            }
            props.remove(property_name);
        }
        MainFrame.getMainInstance().saveiReportConfiguration();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jPanel3 = new JPanel();
        this.jButtonSave = new JButton();
        this.jButtonCancel = new JButton();
        this.setDefaultCloseOperation(2);
        this.jPanel1.setLayout(new BorderLayout());
        this.jPanel1.setMinimumSize(new Dimension(100, 100));
        this.jPanel1.setPreferredSize(new Dimension(400, 400));
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.jPanel2.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        this.jPanel2.add((Component)this.jPanel3, gridBagConstraints);
        this.jButtonSave.setText("Save");
        this.jButtonSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExportPreferencesDialog.this.jButtonSaveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(4, 4, 4, 0);
        this.jPanel2.add((Component)this.jButtonSave, gridBagConstraints);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExportPreferencesDialog.this.jButtonCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel2.add((Component)this.jButtonCancel, gridBagConstraints);
        this.getContentPane().add((Component)this.jPanel2, "South");
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void jButtonSaveActionPerformed(ActionEvent evt) {
        this.saveConfiguration();
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new ExportPreferencesDialog((Frame)new JFrame(), true).setVisible(true);
            }
        });
    }

    public CategorySheetPanel getCategorySheetPanel() {
        return this.categorySheetPanel;
    }

    public void setCategorySheetPanel(CategorySheetPanel categorySheetPanel) {
        this.categorySheetPanel = categorySheetPanel;
    }

    public JButton getJButtonCancel() {
        return this.jButtonCancel;
    }

    public void setJButtonCancel(JButton jButtonCancel) {
        this.jButtonCancel = jButtonCancel;
    }

    public JButton getJButtonSave() {
        return this.jButtonSave;
    }

    public void setJButtonSave(JButton jButtonSave) {
        this.jButtonSave = jButtonSave;
    }

    public JPanel getJPanel1() {
        return this.jPanel1;
    }

    public void setJPanel1(JPanel jPanel1) {
        this.jPanel1 = jPanel1;
    }

    public JPanel getJPanel2() {
        return this.jPanel2;
    }

    public void setJPanel2(JPanel jPanel2) {
        this.jPanel2 = jPanel2;
    }

    public JPanel getJPanel3() {
        return this.jPanel3;
    }

    public void setJPanel3(JPanel jPanel3) {
        this.jPanel3 = jPanel3;
    }

    public void applyI18n() {
        this.jButtonCancel.setText(I18n.getString("exportPreferencesDialog.buttonCancel", "Cancel"));
        this.jButtonSave.setText(I18n.getString("exportPreferencesDialog.buttonSave", "Save"));
        this.jButtonCancel.setMnemonic(I18n.getString("exportPreferencesDialog.buttonCancelMnemonic", "c").charAt(0));
        this.jButtonSave.setMnemonic(I18n.getString("exportPreferencesDialog.buttonSaveMnemonic", "s").charAt(0));
    }
}

