/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui.box;

import it.businesslogic.ireport.Box;
import it.businesslogic.ireport.Pen;
import it.businesslogic.ireport.gui.box.BorderSelectionListener;
import it.businesslogic.ireport.gui.box.BoxBorderSelectionPanel;
import it.businesslogic.ireport.gui.box.LineStyleListCellRenderer;
import it.businesslogic.ireport.gui.sheet.ColorSelectorPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BoxBorderEditorPanel
extends JPanel
implements BorderSelectionListener {
    private BoxBorderSelectionPanel selectionPanel = null;
    private Box box = null;
    private SpinnerNumberModel spinnedModel = null;
    private DefaultListModel styleListModel = null;
    private ColorSelectorPanel colorSelector = null;
    private List<ActionListener> listeners = new ArrayList<ActionListener>();
    private boolean init = false;
    private JButton jButton1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JList jList1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel4;
    private JPanel jPanelColorSelector;
    private JPanel jPanelPreview;
    private JScrollPane jScrollPane1;
    private JSpinner jSpinnerLineWidth;

    public void addActionPerformedListener(ActionListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeActionPerformedListener(ActionListener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    private void fireActionPerformed() {
        ActionEvent evt = new ActionEvent(this, 0, "pen");
        for (ActionListener listener : this.listeners) {
            listener.actionPerformed(evt);
        }
    }

    public BoxBorderEditorPanel() {
        this.initComponents();
        this.selectionPanel = new BoxBorderSelectionPanel();
        this.selectionPanel.addBorderSelectionListener(this);
        this.jPanelPreview.add((Component)this.selectionPanel, "Center");
        this.colorSelector = new ColorSelectorPanel();
        this.jPanelColorSelector.add((Component)this.colorSelector, "Center");
        this.colorSelector.setColor(null);
        this.colorSelector.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BoxBorderEditorPanel.this.colorChanged();
            }
        });
        this.spinnedModel = new SpinnerNumberModel(1.0, 0.0, 100.0, 0.25);
        this.jSpinnerLineWidth.setModel(this.spinnedModel);
        this.spinnedModel.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                BoxBorderEditorPanel.this.widthChanged();
            }
        });
        this.jSpinnerLineWidth.setFont(UIManager.getFont("TextField.font"));
        this.jList1.setCellRenderer(new LineStyleListCellRenderer());
        this.styleListModel = new DefaultListModel();
        this.jList1.setModel(this.styleListModel);
        this.styleListModel.addElement("Solid");
        this.styleListModel.addElement("Dashed");
        this.styleListModel.addElement("Dotted");
        this.styleListModel.addElement("Double");
        this.jList1.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                BoxBorderEditorPanel.this.lineStyleChanged();
            }
        });
    }

    @Override
    public void selectionChanged(List<BoxBorderSelectionPanel.Side> selectedBorders) {
        if (this.isInit() || this.box == null) {
            return;
        }
        this.setInit(true);
        boolean sameWidth = true;
        boolean sameStyle = true;
        boolean sameColor = true;
        boolean first = true;
        this.spinnedModel.setValue(0.0);
        this.colorSelector.setColor(null);
        this.jList1.clearSelection();
        if (selectedBorders.size() == 0 && this.getBox() != null && this.getBox().getPen() != null) {
            Pen pen = this.getBox().getPen();
            this.spinnedModel.setValue(Float.valueOf(pen.getLineWidth()));
            this.colorSelector.setColor(pen.getLineColor());
            if (pen.getLineStyle() != null) {
                this.jList1.setSelectedValue(pen.getLineStyle(), true);
            }
        }
        for (BoxBorderSelectionPanel.Side s : selectedBorders) {
            Pen pen = null;
            if (this.getBox() != null) {
                switch (s) {
                    case TOP: {
                        pen = this.getBox().getTopPen();
                        break;
                    }
                    case BOTTOM: {
                        pen = this.getBox().getBottomPen();
                        break;
                    }
                    case RIGHT: {
                        pen = this.getBox().getRightPen();
                        break;
                    }
                    case LEFT: {
                        pen = this.getBox().getLeftPen();
                    }
                }
            }
            if (pen == null) continue;
            if (first) {
                this.spinnedModel.setValue(Float.valueOf(pen.getLineWidth()));
                this.colorSelector.setColor(pen.getLineColor());
                if (pen.getLineStyle() != null) {
                    this.jList1.setSelectedValue(pen.getLineStyle(), true);
                }
            } else {
                if (sameWidth && pen.getLineWidth() != this.spinnedModel.getNumber().floatValue()) {
                    sameWidth = false;
                }
                if (sameColor && (pen.getLineColor() == null || !pen.getLineColor().equals(this.colorSelector.getColor()))) {
                    sameColor = false;
                    this.colorSelector.setColor(null);
                }
                if (sameStyle) {
                    String ss = this.jList1.getSelectedValue() + "";
                    if (pen.getLineStyle() == null || !pen.getLineStyle().equals(ss)) {
                        sameStyle = false;
                        this.jList1.clearSelection();
                    }
                }
            }
            first = false;
        }
        this.setInit(false);
    }

    public void widthChanged() {
        if (this.isInit() || this.box == null) {
            return;
        }
        ArrayList<BoxBorderSelectionPanel.Side> borders = new ArrayList<BoxBorderSelectionPanel.Side>();
        borders.addAll(this.selectionPanel.getSelectedBorders());
        if (borders.size() == 0) {
            if (this.box.getPen() == null) {
                this.box.setPen(new Pen());
            }
            Pen pen = this.box.getPen();
            pen.setLineWidth(this.spinnedModel.getNumber().floatValue());
            borders.add(BoxBorderSelectionPanel.Side.TOP);
            borders.add(BoxBorderSelectionPanel.Side.BOTTOM);
            borders.add(BoxBorderSelectionPanel.Side.LEFT);
            borders.add(BoxBorderSelectionPanel.Side.RIGHT);
        }
        for (BoxBorderSelectionPanel.Side s : borders) {
            switch (s) {
                case TOP: {
                    if (this.box.getTopPen() == null) {
                        this.box.setTopPen(new Pen());
                    }
                    Pen pen = this.box.getTopPen();
                    pen.setLineWidth(this.spinnedModel.getNumber().floatValue());
                    break;
                }
                case LEFT: {
                    if (this.box.getLeftPen() == null) {
                        this.box.setLeftPen(new Pen());
                    }
                    Pen pen = this.box.getLeftPen();
                    pen.setLineWidth(this.spinnedModel.getNumber().floatValue());
                    break;
                }
                case BOTTOM: {
                    if (this.box.getBottomPen() == null) {
                        this.box.setBottomPen(new Pen());
                    }
                    Pen pen = this.box.getBottomPen();
                    pen.setLineWidth(this.spinnedModel.getNumber().floatValue());
                    break;
                }
                case RIGHT: {
                    if (this.box.getRightPen() == null) {
                        this.box.setRightPen(new Pen());
                    }
                    Pen pen = this.box.getRightPen();
                    pen.setLineWidth(this.spinnedModel.getNumber().floatValue());
                    break;
                }
            }
        }
        this.getSelectionPanel().repaint();
        this.fireActionPerformed();
    }

    public void colorChanged() {
        if (this.isInit() || this.box == null) {
            return;
        }
        Color color = this.colorSelector.getColor();
        ArrayList<BoxBorderSelectionPanel.Side> borders = new ArrayList<BoxBorderSelectionPanel.Side>();
        borders.addAll(this.selectionPanel.getSelectedBorders());
        if (borders.size() == 0) {
            Pen pen;
            if (this.box.getPen() == null && color != null) {
                this.box.setPen(new Pen());
            }
            if ((pen = this.box.getPen()) != null) {
                pen.setLineColor(color);
            }
            borders.add(BoxBorderSelectionPanel.Side.TOP);
            borders.add(BoxBorderSelectionPanel.Side.BOTTOM);
            borders.add(BoxBorderSelectionPanel.Side.LEFT);
            borders.add(BoxBorderSelectionPanel.Side.RIGHT);
        }
        for (BoxBorderSelectionPanel.Side s : borders) {
            switch (s) {
                case TOP: {
                    Pen pen;
                    if (this.box.getTopPen() == null && color != null) {
                        this.box.setTopPen(new Pen());
                    }
                    if ((pen = this.box.getTopPen()) == null) break;
                    pen.setLineColor(color);
                    break;
                }
                case LEFT: {
                    Pen pen;
                    if (this.box.getLeftPen() == null && color != null) {
                        this.box.setLeftPen(new Pen());
                    }
                    if ((pen = this.box.getLeftPen()) == null) break;
                    pen.setLineColor(color);
                    break;
                }
                case BOTTOM: {
                    Pen pen;
                    if (this.box.getBottomPen() == null && color != null) {
                        this.box.setBottomPen(new Pen());
                    }
                    if ((pen = this.box.getBottomPen()) == null) break;
                    pen.setLineColor(color);
                    break;
                }
                case RIGHT: {
                    Pen pen;
                    if (this.box.getRightPen() == null && color != null) {
                        this.box.setRightPen(new Pen());
                    }
                    if ((pen = this.box.getRightPen()) == null) break;
                    pen.setLineColor(color);
                    break;
                }
            }
        }
        this.getSelectionPanel().repaint();
        this.fireActionPerformed();
    }

    public void lineStyleChanged() {
        if (this.isInit() || this.box == null) {
            return;
        }
        String style = null;
        if (this.jList1.getSelectedIndex() >= 0) {
            style = (String)this.jList1.getSelectedValue();
        }
        ArrayList<BoxBorderSelectionPanel.Side> borders = new ArrayList<BoxBorderSelectionPanel.Side>();
        borders.addAll(this.selectionPanel.getSelectedBorders());
        if (borders.size() == 0) {
            if (this.box.getPen() == null) {
                this.box.setPen(new Pen());
            }
            Pen pen = this.box.getPen();
            pen.setLineStyle(style);
            borders.add(BoxBorderSelectionPanel.Side.TOP);
            borders.add(BoxBorderSelectionPanel.Side.BOTTOM);
            borders.add(BoxBorderSelectionPanel.Side.LEFT);
            borders.add(BoxBorderSelectionPanel.Side.RIGHT);
        }
        for (BoxBorderSelectionPanel.Side s : borders) {
            switch (s) {
                case TOP: {
                    if (this.box.getTopPen() == null) {
                        this.box.setTopPen(new Pen());
                    }
                    Pen pen = this.box.getTopPen();
                    pen.setLineStyle(style);
                    break;
                }
                case LEFT: {
                    if (this.box.getLeftPen() == null) {
                        this.box.setLeftPen(new Pen());
                    }
                    Pen pen = this.box.getLeftPen();
                    pen.setLineStyle(style);
                    break;
                }
                case BOTTOM: {
                    if (this.box.getBottomPen() == null) {
                        this.box.setBottomPen(new Pen());
                    }
                    Pen pen = this.box.getBottomPen();
                    pen.setLineStyle(style);
                    break;
                }
                case RIGHT: {
                    if (this.box.getRightPen() == null) {
                        this.box.setRightPen(new Pen());
                    }
                    Pen pen = this.box.getRightPen();
                    pen.setLineStyle(style);
                    break;
                }
            }
        }
        this.getSelectionPanel().repaint();
        this.fireActionPerformed();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jPanelPreview = new JPanel();
        this.jButton1 = new JButton();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jSpinnerLineWidth = new JSpinner();
        this.jLabel3 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = new JList();
        this.jLabel2 = new JLabel();
        this.jPanelColorSelector = new JPanel();
        this.jPanel4 = new JPanel();
        this.setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanelPreview.setBorder(BorderFactory.createBevelBorder(1));
        this.jPanelPreview.setMinimumSize(new Dimension(120, 80));
        this.jPanelPreview.setPreferredSize(new Dimension(120, 80));
        this.jPanelPreview.setLayout(new BorderLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(8, 4, 4, 4);
        this.jPanel1.add((Component)this.jPanelPreview, gridBagConstraints);
        this.jButton1.setText("Restore defaults");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BoxBorderEditorPanel.this.jButton1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.jButton1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 11;
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel2.setMinimumSize(new Dimension(200, 150));
        this.jPanel2.setPreferredSize(new Dimension(200, 150));
        this.jPanel2.setLayout(new GridBagLayout());
        this.jLabel1.setText("Line width");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(8, 4, 4, 4);
        this.jPanel2.add((Component)this.jLabel1, gridBagConstraints);
        this.jSpinnerLineWidth.setMinimumSize(new Dimension(120, 20));
        this.jSpinnerLineWidth.setPreferredSize(new Dimension(120, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 0, 0, 8);
        this.jPanel2.add((Component)this.jSpinnerLineWidth, gridBagConstraints);
        this.jLabel3.setText("Line Style");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(8, 4, 4, 4);
        this.jPanel2.add((Component)this.jLabel3, gridBagConstraints);
        this.jScrollPane1.setMinimumSize(new Dimension(120, 80));
        this.jScrollPane1.setPreferredSize(new Dimension(120, 80));
        this.jList1.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.jList1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(8, 0, 0, 8);
        this.jPanel2.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jLabel2.setText("Line color");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(8, 4, 4, 4);
        this.jPanel2.add((Component)this.jLabel2, gridBagConstraints);
        this.jPanelColorSelector.setBackground(new Color(255, 255, 255));
        this.jPanelColorSelector.setBorder(BorderFactory.createLineBorder(SystemColor.controlShadow));
        this.jPanelColorSelector.setMinimumSize(new Dimension(50, 20));
        this.jPanelColorSelector.setPreferredSize(new Dimension(120, 20));
        this.jPanelColorSelector.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(8, 0, 0, 8);
        this.jPanel2.add((Component)this.jPanelColorSelector, gridBagConstraints);
        this.jPanel4.setLayout(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 100;
        gridBagConstraints.weighty = 1.0;
        this.jPanel2.add((Component)this.jPanel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel2, gridBagConstraints);
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        if (this.box == null) {
            return;
        }
        ArrayList<BoxBorderSelectionPanel.Side> borders = new ArrayList<BoxBorderSelectionPanel.Side>();
        borders.addAll(this.selectionPanel.getSelectedBorders());
        if (borders.size() == 0) {
            this.box.setPen(null);
            borders.add(BoxBorderSelectionPanel.Side.TOP);
            borders.add(BoxBorderSelectionPanel.Side.BOTTOM);
            borders.add(BoxBorderSelectionPanel.Side.LEFT);
            borders.add(BoxBorderSelectionPanel.Side.RIGHT);
        }
        for (BoxBorderSelectionPanel.Side s : borders) {
            switch (s) {
                case TOP: {
                    this.box.setTopPen(null);
                    break;
                }
                case LEFT: {
                    this.box.setLeftPen(null);
                    break;
                }
                case BOTTOM: {
                    this.box.setBottomPen(null);
                    break;
                }
                case RIGHT: {
                    this.box.setRightPen(null);
                }
            }
        }
        this.selectionChanged(borders);
        this.getSelectionPanel().repaint();
        this.fireActionPerformed();
    }

    public BoxBorderSelectionPanel getSelectionPanel() {
        return this.selectionPanel;
    }

    public void setSelectionPanel(BoxBorderSelectionPanel selectionPanel) {
        this.selectionPanel = selectionPanel;
    }

    public Box getBox() {
        return this.box;
    }

    public void setBox(Box box) {
        boolean oldInit = this.isInit();
        this.setInit(true);
        this.box = box;
        this.setInit(oldInit);
        this.getSelectionPanel().clearSelection();
        this.getSelectionPanel().setBox(box);
        this.getSelectionPanel().repaint();
    }

    public boolean isInit() {
        return this.init;
    }

    public void setInit(boolean init) {
        this.init = init;
    }
}

