/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui;

import it.businesslogic.ireport.JRField;
import it.businesslogic.ireport.JRParameter;
import it.businesslogic.ireport.JRVariable;
import it.businesslogic.ireport.JasperTemplate;
import it.businesslogic.ireport.ReportElement;
import it.businesslogic.ireport.Style;
import it.businesslogic.ireport.Template;
import it.businesslogic.ireport.TemplateStyle;
import it.businesslogic.ireport.UndefinedStyle;
import it.businesslogic.ireport.gui.JReportFrame;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.gui.ReportPanelToolTip;
import it.businesslogic.ireport.gui.event.ReportElementChangedEvent;
import it.businesslogic.ireport.gui.library.AbstractLibraryObject;
import it.businesslogic.ireport.util.Misc;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;

public class JReportPanel
extends JPanel
implements DropTargetListener {
    private JReportFrame jrf = null;
    public int ccc = 0;
    private ReportPanelToolTip rptt = null;

    public JReportPanel() {
        this.setBackground(new Color(128, 128, 128));
        new DropTarget(this, 3, this);
        this.setIgnoreRepaint(true);
        AbstractAction openPropertiesDialog = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.getMainInstance().getElementPropertiesDialog().setVisible(!MainFrame.getMainInstance().getElementPropertiesDialog().isVisible());
            }
        };
        this.getInputMap().put(KeyStroke.getKeyStroke(525, 0), "openPropertiesDialog");
        this.getActionMap().put("openPropertiesDialog", openPropertiesDialog);
        AbstractAction selectNextReportElement = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                if (JReportPanel.this.getJrf() == null) {
                    return;
                }
                Vector reportElements = JReportPanel.this.getJrf().getReport().getElements();
                if (reportElements.size() == 0) {
                    return;
                }
                Vector selectedElements = JReportPanel.this.getJrf().getSelectedElements();
                if (selectedElements.size() == 0) {
                    JReportPanel.this.getJrf().setSelectedElement((ReportElement)reportElements.elementAt(0), true);
                } else if (selectedElements.size() == 1 && reportElements.size() > 0) {
                    ReportElement selectedElem = (ReportElement)selectedElements.elementAt(0);
                    for (int i = 0; i < reportElements.size(); ++i) {
                        ReportElement re = (ReportElement)reportElements.elementAt(i);
                        if (re != selectedElem) continue;
                        i = (i + 1) % reportElements.size();
                        JReportPanel.this.getJrf().setSelectedElement((ReportElement)reportElements.elementAt(i), true);
                        return;
                    }
                }
            }
        };
        this.getInputMap().put(KeyStroke.getKeyStroke(102, 0), "selectNextReportElement");
        this.getInputMap().put(KeyStroke.getKeyStroke(46, 0), "selectNextReportElement");
        this.getActionMap().put("selectNextReportElement", selectNextReportElement);
        AbstractAction selectPrevReportElement = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                if (JReportPanel.this.getJrf() == null) {
                    return;
                }
                Vector reportElements = JReportPanel.this.getJrf().getReport().getElements();
                if (reportElements.size() == 0) {
                    return;
                }
                Vector selectedElements = JReportPanel.this.getJrf().getSelectedElements();
                if (selectedElements.size() == 0) {
                    JReportPanel.this.getJrf().setSelectedElement((ReportElement)reportElements.elementAt(0), true);
                } else if (selectedElements.size() == 1 && reportElements.size() > 0) {
                    ReportElement selectedElem = (ReportElement)selectedElements.elementAt(0);
                    for (int i = 0; i < reportElements.size(); ++i) {
                        ReportElement re = (ReportElement)reportElements.elementAt(i);
                        if (re != selectedElem) continue;
                        i = (i + reportElements.size() - 1) % reportElements.size();
                        JReportPanel.this.getJrf().setSelectedElement((ReportElement)reportElements.elementAt(i), true);
                        return;
                    }
                }
            }
        };
        this.getInputMap().put(KeyStroke.getKeyStroke(100, 0), "selectPrevReportElement");
        this.getInputMap().put(KeyStroke.getKeyStroke(44, 0), "selectPrevReportElement");
        this.getActionMap().put("selectPrevReportElement", selectPrevReportElement);
    }

    protected void paintComponent(Graphics g) {
        try {
            ++this.ccc;
            if (this.jrf != null) {
                this.jrf.paintReportPanel(g);
            } else {
                super.paint(g);
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    public JReportFrame getJrf() {
        return this.jrf;
    }

    public void setJrf(JReportFrame jrf) {
        this.jrf = jrf;
        if (this.rptt != null) {
            this.rptt.setReportFrame(jrf);
        }
    }

    public Point getToolTipLocation(MouseEvent event) {
        return new Point(event.getX() + 30, event.getY() + 30);
    }

    public void dragEnter(DropTargetDragEvent dtde) {
        dtde.acceptDrag(dtde.getDropAction());
    }

    public void dragExit(DropTargetEvent dte) {
    }

    public void dragOver(DropTargetDragEvent dtde) {
        if (!this.jrf.isInsideDocument(dtde.getLocation())) {
            dtde.rejectDrag();
        } else {
            dtde.acceptDrag(dtde.getDropAction());
        }
    }

    public void drop(DropTargetDropEvent dtde) {
        try {
            DropTargetContext context = dtde.getDropTargetContext();
            Transferable tr = dtde.getTransferable();
            DataFlavor[] df = tr.getTransferDataFlavors();
            if (df[0].getHumanPresentableName().equals("it.businesslogic.ireport.JRField")) {
                DataFlavor myFlavor = new DataFlavor(JRField.class, JRField.class.getName());
                JRField field = (JRField)tr.getTransferData(myFlavor);
                this.jrf.dropNewTextField(dtde.getLocation(), "$F{" + field.getName() + "}", field.getClassType());
            } else if (df[0].getHumanPresentableName().equals("it.businesslogic.ireport.JRVariable")) {
                DataFlavor myFlavor = new DataFlavor(JRVariable.class, JRVariable.class.getName());
                JRVariable var = (JRVariable)tr.getTransferData(myFlavor);
                this.jrf.dropNewTextField(dtde.getLocation(), "$V{" + var.getName() + "}", var.getClassType());
            } else if (df[0].getHumanPresentableName().equals("it.businesslogic.ireport.JRParameter")) {
                DataFlavor myFlavor = new DataFlavor(JRParameter.class, JRParameter.class.getName());
                JRParameter var = (JRParameter)tr.getTransferData(myFlavor);
                this.jrf.dropNewTextField(dtde.getLocation(), "$P{" + var.getName() + "}", var.getClassType());
            } else if (tr.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                dtde.acceptDrop(3);
                List fileList = (List)tr.getTransferData(DataFlavor.javaFileListFlavor);
                MainFrame.getMainInstance().openFiles(fileList);
            } else if (df[0].getHumanPresentableName().equals("it.businesslogic.ireport.Style") || df[0].getHumanPresentableName().equals("it.businesslogic.ireport.UndefinedStyle")) {
                Class<?> clazz = Class.forName(df[0].getHumanPresentableName());
                DataFlavor myFlavor = new DataFlavor(clazz, clazz.getName());
                Style var = (Style)tr.getTransferData(myFlavor);
                ReportElement re = this.jrf.getElementAt(dtde.getLocation());
                if (re != null) {
                    if (!this.jrf.getReport().getStyles().contains(var)) {
                        boolean found = false;
                        for (int i = 0; i < this.jrf.getReport().getStyles().size(); ++i) {
                            Style s = (Style)this.jrf.getReport().getStyles().elementAt(i);
                            if (s.getName() == null || !s.getName().equals(var.getName())) continue;
                            var = s;
                            found = true;
                            break;
                        }
                        if (!found) {
                            var = new Style(var);
                            this.jrf.getReport().addStyle(var);
                        }
                    }
                    re.setStyle(var);
                    this.jrf.fireReportListenerReportElementsChanged(new ReportElementChangedEvent(this.jrf, re, 3));
                    this.repaint();
                }
            } else if (df[0].getHumanPresentableName().equals("it.businesslogic.ireport.TemplateStyle")) {
                Class<?> clazz = Class.forName(df[0].getHumanPresentableName());
                DataFlavor myFlavor = new DataFlavor(clazz, clazz.getName());
                TemplateStyle var = (TemplateStyle)tr.getTransferData(myFlavor);
                ReportElement re = this.jrf.getElementAt(dtde.getLocation());
                if (re != null) {
                    Style us = new UndefinedStyle(var);
                    boolean found = false;
                    if (!this.jrf.getReport().getStyles().contains(var)) {
                        for (int i = 0; i < this.jrf.getReport().getStyles().size(); ++i) {
                            Style s = (Style)this.jrf.getReport().getStyles().elementAt(i);
                            if (s.getName() == null || !s.getName().equals(var.getName())) continue;
                            us = s;
                            found = true;
                            break;
                        }
                    }
                    JasperTemplate jt = var.getJasperTemplate();
                    boolean templateFound = false;
                    if (jt.getFilename() != null) {
                        String exp = "\"" + jt.getFilename() + "\"";
                        exp = Misc.string_replace("\\\\", "\\", exp);
                        for (int i = 0; i < this.jrf.getReport().getTemplates().size(); ++i) {
                            Template t = (Template)this.jrf.getReport().getTemplates().elementAt(i);
                            if (t.getExpression() == null || !t.getExpression().equals(exp)) continue;
                            templateFound = true;
                            break;
                        }
                        if (!templateFound) {
                            this.jrf.getReport().addTemplate(new Template(exp, "java.lang.String"));
                        }
                    }
                    if (!found) {
                        this.jrf.getReport().addStyle(us);
                    }
                    re.setStyle(us);
                    this.jrf.fireReportListenerReportElementsChanged(new ReportElementChangedEvent(this.jrf, re, 3));
                    this.repaint();
                }
            } else {
                try {
                    Class<?> c = Class.forName(df[0].getHumanPresentableName());
                    if (AbstractLibraryObject.class.isAssignableFrom(c)) {
                        DataFlavor myFlavor = new DataFlavor(c, df[0].getHumanPresentableName());
                        Object obj = tr.getTransferData(myFlavor);
                        ((AbstractLibraryObject)obj).drop(dtde);
                    } else {
                        System.out.println("Dropped a " + df[0].getHumanPresentableName());
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            context.dropComplete(true);
        }
        catch (Exception ex) {
            System.out.println("Error in drop!");
            ex.printStackTrace();
        }
        MainFrame.getMainInstance().getGlassPane().setVisible(false);
        this.jrf.setRedrawWithBufferedImage(false);
        this.jrf.repaint();
    }

    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    public JToolTip createToolTip() {
        if (this.rptt == null) {
            this.rptt = new ReportPanelToolTip(this.getJrf());
        }
        return this.rptt;
    }
}

