/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.connection;

import it.businesslogic.ireport.IReportConnection;
import it.businesslogic.ireport.IReportConnectionEditor;
import it.businesslogic.ireport.ReportClassLoader;
import it.businesslogic.ireport.connection.gui.EJBQLConnectionEditor;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.util.I18n;
import it.businesslogic.ireport.util.Misc;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.util.HashMap;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import net.sf.jasperreports.engine.JRDataSource;

public class EJBQLConnection
extends IReportConnection {
    private String name;
    private HashMap map = new HashMap();
    private String persistenceUnit;
    private EntityManager em = null;
    private EntityManagerFactory emf = null;
    private int usedby = 0;

    public Connection getConnection() {
        return null;
    }

    public boolean isJDBCConnection() {
        return false;
    }

    public boolean isJRDataSource() {
        return false;
    }

    public HashMap getProperties() {
        return this.map;
    }

    public void loadProperties(HashMap map) {
        this.map = map;
    }

    public JRDataSource getJRDataSource() {
        return null;
    }

    public EntityManager getEntityManager() throws Exception {
        if (this.em == null) {
            if (this.emf == null) {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                if (cl instanceof ReportClassLoader) {
                    List items = ((ReportClassLoader)cl).getCachedItems();
                    URL[] urls = new URL[items.size()];
                    for (int i = 0; i < items.size(); ++i) {
                        urls[i] = new File("" + items.get(i)).toURL();
                    }
                    URLClassLoader urlClassLoader = new URLClassLoader(urls, cl);
                    Thread.currentThread().setContextClassLoader(urlClassLoader);
                }
                this.emf = Persistence.createEntityManagerFactory((String)Misc.nvl(this.getProperties().get("PersistenceUnit"), null), new HashMap());
            }
            this.em = this.emf.createEntityManager();
        }
        ++this.usedby;
        return this.em;
    }

    public void closeEntityManager() {
        try {
            if (this.em != null) {
                --this.usedby;
                if (this.usedby == 0) {
                    this.em.close();
                    this.em = null;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getDescription() {
        return I18n.getString("connectionType.ejbql", "EJBQL connection");
    }

    public IReportConnectionEditor getIReportConnectionEditor() {
        return new EJBQLConnectionEditor();
    }

    public void test() throws Exception {
        try {
            SwingUtilities.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Thread.currentThread().setContextClassLoader(MainFrame.getMainInstance().getReportClassLoader());
                    try {
                        try {
                            EJBQLConnection.this.getEntityManager();
                            EJBQLConnection.this.closeEntityManager();
                            JOptionPane.showMessageDialog(MainFrame.getMainInstance(), I18n.getString("messages.connectionDialog.connectionTestSuccessful", "Connection test successful!"), "", 1);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            JOptionPane.showMessageDialog(MainFrame.getMainInstance(), ex.getMessage(), I18n.getString("message.title.error", "Error"), 0);
                            Object var3_2 = null;
                            return;
                        }
                        Object var3_1 = null;
                    }
                    catch (Throwable throwable) {
                        Object var3_3 = null;
                        throw throwable;
                    }
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

