/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.chart;

import it.businesslogic.ireport.IReportScriptlet;
import java.awt.Color;
import java.awt.Image;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public abstract class ChartFactory {
    public static Image drawChart(String[] parameters, IReportScriptlet scriptlet) {
        return null;
    }

    protected static int getParameterAsInteger(String name, Properties props, int defaultValue) {
        String val = props.getProperty(name, "" + defaultValue);
        try {
            return Integer.parseInt(val);
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    protected static double getParameterAsDouble(String name, Properties props, double defaultValue) {
        String val = props.getProperty(name, "" + defaultValue);
        try {
            return Double.parseDouble(val);
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    protected static boolean getParameterAsBoolean(String name, Properties props, boolean defaultValue) {
        String val = props.getProperty(name, "" + defaultValue);
        try {
            return val.toUpperCase().equals("TRUE");
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    protected static Color getParameterAsColor(String name, Properties props, Color defaultValue) {
        String val = props.getProperty(name, "");
        try {
            Color c = ChartFactory.parseColorString(val);
            if (c != null) {
                return c;
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return defaultValue;
    }

    protected static Vector getSeries(String name, Properties props, IReportScriptlet scriptlet) {
        if (scriptlet == null) {
            Vector<Double> v = new Vector<Double>();
            v.add(new Double(1.0));
            v.add(new Double(5.0));
            v.add(new Double(3.0));
            v.add(new Double(8.0));
            v.add(new Double(3.0));
            v.add(new Double(5.0));
            v.add(new Double(1.0));
            v.add(new Double(7.0));
            v.add(new Double(6.0));
            v.add(new Double(9.0));
            return v;
        }
        if (!props.containsKey(name)) {
            return new Vector();
        }
        String varName = props.getProperty(name);
        return scriptlet.getSerie(varName);
    }

    public static Color parseColorString(String newValue) {
        if (newValue == null) {
            return null;
        }
        if (!(newValue = newValue.trim()).startsWith("[") || !newValue.endsWith("]")) {
            return null;
        }
        int r = 0;
        int g = 0;
        int b = 0;
        String rgbValues = newValue.substring(1, newValue.length() - 1);
        try {
            StringTokenizer st = new StringTokenizer(rgbValues, ",", false);
            r = Integer.parseInt(st.nextToken());
            g = Integer.parseInt(st.nextToken());
            b = Integer.parseInt(st.nextToken());
        }
        catch (Exception ex) {
            return null;
        }
        Color c = new Color(r, g, b);
        return c;
    }
}

