/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.chart;

import it.businesslogic.ireport.SubDataset;
import it.businesslogic.ireport.chart.SectionItemHyperlink;
import it.businesslogic.ireport.chart.gui.SectionItemHyperlinkPanel;
import it.businesslogic.ireport.gui.JRTextExpressionArea;
import it.businesslogic.ireport.util.I18n;
import it.businesslogic.ireport.util.Misc;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;

public class CategorySeriesDialog
extends JDialog {
    private String seriesExpression = "";
    private String categoryExpression = "";
    private String valueExpression = "";
    private String labelExpression = "";
    private int dialogResult = 2;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JLabel jLabelCategoryExpression;
    private JLabel jLabelLabelExpression;
    private JLabel jLabelSeriesExpression;
    private JLabel jLabelValueExpression;
    private JPanel jPanel1;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JRTextExpressionArea jRTextExpressionCategory;
    private JRTextExpressionArea jRTextExpressionLabel;
    private JRTextExpressionArea jRTextExpressionSeries;
    private JRTextExpressionArea jRTextExpressionValue;
    private JTabbedPane jTabbedPane1;
    private SectionItemHyperlinkPanel sectionItemHyperlinkPanel1;
    public static final int COMPONENT_NONE = 0;
    public static final int COMPONENT_CATEGORY_EXPRESSION = 1;
    public static final int COMPONENT_SERIES_EXPRESSION = 2;
    public static final int COMPONENT_VALUE_EXPRESSION = 3;
    public static final int COMPONENT_LABEL_EXPRESSION = 4;
    public static final int COMPONENT_HYPERLINK = 100;

    public CategorySeriesDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.applyI18n();
        this.setSize(500, 500);
        Misc.centerFrame(this);
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                CategorySeriesDialog.this.jButtonCancelActionPerformed(e);
            }
        };
        this.getRootPane().getInputMap(2).put(escape, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", escapeAction);
        this.getRootPane().setDefaultButton(this.jButtonOK);
    }

    public void setSubDataset(SubDataset sds) {
        this.jRTextExpressionCategory.setSubDataset(sds);
        this.jRTextExpressionLabel.setSubDataset(sds);
        this.jRTextExpressionSeries.setSubDataset(sds);
        this.jRTextExpressionValue.setSubDataset(sds);
        this.sectionItemHyperlinkPanel1.setSubDataset(sds);
    }

    private void initComponents() {
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel1 = new JPanel();
        this.jLabelSeriesExpression = new JLabel();
        this.jLabelCategoryExpression = new JLabel();
        this.jLabelValueExpression = new JLabel();
        this.jLabelLabelExpression = new JLabel();
        this.jRTextExpressionSeries = new JRTextExpressionArea();
        this.jRTextExpressionCategory = new JRTextExpressionArea();
        this.jRTextExpressionValue = new JRTextExpressionArea();
        this.jRTextExpressionLabel = new JRTextExpressionArea();
        this.sectionItemHyperlinkPanel1 = new SectionItemHyperlinkPanel();
        this.jPanel6 = new JPanel();
        this.jPanel7 = new JPanel();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent evt) {
                CategorySeriesDialog.this.formWindowOpened(evt);
            }
        });
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabelSeriesExpression.setText("Series expression (required)");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.jLabelSeriesExpression, gridBagConstraints);
        this.jLabelCategoryExpression.setText("Category expression (required)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.jPanel1.add((Component)this.jLabelCategoryExpression, gridBagConstraints);
        this.jLabelValueExpression.setText("Value expression (required)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.jPanel1.add((Component)this.jLabelValueExpression, gridBagConstraints);
        this.jLabelLabelExpression.setText("Label expression");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.jPanel1.add((Component)this.jLabelLabelExpression, gridBagConstraints);
        this.jRTextExpressionSeries.setBorder(BorderFactory.createEtchedBorder());
        this.jRTextExpressionSeries.setElectricScroll(0);
        this.jRTextExpressionSeries.setMinimumSize(new Dimension(10, 10));
        this.jRTextExpressionSeries.setPreferredSize(new Dimension(10, 10));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jRTextExpressionSeries, gridBagConstraints);
        this.jRTextExpressionCategory.setBorder(BorderFactory.createEtchedBorder());
        this.jRTextExpressionCategory.setElectricScroll(0);
        this.jRTextExpressionCategory.setMinimumSize(new Dimension(10, 10));
        this.jRTextExpressionCategory.setPreferredSize(new Dimension(10, 10));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jRTextExpressionCategory, gridBagConstraints);
        this.jRTextExpressionValue.setBorder(BorderFactory.createEtchedBorder());
        this.jRTextExpressionValue.setElectricScroll(0);
        this.jRTextExpressionValue.setMinimumSize(new Dimension(10, 10));
        this.jRTextExpressionValue.setPreferredSize(new Dimension(10, 10));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jRTextExpressionValue, gridBagConstraints);
        this.jRTextExpressionLabel.setBorder(BorderFactory.createEtchedBorder());
        this.jRTextExpressionLabel.setElectricScroll(0);
        this.jRTextExpressionLabel.setMinimumSize(new Dimension(10, 10));
        this.jRTextExpressionLabel.setPreferredSize(new Dimension(10, 10));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jRTextExpressionLabel, gridBagConstraints);
        this.jTabbedPane1.addTab("Data", this.jPanel1);
        this.jTabbedPane1.addTab("Item hyperlink", this.sectionItemHyperlinkPanel1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jTabbedPane1, gridBagConstraints);
        this.jPanel6.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel6.add((Component)this.jPanel7, gridBagConstraints);
        this.jButtonOK.setMnemonic('o');
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CategorySeriesDialog.this.jButtonOKActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel6.add((Component)this.jButtonOK, gridBagConstraints);
        this.jButtonCancel.setMnemonic('c');
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CategorySeriesDialog.this.jButtonCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.jPanel6.add((Component)this.jButtonCancel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.jPanel6, gridBagConstraints);
        this.pack();
    }

    private void formWindowOpened(WindowEvent evt) {
        this.sectionItemHyperlinkPanel1.openExtraWindows();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        this.seriesExpression = this.jRTextExpressionSeries.getText();
        this.categoryExpression = this.jRTextExpressionCategory.getText();
        this.valueExpression = this.jRTextExpressionValue.getText();
        this.labelExpression = this.jRTextExpressionLabel.getText();
        MessageFormat formatter = new MessageFormat(I18n.getString("gui.notvalidexp", "{0} cannot be blank!"));
        if (this.seriesExpression.trim().length() == 0) {
            JOptionPane.showMessageDialog(this, formatter.format(new Object[]{I18n.getString("charts.seriesExpression", "Series expression")}), I18n.getString("message.title.invalidExpression", "Invalid expression"), 0);
            return;
        }
        if (this.categoryExpression.trim().length() == 0) {
            JOptionPane.showMessageDialog(this, formatter.format(new Object[]{I18n.getString("charts.categoryExpression", "Category expression")}), I18n.getString("message.title.invalidExpression", "Invalid expression"), 0);
            return;
        }
        if (this.valueExpression.trim().length() == 0) {
            JOptionPane.showMessageDialog(this, formatter.format(new Object[]{I18n.getString("charts.valueExpression", "Value expression")}), I18n.getString("message.title.invalidExpression", "Invalid expression"), 0);
            return;
        }
        this.setDialogResult(0);
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new CategorySeriesDialog((Frame)new JFrame(), true).setVisible(true);
            }
        });
    }

    public String getSeriesExpression() {
        return this.seriesExpression;
    }

    public void setSeriesExpression(String seriesExpression) {
        this.seriesExpression = seriesExpression;
        this.jRTextExpressionSeries.setText(seriesExpression);
    }

    public String getCategoryExpression() {
        return this.categoryExpression;
    }

    public void setCategoryExpression(String categoryExpression) {
        this.categoryExpression = categoryExpression;
        this.jRTextExpressionCategory.setText(categoryExpression);
    }

    public String getValueExpression() {
        return this.valueExpression;
    }

    public void setValueExpression(String valueExpression) {
        this.valueExpression = valueExpression;
        this.jRTextExpressionValue.setText(valueExpression);
    }

    public String getLabelExpression() {
        return this.labelExpression;
    }

    public void setLabelExpression(String labelExpression) {
        this.labelExpression = labelExpression;
        this.jRTextExpressionLabel.setText(labelExpression);
    }

    public void setSectionItemHyperlink(SectionItemHyperlink sectionItemHyperlink) {
        this.sectionItemHyperlinkPanel1.setSectionItemHyperlink(sectionItemHyperlink.cloneMe());
    }

    public SectionItemHyperlink getSectionItemHyperlink() {
        return this.sectionItemHyperlinkPanel1.getSectionItemHyperlink();
    }

    public int getDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }

    public void applyI18n() {
        this.jButtonOK.setText(I18n.getString("ok", "Ok"));
        this.jButtonCancel.setText(I18n.getString("cancel", "Cancel"));
        this.jLabelCategoryExpression.setText(I18n.getString("charts.categoryExpression", "Category expression"));
        this.jLabelSeriesExpression.setText(I18n.getString("charts.seriesExpression", "Series expression"));
        this.jLabelValueExpression.setText(I18n.getString("charts.valueExpression", "Value expression"));
        this.jLabelLabelExpression.setText(I18n.getString("charts.labelExpression", "Label expression"));
        this.jTabbedPane1.setTitleAt(0, I18n.getString("chartSeries.tab.Data", "Data"));
        this.jTabbedPane1.setTitleAt(1, I18n.getString("chartSeries.tab.ItemHyperlink", "Item hyperlink"));
        this.setTitle(I18n.getString("gui.ChartPropertiesDialog.title", "Chart properties"));
        this.getRootPane().updateUI();
    }

    public void setFocusedExpression(Object[] expressionInfo) {
        if (expressionInfo == null) {
            return;
        }
        int expID = (Integer)expressionInfo[0];
        switch (expID) {
            case 1: {
                Misc.selectTextAndFocusArea(this.jRTextExpressionCategory);
                break;
            }
            case 2: {
                Misc.selectTextAndFocusArea(this.jRTextExpressionSeries);
                break;
            }
            case 3: {
                Misc.selectTextAndFocusArea(this.jRTextExpressionValue);
                break;
            }
            case 4: {
                Misc.selectTextAndFocusArea(this.jRTextExpressionLabel);
                break;
            }
            case 100: {
                this.jTabbedPane1.setSelectedComponent(this.sectionItemHyperlinkPanel1);
                Object[] newInfo = new Object[expressionInfo.length - 1];
                for (int i = 1; i < expressionInfo.length; ++i) {
                    newInfo[i - 1] = expressionInfo[i];
                }
                this.sectionItemHyperlinkPanel1.setFocusedExpression(newInfo);
            }
        }
    }
}

